/*
 * Decompiled with CFR 0.152.
 */
package p1xel.nobuildplus.Listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import p1xel.nobuildplus.NoBuildPlus;
import p1xel.nobuildplus.Storage.FlagsManager;
import p1xel.nobuildplus.Storage.Locale;
import p1xel.nobuildplus.Storage.Worlds;

public class GUIManager
implements Listener {
    public static GUIManager instance = new GUIManager();
    HashMap<String, Inventory> guis = new HashMap();

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        HumanEntity entity = e.getWhoClicked();
        if (!(entity instanceof Player)) {
            return;
        }
        Inventory inventory = e.getClickedInventory();
        if (inventory == null) {
            return;
        }
        Player p = (Player)entity;
        if (p.getOpenInventory().getTitle().contains(Locale.getMessage("gui.title"))) {
            ItemStack id = inventory.getItem(0);
            NamespacedKey keyId = new NamespacedKey((Plugin)NoBuildPlus.getInstance(), "inventory");
            String world = (String)id.getItemMeta().getPersistentDataContainer().get(keyId, PersistentDataType.STRING);
            int slot = e.getSlot();
            ItemStack item = e.getCurrentItem();
            if (slot == 0 || slot == 8) {
                e.setCancelled(true);
                return;
            }
            if (slot == 45) {
                if (item == null) {
                    e.setCancelled(true);
                    return;
                }
                NamespacedKey page_id = new NamespacedKey((Plugin)NoBuildPlus.getInstance(), "page");
                int page = Integer.parseInt((String)inventory.getItem(8).getItemMeta().getPersistentDataContainer().get(page_id, PersistentDataType.STRING));
                if (page - 1 == 0) {
                    e.setCancelled(true);
                    return;
                }
                p.openInventory(instance.getGUI(world + "_page" + (page - 1)));
                e.setCancelled(true);
                return;
            }
            if (slot == 53) {
                int max_page;
                if (item == null) {
                    e.setCancelled(true);
                    return;
                }
                NamespacedKey page_id = new NamespacedKey((Plugin)NoBuildPlus.getInstance(), "page");
                int page = Integer.parseInt((String)inventory.getItem(8).getItemMeta().getPersistentDataContainer().get(page_id, PersistentDataType.STRING));
                if (page + 1 > (max_page = FlagsManager.getMaxPage(FlagsManager.getFlags()))) {
                    e.setCancelled(true);
                    return;
                }
                p.openInventory(instance.getGUI(world + "_page" + (page + 1)));
                e.setCancelled(true);
                return;
            }
            if (item != null) {
                ItemMeta meta = item.getItemMeta();
                NamespacedKey key = new NamespacedKey((Plugin)NoBuildPlus.getInstance(), "flag");
                String flag = (String)meta.getPersistentDataContainer().get(key, PersistentDataType.STRING);
                boolean bool = Worlds.getFlag(world, flag);
                bool = !bool;
                Worlds.setFlag(world, flag, bool);
                meta.setDisplayName(Locale.getMessage("gui.display_name").replaceAll("%flag%", flag).replaceAll("%bool%", Locale.getMessage(String.valueOf(bool))));
                item.setItemMeta(meta);
                inventory.setItem(slot, item);
                e.setCancelled(true);
                return;
            }
            e.setCancelled(true);
        }
    }

    public Inventory getGUI(String world) {
        return this.guis.get(world);
    }

    public void initialization() {
        for (String world : Worlds.yaml.getKeys(false)) {
            this.createInv(world);
        }
        Bukkit.getLogger().info("Initialization completed: " + this.guis.toString());
    }

    ItemStack getIconItem(ItemStack item, String locale_path, String key, String data) {
        ItemMeta meta = item.getItemMeta();
        NamespacedKey n_key = new NamespacedKey((Plugin)NoBuildPlus.getInstance(), key);
        meta.getPersistentDataContainer().set(n_key, PersistentDataType.STRING, (Object)data);
        meta.setDisplayName(Locale.getMessage("gui." + locale_path));
        item.setItemMeta(meta);
        return item;
    }

    public void createInv(String world) {
        List<String> flags = FlagsManager.getFlags();
        int max_page = FlagsManager.getMaxPage(flags);
        int a = 1;
        for (int i = 1; i <= max_page; ++i) {
            Inventory gui = Bukkit.createInventory(null, (int)54, (String)(Locale.getMessage("gui.title") + " " + world));
            if (i != max_page) {
                gui.setItem(53, this.getIconItem(new ItemStack(Material.PAPER), "page_next", "function", "next"));
            }
            if (i != 1) {
                gui.setItem(45, this.getIconItem(new ItemStack(Material.PAPER), "page_previous", "function", "previous"));
            }
            gui.setItem(0, this.getIconItem(new ItemStack(Material.WHITE_STAINED_GLASS_PANE), "world", "inventory", world));
            gui.setItem(8, this.getIconItem(new ItemStack(Material.WHITE_STAINED_GLASS_PANE), "page", "page", String.valueOf(i)));
            for (int c = 0; c < 28; ++c) {
                String flag = flags.get(a - 1);
                int slot = FlagsManager.getSlot(flag);
                Material mat = Material.matchMaterial((String)FlagsManager.getShowedItem(flag).toUpperCase());
                if (mat == null) {
                    Bukkit.getLogger().info("[NBP] Could not find show-item for " + flag + "!");
                    break;
                }
                ItemStack item = new ItemStack(mat);
                ItemMeta meta = item.getItemMeta();
                boolean bool = Worlds.getFlag(world, flag);
                assert (meta != null);
                meta.setDisplayName(Locale.getMessage("gui.display_name").replaceAll("%flag%", flag).replaceAll("%bool%", Locale.getMessage(String.valueOf(bool))));
                ArrayList<String> lores = new ArrayList<String>();
                for (String l : Locale.yaml.getStringList("gui.lore")) {
                    l = Locale.translate(l);
                    l = l.replaceAll("%flag%", flag);
                    l = l.replaceAll("%bool%", String.valueOf(bool));
                    l = l.replaceAll("%description%", Locale.getMessage("gui.description." + flag));
                    lores.add(l);
                }
                meta.setLore(lores);
                NamespacedKey key = new NamespacedKey((Plugin)NoBuildPlus.getInstance(), "flag");
                meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)flag);
                item.setItemMeta(meta);
                gui.setItem(slot, item);
                if (++a / (i * 28) > 1 || a > flags.size()) break;
            }
            this.guis.put(world + "_page" + i, gui);
        }
    }

    public void updateFlag(String world, String flag, boolean bool) {
        int max_page = FlagsManager.getMaxPage(FlagsManager.getFlags());
        for (int i = 1; i <= max_page; ++i) {
            Inventory gui = this.guis.get(world + "_page" + i);
            for (ItemStack item : gui.getContents()) {
                ItemMeta meta;
                if (item == null || (meta = item.getItemMeta()) == null) continue;
                NamespacedKey key = new NamespacedKey((Plugin)NoBuildPlus.getInstance(), "flag");
                if (!meta.getPersistentDataContainer().has(key, PersistentDataType.STRING) || !Objects.equals(meta.getPersistentDataContainer().get(key, PersistentDataType.STRING), flag)) continue;
                meta.setDisplayName(Locale.getMessage("gui.display_name").replaceAll("%flag%", flag).replaceAll("%bool%", Locale.getMessage(String.valueOf(bool))));
                ArrayList<String> lores = new ArrayList<String>();
                for (String l : Locale.yaml.getStringList("gui.lore")) {
                    l = Locale.translate(l);
                    l = l.replaceAll("%flag%", flag);
                    l = l.replaceAll("%bool%", String.valueOf(bool));
                    l = l.replaceAll("%description%", Locale.getMessage("gui.description." + flag));
                    lores.add(l);
                }
                meta.setLore(lores);
                item.setItemMeta(meta);
                gui.setItem(FlagsManager.getSlot(flag), item);
                this.guis.replace(world + "_page" + i, gui);
                return;
            }
        }
    }

    public void removeWorld(String world) {
        int max_page = FlagsManager.getMaxPage(FlagsManager.getFlags());
        for (int i = 1; i <= max_page; ++i) {
            this.guis.remove(world + "_page" + i);
        }
    }

    public void reloadGUIs() {
        this.guis.clear();
        instance.initialization();
    }
}

