/*
 * Decompiled with CFR 0.152.
 */
package p1xel.nobuildplus.Listener;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import p1xel.nobuildplus.Flags;
import p1xel.nobuildplus.Hook.Hooks;
import p1xel.nobuildplus.Storage.Worlds;

public class NoBuildPlusBlockListener
implements Listener {
    @EventHandler
    public void onBreak(BlockBreakEvent e) {
        Block block = e.getBlock();
        if (Hooks.cancel(block)) {
            return;
        }
        String world = block.getWorld().getName();
        if (!Flags.destroy.isEnabled(world)) {
            return;
        }
        Player p = e.getPlayer();
        if (p.hasPermission(Worlds.getPermission(world))) {
            return;
        }
        if (Flags.destroy.getType().equalsIgnoreCase("all")) {
            Worlds.sendMessage(p, world);
            e.setCancelled(true);
        }
        if (Flags.destroy.getType().equalsIgnoreCase("list")) {
            Material mat = block.getType();
            if (Flags.destroy.getList().contains(mat.toString().toUpperCase())) {
                Worlds.sendMessage(p, world);
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onBuild(BlockPlaceEvent e) {
        Block block = e.getBlock();
        if (Hooks.cancel(block)) {
            return;
        }
        String world = block.getWorld().getName();
        if (!Flags.build.isEnabled(world)) {
            return;
        }
        Player p = e.getPlayer();
        if (p.hasPermission(Worlds.getPermission(world))) {
            return;
        }
        if (Flags.build.getType().equalsIgnoreCase("all")) {
            Worlds.sendMessage(p, world);
            e.setCancelled(true);
        }
        if (Flags.build.getType().equalsIgnoreCase("list")) {
            Material mat = block.getType();
            if (Flags.build.getList().contains(mat.toString().toUpperCase())) {
                Worlds.sendMessage(p, world);
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onLeafDecay(LeavesDecayEvent e) {
        Block block = e.getBlock();
        if (Hooks.cancel(block)) {
            return;
        }
        String world = block.getWorld().getName();
        if (!Flags.leaf_decay.isEnabled(world)) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler
    public void onSnowMelt(BlockFadeEvent e) {
        Block block = e.getBlock();
        String world = block.getWorld().getName();
        if (Hooks.cancel(block)) {
            return;
        }
        Material mat = block.getType();
        if (mat == Material.SNOW || mat == Material.ICE || mat == Material.PACKED_ICE) {
            if (!Flags.melt.isEnabled(world)) {
                return;
            }
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onCoralDecay(BlockFadeEvent e) {
        Block block = e.getBlock();
        if (Hooks.cancel(block)) {
            return;
        }
        Material mat = block.getType();
        if (Flags.coral_decay.getList().contains(mat.toString())) {
            String world = block.getWorld().getName();
            if (!Flags.coral_decay.isEnabled(world)) {
                return;
            }
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onWaterSpread(BlockFromToEvent e) {
        Block block = e.getBlock();
        if (Hooks.cancel(block)) {
            return;
        }
        Material mat = block.getType();
        if (mat == Material.WATER) {
            String world = block.getWorld().getName();
            if (!Flags.water_spread.isEnabled(world)) {
                return;
            }
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onLavaSpread(BlockFromToEvent e) {
        Block block = e.getBlock();
        if (Hooks.cancel(block)) {
            return;
        }
        Material mat = block.getType();
        if (mat == Material.LAVA) {
            String world = block.getWorld().getName();
            if (!Flags.lava_spread.isEnabled(world)) {
                return;
            }
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onIceFormation(BlockFromToEvent e) {
        Block block = e.getBlock();
        if (Hooks.cancel(block)) {
            return;
        }
        Material newMat = e.getToBlock().getType();
        if (newMat == Material.ICE) {
            String world = block.getWorld().getName();
            if (!Flags.ice_form.isEnabled(world)) {
                return;
            }
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPistonTrigger(BlockPistonRetractEvent e) {
        Block block = e.getBlock();
        if (Hooks.cancel(block)) {
            return;
        }
        String world = block.getWorld().getName();
        if (!Flags.piston.isEnabled(world)) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler
    public void onIgnite(BlockIgniteEvent e) {
        Block block = e.getBlock();
        if (Hooks.cancel(block)) {
            return;
        }
        String world = block.getWorld().getName();
        if (!Flags.fire_spawn.isEnabled(world)) {
            return;
        }
        e.setCancelled(true);
    }
}

