/*
 * Decompiled with CFR 0.152.
 */
package p1xel.nobuildplus.Listener;

import java.util.Iterator;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.world.PortalCreateEvent;
import p1xel.nobuildplus.Flags;
import p1xel.nobuildplus.Hook.Hooks;
import p1xel.nobuildplus.Storage.FlagsManager;
import p1xel.nobuildplus.Storage.Worlds;

public class NoBuildPlusEntityListener
implements Listener {
    @EventHandler
    public void onMobDamage(EntityDamageByEntityEvent e) {
        Entity p = e.getDamager();
        Entity target = e.getEntity();
        if (Hooks.cancel(p)) {
            return;
        }
        if (Hooks.cancel(target)) {
            return;
        }
        String world = target.getWorld().getName();
        if (!Flags.mob_damage.isEnabled(world)) {
            return;
        }
        if (p.hasPermission(Worlds.getPermission(world))) {
            return;
        }
        if (Flags.mob_damage.getType().equalsIgnoreCase("all") && p instanceof Player && !(target instanceof Player)) {
            Worlds.sendMessage((Player)p, world);
            e.setCancelled(true);
            return;
        }
        if (Flags.mob_damage.getType().equalsIgnoreCase("list") && p instanceof Player && !(target instanceof Player)) {
            EntityType type = e.getEntityType();
            if (Flags.mob_damage.getList().contains(type.toString().toUpperCase())) {
                Worlds.sendMessage((Player)p, world);
                e.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler
    public void onFrameDamage(EntityDamageByEntityEvent e) {
        Entity p = e.getDamager();
        if (Hooks.cancel(p)) {
            return;
        }
        Entity target = e.getEntity();
        if (Hooks.cancel(target)) {
            return;
        }
        String world = target.getWorld().getName();
        if (!Flags.frame.isEnabled(world)) {
            return;
        }
        if (p.hasPermission(Worlds.getPermission(world))) {
            return;
        }
        if (FlagsManager.FrameIsIncludingGlowFrame() && target instanceof GlowItemFrame) {
            if (p instanceof Player) {
                Worlds.sendMessage((Player)p, world);
            }
            e.setCancelled(true);
            return;
        }
        if (target instanceof ItemFrame) {
            if (p instanceof Player) {
                Worlds.sendMessage((Player)p, world);
            }
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onTNTDamage(EntityDamageByEntityEvent e) {
        Entity p = e.getDamager();
        if (Hooks.cancel(p)) {
            return;
        }
        Entity target = e.getEntity();
        if (Hooks.cancel(target)) {
            return;
        }
        String world = target.getWorld().getName();
        if (!Flags.tnt_damage.isEnabled(world)) {
            return;
        }
        if (p.getType() == EntityType.PRIMED_TNT || p.getType() == EntityType.MINECART_TNT) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onArmorStandDamage(EntityDamageByEntityEvent e) {
        Entity p = e.getDamager();
        if (Hooks.cancel(p)) {
            return;
        }
        Entity target = e.getEntity();
        if (Hooks.cancel(target)) {
            return;
        }
        String world = target.getWorld().getName();
        if (!Flags.armorstand.isEnabled(world)) {
            return;
        }
        if (p.hasPermission(Worlds.getPermission(world))) {
            return;
        }
        if (p instanceof Player && (target instanceof ArmorStand || target.getType() == EntityType.ARMOR_STAND)) {
            Worlds.sendMessage((Player)p, world);
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onCrystalDamage(EntityDamageByEntityEvent e) {
        Entity p = e.getDamager();
        if (Hooks.cancel(p)) {
            return;
        }
        Entity target = e.getEntity();
        if (Hooks.cancel(target)) {
            return;
        }
        String world = target.getWorld().getName();
        if (!Flags.crystal.isEnabled(world)) {
            return;
        }
        if (p.hasPermission(Worlds.getPermission(world))) {
            return;
        }
        if (p instanceof Player && (target.getType() == EntityType.ENDER_CRYSTAL || target instanceof EnderCrystal)) {
            Worlds.sendMessage((Player)p, world);
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPVP(EntityDamageByEntityEvent e) {
        Entity p = e.getDamager();
        if (Hooks.cancel(p)) {
            return;
        }
        Entity target = e.getEntity();
        if (Hooks.cancel(target)) {
            return;
        }
        String world = target.getWorld().getName();
        if (!Flags.pvp.isEnabled(world)) {
            return;
        }
        if (p.hasPermission(Worlds.getPermission(world))) {
            return;
        }
        if (p instanceof Player && target instanceof Player) {
            Worlds.sendMessage((Player)p, world);
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onMobExplode(EntityExplodeEvent e) {
        Entity entity = e.getEntity();
        if (Hooks.cancel(entity)) {
            return;
        }
        String world = entity.getWorld().getName();
        if (!Flags.mob_explode.isEnabled(world)) {
            return;
        }
        if (Flags.mob_explode.getType().equalsIgnoreCase("all")) {
            e.setCancelled(true);
            return;
        }
        if (Flags.mob_explode.getType().equalsIgnoreCase("list")) {
            EntityType type = e.getEntityType();
            if (Flags.mob_explode.getList().contains(type.toString().toUpperCase())) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onTNTExplokde(EntityExplodeEvent e) {
        Entity entity = e.getEntity();
        if (Hooks.cancel(entity)) {
            return;
        }
        String world = entity.getWorld().getName();
        if (!Flags.tnt.isEnabled(world)) {
            return;
        }
        EntityType type = e.getEntityType();
        if (type == EntityType.PRIMED_TNT || type == EntityType.MINECART_TNT) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onInteractEntity(PlayerInteractEntityEvent e) {
        Player p = e.getPlayer();
        if (Hooks.cancel(p)) {
            return;
        }
        Entity clicked = e.getRightClicked();
        if (Hooks.cancel(clicked)) {
            return;
        }
        String world = p.getWorld().getName();
        if (!Flags.frame.isEnabled(world)) {
            return;
        }
        if (p.hasPermission(Worlds.getPermission(world))) {
            return;
        }
        if (FlagsManager.FrameIsIncludingGlowFrame() && clicked.getType() == EntityType.GLOW_ITEM_FRAME) {
            Worlds.sendMessage(p, world);
            e.setCancelled(true);
            return;
        }
        if (clicked.getType() == EntityType.ITEM_FRAME) {
            Worlds.sendMessage(p, world);
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onRide(PlayerInteractEntityEvent e) {
        Player p = e.getPlayer();
        if (Hooks.cancel(p)) {
            return;
        }
        Entity clicked = e.getRightClicked();
        if (Hooks.cancel(clicked)) {
            return;
        }
        String world = p.getWorld().getName();
        if (!Flags.ride.isEnabled(world)) {
            return;
        }
        if (p.hasPermission(Worlds.getPermission(world))) {
            return;
        }
        if (Flags.ride.getType().equalsIgnoreCase("list")) {
            EntityType type = clicked.getType();
            if (Flags.ride.getList().contains(type.toString().toUpperCase())) {
                Worlds.sendMessage(p, world);
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onInteractArmorStand(PlayerInteractEntityEvent e) {
        Player p = e.getPlayer();
        if (Hooks.cancel(p)) {
            return;
        }
        Entity clicked = e.getRightClicked();
        if (Hooks.cancel(clicked)) {
            return;
        }
        String world = p.getWorld().getName();
        if (!Flags.armorstand.isEnabled(world)) {
            return;
        }
        if (p.hasPermission(Worlds.getPermission(world))) {
            return;
        }
        if (clicked.getType() == EntityType.ARMOR_STAND || clicked instanceof ArmorStand) {
            Worlds.sendMessage(p, world);
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onInteractVillager(PlayerInteractEntityEvent e) {
        Player p = e.getPlayer();
        if (Hooks.cancel(p)) {
            return;
        }
        Entity clicked = e.getRightClicked();
        if (Hooks.cancel(clicked)) {
            return;
        }
        if (clicked.getType() != EntityType.VILLAGER) {
            return;
        }
        String world = p.getWorld().getName();
        if (!Flags.villager.isEnabled(world)) {
            return;
        }
        if (p.hasPermission(Worlds.getPermission(world))) {
            return;
        }
        Worlds.sendMessage(p, world);
        e.setCancelled(true);
    }

    @EventHandler
    public void onVoidDamage(EntityDamageEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof Player && Hooks.cancel(entity)) {
            return;
        }
        if (e.getCause() != EntityDamageEvent.DamageCause.VOID) {
            return;
        }
        String world = entity.getWorld().getName();
        if (!Flags.voidtp.isEnabled(world)) {
            return;
        }
        if (Worlds.isSpawnLocationSet(world) && entity instanceof Player) {
            Player p = (Player)entity;
            p.teleport(Worlds.getSpawnLocation(world));
            p.setFallDistance(0.0f);
        }
    }

    @EventHandler
    public void onFallDamage(EntityDamageEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof Player && Hooks.cancel(entity)) {
            return;
        }
        if (e.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        String world = entity.getWorld().getName();
        if (!Flags.fall_damage.isEnabled(world)) {
            return;
        }
        if (entity instanceof Player) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onShoot(EntityShootBowEvent e) {
        LivingEntity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        if (Hooks.cancel((Entity)entity)) {
            return;
        }
        String world = entity.getWorld().getName();
        if (!Flags.shoot.isEnabled(world)) {
            return;
        }
        Player p = (Player)entity;
        if (p.hasPermission(Worlds.getPermission(world))) {
            return;
        }
        Material mat = e.getBow().getType();
        Material crossbow = Material.matchMaterial((String)"CROSSBOW");
        if (mat == Material.BOW || crossbow != null && mat == crossbow) {
            Worlds.sendMessage(p, world);
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onArmorStandSpawn(CreatureSpawnEvent e) {
        LivingEntity entity = e.getEntity();
        if (Hooks.cancel((Entity)entity)) {
            return;
        }
        String world = entity.getWorld().getName();
        if (!Flags.armorstand.isEnabled(world)) {
            return;
        }
        if (e.getEntityType() == EntityType.ARMOR_STAND) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onFarmBreak(EntityInteractEvent e) {
        Entity entity = e.getEntity();
        if (Hooks.cancel(entity)) {
            return;
        }
        String world = entity.getWorld().getName();
        if (!Flags.farmbreak.isEnabled(world)) {
            return;
        }
        Material mat = e.getBlock().getType();
        if (mat == Material.matchMaterial((String)"SOIL") || mat == Material.matchMaterial((String)"FARMLAND")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onMobSpawn(EntitySpawnEvent e) {
        Entity entity = e.getEntity();
        if (Hooks.cancel(entity)) {
            return;
        }
        String world = entity.getWorld().getName();
        if (!Flags.mob_spawn.isEnabled(world)) {
            return;
        }
        if (Flags.mob_spawn.getType().equalsIgnoreCase("list")) {
            EntityType et = e.getEntityType();
            if (Flags.mob_spawn.getList().contains(et.toString().toUpperCase())) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPortalCreate(PortalCreateEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        if (Hooks.cancel(entity)) {
            return;
        }
        String world = entity.getWorld().getName();
        if (!Flags.nether.isEnabled(world)) {
            return;
        }
        Player p = (Player)entity;
        if (p.hasPermission(Worlds.getPermission(world))) {
            return;
        }
        List blocks = e.getBlocks();
        Iterator iterator = blocks.iterator();
        if (iterator.hasNext()) {
            BlockState block = (BlockState)iterator.next();
            if (block.getType() == Material.OBSIDIAN) {
                Worlds.sendMessage(p, world);
                e.setCancelled(true);
                return;
            }
            return;
        }
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent e) {
        Projectile entity = e.getEntity();
        if (Hooks.cancel((Entity)entity)) {
            return;
        }
        if (!(entity instanceof Blaze)) {
            return;
        }
        String world = entity.getWorld().getName();
        if (!Flags.fire_spawn.isEnabled(world)) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler
    public void onPlayerRegain(EntityRegainHealthEvent e) {
        Entity entity = e.getEntity();
        if (Hooks.cancel(entity)) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        String world = entity.getWorld().getName();
        if (!Flags.heal.isEnabled(world)) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler
    public void onLightning(LightningStrikeEvent e) {
        LightningStrike lightning = e.getLightning();
        Location loc = lightning.getLocation();
        if (Hooks.cancel(loc)) {
            return;
        }
        String world = loc.getWorld().getName();
        if (!Flags.lightning.isEnabled(world)) {
            return;
        }
        if (FlagsManager.getBoolInFlag("lightning", "lightning-only")) {
            lightning.setFireTicks(0);
        } else {
            e.setCancelled(true);
        }
    }
}

