/*
 * Decompiled with CFR 0.152.
 */
package p1xel.nobuildplus.Listener;

import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import p1xel.nobuildplus.Flags;
import p1xel.nobuildplus.Hook.Hooks;
import p1xel.nobuildplus.NoBuildPlus;
import p1xel.nobuildplus.Storage.Worlds;

public class NoBuildPlusHangingListener
implements Listener {
    int v = NoBuildPlus.getInstance().getBukkitVersion();

    @EventHandler
    public void onFrameBroke(HangingBreakByEntityEvent e) {
        Entity entity = e.getRemover();
        if (Hooks.cancel(entity)) {
            return;
        }
        String world = entity.getWorld().getName();
        if (!Flags.frame.isEnabled(world)) {
            return;
        }
        Player p = (Player)entity;
        if (p.hasPermission(Worlds.getPermission(world))) {
            return;
        }
        if (this.v >= 17 && e.getEntity() instanceof GlowItemFrame) {
            Worlds.sendMessage(p, world);
            e.setCancelled(true);
            return;
        }
        if (e.getEntity() instanceof ItemFrame) {
            Worlds.sendMessage(p, world);
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPaintingBroke(HangingBreakByEntityEvent e) {
        Entity entity = e.getRemover();
        if (Hooks.cancel(entity)) {
            return;
        }
        if (!(entity instanceof Painting)) {
            return;
        }
        String world = entity.getWorld().getName();
        if (!Flags.painting.isEnabled(world)) {
            return;
        }
        if (entity instanceof Player) {
            Player p = (Player)entity;
            if (p.hasPermission(Worlds.getPermission(world))) {
                return;
            }
            Worlds.sendMessage(p, world);
        }
        e.setCancelled(true);
    }

    @EventHandler
    public void onFramePlaced(HangingPlaceEvent e) {
        Hanging entity = e.getEntity();
        if (Hooks.cancel((Entity)entity)) {
            return;
        }
        String world = entity.getWorld().getName();
        if (!Flags.frame.isEnabled(world)) {
            return;
        }
        Player p = e.getPlayer();
        if (p.hasPermission(Worlds.getPermission(world))) {
            return;
        }
        EntityType type = entity.getType();
        if (this.v >= 17 && type == EntityType.GLOW_ITEM_FRAME) {
            Worlds.sendMessage(p, world);
            e.setCancelled(true);
            return;
        }
        if (type == EntityType.ITEM_FRAME) {
            Worlds.sendMessage(p, world);
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPaintingPlaced(HangingPlaceEvent e) {
        Hanging entity = e.getEntity();
        if (Hooks.cancel((Entity)entity)) {
            return;
        }
        if (entity.getType() != EntityType.PAINTING) {
            return;
        }
        String world = entity.getWorld().getName();
        if (!Flags.painting.isEnabled(world)) {
            return;
        }
        Player p = e.getPlayer();
        if (p.hasPermission(Worlds.getPermission(world))) {
            return;
        }
        Worlds.sendMessage(p, world);
        e.setCancelled(true);
    }
}

