/*
 * Decompiled with CFR 0.152.
 */
package p1xel.nobuildplus;

import com.bekvon.bukkit.residence.Residence;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import p1xel.nobuildplus.API.NBPAPI;
import p1xel.nobuildplus.Command.Cmd;
import p1xel.nobuildplus.Command.TabList;
import p1xel.nobuildplus.Flags;
import p1xel.nobuildplus.Listener.GUIManager;
import p1xel.nobuildplus.Listener.NBPBlockListener_1_17;
import p1xel.nobuildplus.Listener.NBPEntityListener_1_13;
import p1xel.nobuildplus.Listener.NBPEntityListener_1_9;
import p1xel.nobuildplus.Listener.NBPPlayerListener_1_20;
import p1xel.nobuildplus.Listener.NBPPlayerListener_1_8;
import p1xel.nobuildplus.Listener.NoBuildPlusBlockListener;
import p1xel.nobuildplus.Listener.NoBuildPlusEntityListener;
import p1xel.nobuildplus.Listener.NoBuildPlusHangingListener;
import p1xel.nobuildplus.Listener.NoBuildPlusPlayerListener;
import p1xel.nobuildplus.Listener.NoBuildPlusServerListener;
import p1xel.nobuildplus.Listener.NoBuildPlusVehicleListener;
import p1xel.nobuildplus.Listener.ResidenceListener;
import p1xel.nobuildplus.Storage.Config;
import p1xel.nobuildplus.Storage.FlagsManager;
import p1xel.nobuildplus.Storage.Locale;
import p1xel.nobuildplus.Storage.Settings;
import p1xel.nobuildplus.Storage.Worlds;
import p1xel.nobuildplus.bStats.Metrics;
import p1xel.nobuildplus.spigotmc.UpdateChecker;

public class NoBuildPlus
extends JavaPlugin {
    private static NoBuildPlus instance;
    private NBPAPI api;

    public static NoBuildPlus getInstance() {
        return instance;
    }

    public NBPAPI getAPI() {
        return this.api;
    }

    private void saveOtherConfigs() {
        File file = new File(this.getDataFolder(), "lang/config_zh_CN.yml");
        if (!file.exists()) {
            this.saveResource("lang/config_zh_CN.yml", false);
        }
    }

    public static Residence getRes() {
        Plugin resPlug = Bukkit.getServer().getPluginManager().getPlugin("Residence");
        if (resPlug != null) {
            return Residence.getInstance();
        }
        return null;
    }

    public void onLoad() {
        instance = this;
        this.api = new NBPAPI();
        this.saveDefaultConfig();
        this.saveOtherConfigs();
        Config.update();
        Locale.createLocaleFile();
        FlagsManager.createFlagsManagerFile();
        Settings.createSettingsFile();
        Worlds.createWorldsFile();
        Settings.defaultList();
    }

    public void onEnable() {
        this.updateFlags();
        if (Config.getConfigurationVersion() < 4) {
            this.getConfig().set("Configuration", (Object)4);
            if (Config.getConfigurationVersion() < 3) {
                this.getConfig().set("hook.Dominion", (Object)true);
            }
            this.getConfig().set("deny-message-type", (Object)"MESSAGE");
            this.getConfig().set("deny-message-sound.name", (Object)"ENTITY_VILLAGER_NO");
            try {
                this.getConfig().save(new File(this.getDataFolder(), "config.yml"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.getLogger().info("[NBP] START LOADING ...");
        this.getServer().getPluginCommand("NoBuildPlus").setExecutor((CommandExecutor)new Cmd());
        this.getServer().getPluginCommand("NoBuildPlus").setTabCompleter((TabCompleter)new TabList());
        this.getLogger().info("[NBP] CMD LOADED.");
        this.getServer().getPluginManager().registerEvents((Listener)new NoBuildPlusBlockListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new NoBuildPlusEntityListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new NoBuildPlusHangingListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new NoBuildPlusPlayerListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new NoBuildPlusServerListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new NoBuildPlusVehicleListener(), (Plugin)this);
        if (this.getBukkitVersion() >= 9) {
            this.getServer().getPluginManager().registerEvents((Listener)new NBPEntityListener_1_9(), (Plugin)this);
            this.getLogger().info("NBP Player Listener for 1.9+ is registered!");
        }
        if (this.getBukkitVersion() < 13) {
            this.getServer().getPluginManager().registerEvents((Listener)new NBPPlayerListener_1_8(), (Plugin)this);
            this.getLogger().info("NBP Player Listener for 1.8-1.12 is registered!");
        } else {
            this.getServer().getPluginManager().registerEvents((Listener)new NBPEntityListener_1_13(), (Plugin)this);
            this.getLogger().info("NBP Entity Listener for 1.13+ is registered!");
        }
        if (this.getBukkitVersion() > 15) {
            this.getLogger().info("In-game menu is enabled at 1.16+.");
        } else {
            this.getLogger().info("The version of your server does not support in-game menu.");
        }
        if (this.getBukkitVersion() >= 17) {
            this.getServer().getPluginManager().registerEvents((Listener)new NBPBlockListener_1_17(), (Plugin)this);
            this.getLogger().info("NBP Block Listener for 1.17+ is registered!");
        }
        if (this.getBukkitVersion() >= 20) {
            this.getServer().getPluginManager().registerEvents((Listener)new NBPPlayerListener_1_20(), (Plugin)this);
            this.getLogger().info("NBP Player Listener for 1.20+ is registered!");
        }
        if (this.getBukkitVersion() >= 15) {
            this.getServer().getPluginManager().registerEvents((Listener)new GUIManager(), (Plugin)this);
        }
        this.getLogger().info("[NBP] LISTENERS LOADED.");
        this.checkHookPlugins();
        this.getLogger().info("[NBP] HOOKED FUNCTIONS LOADED.");
        this.updateVersion();
        this.getLogger().info("Plugin loaded! Version: " + Config.getVersion());
        NBPAPI api = new NBPAPI();
        String message = api.getInfo() + api.getVersion();
        this.getLogger().info("NBP API is loaded! " + message);
        this.getLogger().info("    _   __      ____        _ __    ______  __          ");
        this.getLogger().info("   / | / /___  / __ )__  __(_) /___/ / __ \\/ /_  _______");
        this.getLogger().info("  /  |/ / __ \\/ __  / / / / / / __  / /_/ / / / / / ___/");
        this.getLogger().info(" / /|  / /_/ / /_/ / /_/ / / / /_/ / ____/ / /_/ (__  ) ");
        this.getLogger().info("/_/ |_/\\____/_____/\\__,_/_/_/\\__,_/_/   /_/\\__,_/____/  ");
        int pluginId = 15126;
        new Metrics(this, pluginId);
        if (Config.getBool("check-update")) {
            new UpdateChecker(this, 101815).getVersion(version -> {
                if (this.getDescription().getVersion().equals(version)) {
                    this.getLogger().info(Locale.getMessage("update-check.latest"));
                } else {
                    this.getLogger().info(Locale.getMessage("update-check.outdate"));
                }
            });
        }
    }

    public int getBukkitVersion() {
        String v = Bukkit.getServer().getBukkitVersion().split("-")[0].split("\\.")[1];
        return Integer.parseInt(v);
    }

    void updateVersion() {
        this.getConfig().set("Version", (Object)this.getDescription().getVersion());
    }

    void checkHookPlugins() {
        if (Config.getBool("hook.Residence")) {
            Plugin res = this.getServer().getPluginManager().getPlugin("Residence");
            Plugin cmilib = this.getServer().getPluginManager().getPlugin("CMILib");
            if (res != null && cmilib != null) {
                if (!cmilib.isEnabled()) {
                    this.getServer().getPluginManager().enablePlugin(cmilib);
                    this.getServer().getPluginManager().enablePlugin(res);
                    this.getLogger().info("Residence is enabled by NoBuildPlus.");
                }
                this.getServer().getPluginManager().registerEvents((Listener)new ResidenceListener(), (Plugin)this);
            }
        }
    }

    void updateFlags() {
        for (Map.Entry<String, Flags> entry : Flags.getMaps().entrySet()) {
            String key = entry.getKey();
            if (FlagsManager.yaml.getConfigurationSection("flags").getKeys(false).contains(key)) continue;
            Flags flag = entry.getValue();
            FlagsManager.yaml.set("flags." + key + ".enable", (Object)flag.getDefaultFlagEnabled());
            FlagsManager.yaml.set("flags." + key + ".show-item", (Object)flag.getDefaultShowItem());
            FlagsManager.yaml.set("flags." + key + ".slot", (Object)flag.getDefaultSlot());
            FlagsManager.yaml.set("flags." + key + ".type", (Object)flag.getDefaultType());
            FlagsManager.yaml.set("flags." + key + ".list", flag.getDefaultList());
            this.getLogger().info("Flag " + key.toUpperCase() + " is updated to flags.yml!");
            Settings.yaml.set("global-settings.flags." + key, (Object)true);
            this.getLogger().info("Flag " + key.toUpperCase() + " is updated to settings.yml!");
            for (String world : Settings.getEnableWorldList()) {
                Worlds.yaml.set(world + ".flags." + key, (Object)true);
                this.getLogger().info("Flag " + key.toUpperCase() + " is updated to " + world + " in worlds.yml!");
            }
        }
        File flags = new File(this.getDataFolder(), "flags.yml");
        File settings = new File(this.getDataFolder(), "settings.yml");
        File worlds = new File(this.getDataFolder(), "worlds.yml");
        try {
            FlagsManager.yaml.save(flags);
            Settings.yaml.save(settings);
            Worlds.yaml.save(worlds);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        FlagsManager.upload(flags);
        Settings.upload(settings);
        Worlds.upload(worlds);
        FlagsManager.defaultFlagList();
        Settings.defaultList();
        if (this.getBukkitVersion() >= 15) {
            GUIManager.instance.initialization();
        }
    }

    public static boolean isResidenceEnabled() {
        return Bukkit.getServer().getPluginManager().isPluginEnabled("Residence");
    }

    public static boolean isDominionEnabled() {
        return Bukkit.getServer().getPluginManager().isPluginEnabled("Dominion");
    }

    public static boolean isOraxenEnabled() {
        return Bukkit.getServer().getPluginManager().isPluginEnabled("Oraxen");
    }

    public static boolean isBlockRegenEnabled() {
        return Bukkit.getServer().getPluginManager().isPluginEnabled("BlockRegen");
    }
}

