/*
 * Decompiled with CFR 0.152.
 */
package p1xel.nobuildplus.Storage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import p1xel.nobuildplus.NoBuildPlus;
import p1xel.nobuildplus.Storage.FlagsManager;
import p1xel.nobuildplus.Storage.Worlds;

public class Settings {
    public static File file;
    public static FileConfiguration yaml;
    static List<String> list;

    public static void createSettingsFile() {
        File file = new File(NoBuildPlus.getInstance().getDataFolder(), "settings.yml");
        if (!file.exists()) {
            NoBuildPlus.getInstance().saveResource("settings.yml", false);
        }
        Settings.upload(file);
    }

    public static void upload(File settings) {
        file = settings;
        yaml = YamlConfiguration.loadConfiguration((File)settings);
    }

    public static void set(String path, Object value) {
        yaml.set(path, value);
        try {
            yaml.save(file);
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    public static void defaultList() {
        list.addAll(Worlds.yaml.getKeys(false));
    }

    public static List<String> getEnableWorldList() {
        return list;
    }

    public static void addWorld(String world) {
        list.add(world);
    }

    public static void removeWorld(String world) {
        list.remove(world);
    }

    public static boolean getDefaultFlag(String flag) {
        return yaml.getBoolean("global-settings.flags." + flag);
    }

    public static String getPermission() {
        return yaml.getString("global-settings.permission");
    }

    public static String getDenyMessageString() {
        return yaml.getString("global-settings.deny-message");
    }

    public static boolean canExecute(String world, String flag) {
        return FlagsManager.yaml.getBoolean("flags." + flag + ".enable") && Settings.getEnableWorldList().contains(world);
    }

    @Deprecated
    public static void updateFromFlagsManager() {
        for (String flag : FlagsManager.getFlags()) {
            if (yaml.isSet("global-settings.flags." + flag)) continue;
            Settings.set("global-settings.flags." + flag, true);
        }
    }

    static {
        list = new ArrayList(Collections.emptyList());
    }
}

