/*
 * Decompiled with CFR 0.152.
 */
package p1xel.nobuildplus.Storage;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import p1xel.nobuildplus.Listener.GUIManager;
import p1xel.nobuildplus.NoBuildPlus;
import p1xel.nobuildplus.Storage.Config;
import p1xel.nobuildplus.Storage.FlagsManager;
import p1xel.nobuildplus.Storage.Settings;

public class Worlds {
    public static File file;
    public static FileConfiguration yaml;

    public static void createWorldsFile() {
        File file = new File(NoBuildPlus.getInstance().getDataFolder(), "worlds.yml");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
        Worlds.upload(file);
    }

    public static void upload(File worlds) {
        file = worlds;
        yaml = YamlConfiguration.loadConfiguration((File)worlds);
    }

    public static void set(String path, Object value) {
        yaml.set(path, value);
        try {
            yaml.save(file);
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    public static boolean isDenyMessageExist(String world) {
        if (!Config.getBool("deny-message-enable")) {
            return false;
        }
        return yaml.getString(world + ".deny-message") != null;
    }

    public static String getDenyMessage(String world) {
        String m = yaml.getString(world + ".deny-message");
        if (m == null) {
            return null;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)m);
    }

    public static String getPermission(String world) {
        return yaml.getString(world + ".permission");
    }

    public static boolean isSpawnLocationSet(String world) {
        return yaml.get(world + ".spawn-loc") != null;
    }

    @Nullable
    public static Location getSpawnLocation(String w) {
        float pitch;
        float yaw;
        double z;
        double y;
        double x;
        World world;
        try {
            world = Bukkit.getWorld((String)yaml.getString(w + ".spawn-loc.world"));
            x = yaml.getDouble(w + ".spawn-loc.x");
            y = yaml.getDouble(w + ".spawn-loc.y");
            z = yaml.getDouble(w + ".spawn-loc.z");
            yaw = ((Float)yaml.get(w + ".spawn-loc.yaw")).floatValue();
            pitch = ((Float)yaml.get(w + ".spawn-loc.pitch")).floatValue();
        }
        catch (NullPointerException e) {
            return null;
        }
        return new Location(world, x, y, z, yaw, pitch);
    }

    public static void setSpawnLocation(String world, Location loc) {
        Worlds.set(world + ".spawn-loc.world", loc.getWorld().getName());
        Worlds.set(world + ".spawn-loc.x", loc.getX());
        Worlds.set(world + ".spawn-loc.y", loc.getY());
        Worlds.set(world + ".spawn-loc.z", loc.getZ());
        Worlds.set(world + ".spawn-loc.pitch", Float.valueOf(loc.getPitch()));
        Worlds.set(world + ".spawn-loc.yaw", Float.valueOf(loc.getYaw()));
    }

    public static void createWorld(String world) {
        for (String flagname : FlagsManager.getFlags()) {
            Worlds.set(world + ".flags." + flagname, Settings.getDefaultFlag(flagname));
        }
        Worlds.set(world + ".permission", Settings.getPermission());
        Worlds.set(world + ".deny-message", Settings.getDenyMessageString());
        Settings.addWorld(world);
    }

    public static void removeWorld(String world) {
        Worlds.set(world, null);
        Settings.removeWorld(world);
    }

    public static void setFlag(String world, String flag, boolean bool) {
        Worlds.set(world + ".flags." + flag, bool);
        if (NoBuildPlus.getInstance().getBukkitVersion() >= 15) {
            GUIManager.instance.updateFlag(world, flag, bool);
        }
    }

    public static boolean getFlag(String world, String flag) {
        return yaml.getBoolean(world + ".flags." + flag);
    }

    @Deprecated
    public static void updateFromFlagsManager() {
        for (String world : yaml.getKeys(false)) {
            for (String flag : FlagsManager.getFlags()) {
                if (yaml.isSet(world + ".flags." + flag)) continue;
                Worlds.setFlag(world, flag, Settings.getDefaultFlag(flag));
            }
        }
    }

    public static void sendMessage(Player player, String world) {
        if (!Worlds.isDenyMessageExist(world)) {
            return;
        }
        String sound = Config.getString("deny-message-sound.name");
        if (Config.getString("deny-message-type").equalsIgnoreCase("ACTIONBAR")) {
            if (NoBuildPlus.getInstance().getBukkitVersion() < 12) {
                return;
            }
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(Worlds.getDenyMessage(world)));
            if (sound != null) {
                player.playSound(player.getLocation(), Sound.valueOf((String)sound), 1.0f, 1.0f);
            }
            return;
        }
        player.sendMessage(Worlds.getDenyMessage(world));
        if (sound != null) {
            player.playSound((Entity)player, Sound.valueOf((String)sound), 1.0f, 1.0f);
        }
    }
}

