/*
 * Decompiled with CFR 0.152.
 */
package me.toastymop.combatlog;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.toastymop.combatlog.CombatConfig;
import me.toastymop.combatlog.util.IEntityDataSaver_neoforge;
import me.toastymop.combatlog.util.TagData_neoforge;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;

public class CombatDisconnect_neoforge {
    public static void OnPlayerDisconnect(ServerPlayer entity) {
        if (TagData_neoforge.getCombat((IEntityDataSaver_neoforge)entity)) {
            String disconnectCommand;
            ServerLevel world = entity.level();
            MinecraftServer server = world.getServer();
            if (CombatConfig.Config.disconnectKill) {
                GameRules.BooleanValue gamerule = (GameRules.BooleanValue)server.getGameRules().getRule(GameRules.RULE_SHOWDEATHMESSAGES);
                Component deathMessage = Component.nullToEmpty((String)(entity.getDisplayName().getString() + CombatConfig.Config.deathMessage));
                if (gamerule.get()) {
                    gamerule.set(false, server);
                    entity.hurtServer(world, entity.damageSources().fellOutOfWorld(), 100000.0f);
                    gamerule.set(true, server);
                    server.getPlayerList().broadcastSystemMessage(deathMessage, false);
                } else {
                    entity.hurtServer(world, entity.damageSources().fellOutOfWorld(), 100000.0f);
                }
            }
            if ((disconnectCommand = CombatConfig.Config.disconnectCommand.replace("{player}", entity.getName().getString())) != null && !disconnectCommand.trim().isEmpty()) {
                Commands manager = server.getCommands();
                CommandDispatcher dispatcher = manager.getDispatcher();
                CommandSourceStack commandSource = server.createCommandSourceStack().withPermission(4);
                ParseResults parseResults = dispatcher.parse(disconnectCommand, (Object)commandSource);
                try {
                    dispatcher.execute(parseResults);
                }
                catch (CommandSyntaxException e) {
                    commandSource.sendFailure(Component.nullToEmpty((String)e.getMessage()));
                }
            }
            TagData_neoforge.endCombat((IEntityDataSaver_neoforge)entity);
        }
    }
}

