/*
 * Decompiled with CFR 0.152.
 */
package forge.me.toastymop.combatlog;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quiltmc.parsers.json.JsonReader;
import org.quiltmc.parsers.json.JsonWriter;

public class CombatConfig {
    public static Config CONFIG;
    static File configFolder;
    static File configFile;
    protected static final Logger log;

    public static Config load() {
        if (!configFolder.exists()) {
            configFolder.mkdirs();
        }
        if (!configFile.getName().endsWith(".json5")) {
            throw new RuntimeException("Failed to read config");
        }
        Config cfg = null;
        if (configFile.exists()) {
            Config config;
            block43: {
                JsonReader reader = JsonReader.json5((Path)configFile.toPath());
                try {
                    cfg = new Config();
                    reader.beginObject();
                    block37: while (reader.hasNext()) {
                        String nextName;
                        switch (nextName = reader.nextName()) {
                            case "combatTime": {
                                Config.combatTime = reader.nextInt();
                                continue block37;
                            }
                            case "allDamage": {
                                Config.allDamage = reader.nextBoolean();
                                continue block37;
                            }
                            case "mobDamage": {
                                Config.mobDamage = reader.nextBoolean();
                                continue block37;
                            }
                            case "disableElytra": {
                                Config.disableElytra = reader.nextBoolean();
                                continue block37;
                            }
                            case "disablePearl": {
                                Config.disablePearl = reader.nextBoolean();
                                continue block37;
                            }
                            case "deathMessage": {
                                Config.deathMessage = reader.nextString();
                                continue block37;
                            }
                            case "combatNotice": {
                                Config.combatNotice = reader.nextBoolean();
                                continue block37;
                            }
                            case "inCombat": {
                                Config.inCombat = reader.nextString();
                                continue block37;
                            }
                            case "outCombat": {
                                Config.outCombat = reader.nextString();
                                continue block37;
                            }
                            case "blockedCommands": {
                                Config.blockedCommands = List.of(reader.nextString().split(","));
                                continue block37;
                            }
                            case "blockedCommandMessage": {
                                Config.blockedCommandMessage = reader.nextString();
                                continue block37;
                            }
                            case "disconnectKill": {
                                Config.disconnectKill = reader.nextBoolean();
                                continue block37;
                            }
                            case "disconnectCommand": {
                                Config.disconnectCommand = reader.nextString();
                                continue block37;
                            }
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                    config = cfg;
                    if (reader == null) break block43;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.error("Failed to parse config", (Throwable)e);
                    }
                }
                reader.close();
            }
            return config;
        }
        if (cfg == null) {
            cfg = new Config();
        }
        CombatConfig.save(configFile, cfg);
        return cfg;
    }

    public static void save(File file, Config cfg) {
        try (JsonWriter writer = JsonWriter.json5((Path)file.toPath());){
            writer.beginObject();
            writer.comment("The amount of time in seconds a player should be in combat").name("combatTime").value((Number)Config.combatTime);
            writer.comment("Weather a player should be put in combat from just other players or all damage").name("allDamage").value(Config.allDamage);
            writer.comment("Weather a player should be put in combat from mobs").name("mobDamage").value(Config.mobDamage);
            writer.comment("Weather a player should be able to use their elytra while in combat, this will not make them drop from the sky it simply restricts starting elytra flight").name("disableElytra").value(Config.disableElytra);
            writer.comment("Weather a player should be able to use ender pearls while in combat").name("disablePearl").value(Config.disablePearl);
            writer.comment("The death message that shows when a player disconnects while in combat, note that not having a space at the beginning will attach the message to the players name").name("deathMessage").value(Config.deathMessage);
            writer.comment("Weather a player should get a popup when they enter combat or when trying to run blocked commands").name("combatNotice").value(Config.combatNotice);
            writer.comment("The message that shows when a player is in combat, adding {timeLeft} will display how many seconds until combat is over").name("inCombat").value(Config.inCombat);
            writer.comment("The message that shows when a player exits combat").name("outCombat").value(Config.outCombat);
            writer.comment("This is a list of commands to be blocked while in combat, do not include the slash and use commas to separate them, leave empty to disable, example \"home,spawn,rtp\"").name("blockedCommands").value("");
            writer.comment("This is the message displayed in chat when a player attempts to use a blocked command").name("blockedCommandMessage").value(Config.blockedCommandMessage);
            writer.comment("This determines if disconnecting while tagged kills the player").name("disconnectKill").value(Config.disconnectKill);
            writer.comment("This is a command to be run when a tagged player disconnects, use {player} to autofill their name, leave blank to disable, example \"warn {player} combatlogging\"").name("disconnectCommand").value(Config.disconnectCommand);
            writer.endObject();
        }
        catch (IOException e) {
            log.error("Failed to save config", (Throwable)e);
        }
    }

    static {
        configFolder = new File("./config");
        configFile = new File(String.valueOf(configFolder) + "/combatlog-common.json5");
        log = LogManager.getLogger((String)"CombatLog");
    }

    public static class Config {
        public static Integer combatTime = 30;
        public static boolean allDamage = false;
        public static boolean mobDamage = false;
        public static boolean disableElytra = false;
        public static boolean disablePearl = false;
        public static String deathMessage = " has died of cowardice";
        public static boolean combatNotice = true;
        public static String inCombat = "You are in combat do not leave! {timeLeft} seconds left";
        public static String outCombat = "You are no longer in combat";
        public static List<String> blockedCommands = new ArrayList<String>();
        public static String blockedCommandMessage = "You are in combat and cannot execute this command";
        public static boolean disconnectKill = true;
        public static String disconnectCommand = "";
    }
}

