/*
 * Decompiled with CFR 0.152.
 */
package forge.me.toastymop.combatlog.mixin;

import forge.me.toastymop.combatlog.util.IEntityDataSaver;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityDataSaverMixin
implements IEntityDataSaver {
    private CompoundTag persistentData;

    @Override
    public CompoundTag getPersistentData() {
        if (this.persistentData == null) {
            this.persistentData = new CompoundTag();
        }
        return this.persistentData;
    }

    @Inject(method={"saveWithoutId(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="HEAD")})
    protected void injectWriteMethod(CompoundTag nbt, CallbackInfoReturnable info) {
        if (this.persistentData != null) {
            nbt.put("combatLog", (Tag)this.persistentData);
        }
    }

    @Inject(method={"load(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="HEAD")})
    protected void injectReadMethod(CompoundTag nbt, CallbackInfo info) {
        if (nbt.contains("combatLog", 10)) {
            this.persistentData = nbt.getCompound("combatLog");
        }
    }
}

