/*
 * Decompiled with CFR 0.152.
 */
package neoforge.me.toastymop.combatlog;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import neoforge.me.toastymop.combatlog.CombatConfig;
import neoforge.me.toastymop.combatlog.util.IEntityDataSaver;
import neoforge.me.toastymop.combatlog.util.TagData;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;

public class CombatDisconnect {
    public static void OnPlayerDisconnect(ServerPlayer entity) {
        if (TagData.getCombat((IEntityDataSaver)entity)) {
            String disconnectCommand;
            if (CombatConfig.Config.disconnectKill) {
                GameRules.BooleanValue gamerule = (GameRules.BooleanValue)Objects.requireNonNull(entity.getServer()).getGameRules().getRule(GameRules.RULE_SHOWDEATHMESSAGES);
                Component deathMessage = Component.nullToEmpty((String)(entity.getDisplayName().getString() + CombatConfig.Config.deathMessage));
                if (gamerule.get()) {
                    gamerule.set(false, entity.getServer());
                    entity.hurt(entity.damageSources().fellOutOfWorld(), 100000.0f);
                    gamerule.set(true, entity.getServer());
                    entity.getServer().getPlayerList().broadcastSystemMessage(deathMessage, false);
                } else {
                    entity.hurt(entity.damageSources().fellOutOfWorld(), 100000.0f);
                }
            }
            if ((disconnectCommand = CombatConfig.Config.disconnectCommand.replace("{player}", entity.getName().getString())) != null && !disconnectCommand.trim().isEmpty()) {
                Commands manager = entity.getServer().getCommands();
                CommandDispatcher dispatcher = manager.getDispatcher();
                CommandSourceStack commandSource = entity.getServer().createCommandSourceStack().withPermission(4);
                ParseResults parseResults = dispatcher.parse(disconnectCommand, (Object)commandSource);
                try {
                    dispatcher.execute(parseResults);
                }
                catch (CommandSyntaxException e) {
                    commandSource.sendFailure(Component.nullToEmpty((String)e.getMessage()));
                }
            }
            TagData.endCombat((IEntityDataSaver)entity);
        }
    }
}

