/*
 * Decompiled with CFR 0.152.
 */
package dev.therealflo.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class DefaultBindingManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"VivecraftRemapper");
    private static final String BINDINGS_FILE = "vivecraft_default_bindings.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static volatile DefaultBindingManager instance;
    private final Path bindingsFilePath;
    private BindingsData savedData = new BindingsData();
    private volatile boolean bindingsLoaded = false;
    private final Object lock = new Object();

    private DefaultBindingManager() {
        this.bindingsFilePath = Paths.get(BINDINGS_FILE, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultBindingManager getInstance() {
        if (instance != null) return instance;
        Class<DefaultBindingManager> clazz = DefaultBindingManager.class;
        synchronized (DefaultBindingManager.class) {
            if (instance != null) return instance;
            instance = new DefaultBindingManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDefaultBindingsIfNeeded(String headsetProfile, Collection<Pair<String, String>> bindings) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.bindingsLoaded) {
                this.loadBindingsFromFile();
                this.bindingsLoaded = true;
            }
            if (this.savedData.vrControllerBindings.containsKey(headsetProfile)) {
                LOGGER.info("Default VR controller bindings for {} already exist, skipping save", (Object)headsetProfile);
                return;
            }
            LOGGER.info("First launch detected for {}, saving default VR controller bindings", (Object)headsetProfile);
            List<BindingEntry> bindingEntries = bindings.stream().map(BindingEntry::fromPair).toList();
            this.savedData.vrControllerBindings.put(headsetProfile, bindingEntries);
            this.saveBindingsToFile();
        }
    }

    private void saveBindingsToFile() {
        try {
            String json = GSON.toJson((Object)this.savedData);
            Files.writeString(this.bindingsFilePath, (CharSequence)json, new OpenOption[0]);
            LOGGER.info("Saved bindings to {}", (Object)this.bindingsFilePath.toAbsolutePath());
        }
        catch (IOException e) {
            LOGGER.error("Failed to save bindings to file", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Pair<String, String>> loadDefaultBindings(String headsetProfile) {
        Object object = this.lock;
        synchronized (object) {
            List<BindingEntry> entries;
            if (!this.bindingsLoaded) {
                this.loadBindingsFromFile();
                this.bindingsLoaded = true;
            }
            if ((entries = this.savedData.vrControllerBindings.get(headsetProfile)) != null) {
                LOGGER.info("Loading {} saved VR controller bindings for {}", (Object)entries.size(), (Object)headsetProfile);
                return entries.stream().map(BindingEntry::toPair).toList();
            }
            LOGGER.info("No saved VR controller bindings found for {}", (Object)headsetProfile);
            return null;
        }
    }

    private void loadBindingsFromFile() {
        if (!Files.exists(this.bindingsFilePath, new LinkOption[0])) {
            LOGGER.info("No saved bindings file found at {}", (Object)this.bindingsFilePath.toAbsolutePath());
            return;
        }
        try {
            String json = Files.readString(this.bindingsFilePath);
            Type type = new TypeToken<BindingsData>(this){}.getType();
            BindingsData loadedData = (BindingsData)GSON.fromJson(json, type);
            if (loadedData != null) {
                this.savedData = loadedData;
                if (this.savedData.vrControllerBindings == null) {
                    this.savedData.vrControllerBindings = new HashMap<String, List<BindingEntry>>();
                }
                if (this.savedData.keybindBindings == null) {
                    this.savedData.keybindBindings = new HashMap<String, String>();
                }
            }
            LOGGER.info("Loaded bindings from {}: {} VR profiles, {} keybind bindings", new Object[]{this.bindingsFilePath.toAbsolutePath(), this.savedData.vrControllerBindings.size(), this.savedData.keybindBindings.size()});
        }
        catch (IOException e) {
            LOGGER.error("Failed to load bindings from file", (Throwable)e);
            this.savedData = new BindingsData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSavedBindings(String headsetProfile) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.bindingsLoaded) {
                this.loadBindingsFromFile();
                this.bindingsLoaded = true;
            }
            return this.savedData.vrControllerBindings.containsKey(headsetProfile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAvailableProfiles() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.bindingsLoaded) {
                this.loadBindingsFromFile();
                this.bindingsLoaded = true;
            }
            return new HashSet<String>(this.savedData.vrControllerBindings.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSavedBindings() {
        Object object = this.lock;
        synchronized (object) {
            this.savedData = new BindingsData();
            try {
                Files.deleteIfExists(this.bindingsFilePath);
                LOGGER.info("Cleared all saved bindings");
            }
            catch (IOException e) {
                LOGGER.error("Failed to delete bindings file", (Throwable)e);
            }
            this.bindingsLoaded = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBindingsForProfile(String headsetProfile, Collection<Pair<String, String>> bindings) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.bindingsLoaded) {
                this.loadBindingsFromFile();
                this.bindingsLoaded = true;
            }
            List<BindingEntry> bindingEntries = bindings.stream().map(BindingEntry::fromPair).toList();
            this.savedData.vrControllerBindings.put(headsetProfile, bindingEntries);
            this.saveBindingsToFile();
            LOGGER.info("Saved {} VR controller bindings for {}", (Object)bindingEntries.size(), (Object)headsetProfile);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class BindingsData {
        public Map<String, List<BindingEntry>> vrControllerBindings = new HashMap<String, List<BindingEntry>>();
        public Map<String, String> keybindBindings = new HashMap<String, String>();
    }

    @Environment(value=EnvType.CLIENT)
    public static class BindingEntry {
        public String action;
        public String inputPath;

        public BindingEntry() {
        }

        public BindingEntry(String action, String inputPath) {
            this.action = action;
            this.inputPath = inputPath;
        }

        public Pair<String, String> toPair() {
            return Pair.of((Object)this.action, (Object)this.inputPath);
        }

        public static BindingEntry fromPair(Pair<String, String> pair) {
            return new BindingEntry((String)pair.getLeft(), (String)pair.getRight());
        }
    }
}

