/*
 * Decompiled with CFR 0.152.
 */
package dev.therealflo.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class DefaultBindingManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"request");
    private static final String BINDINGS_FILE = "vivecraft_default_bindings.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static DefaultBindingManager instance;
    private final Path bindingsFilePath;
    private Map<String, List<BindingEntry>> savedBindings = new HashMap<String, List<BindingEntry>>();
    private boolean bindingsLoaded = false;

    private DefaultBindingManager() {
        this.bindingsFilePath = Paths.get(BINDINGS_FILE, new String[0]);
    }

    public static DefaultBindingManager getInstance() {
        if (instance == null) {
            instance = new DefaultBindingManager();
        }
        return instance;
    }

    public void saveDefaultBindingsIfNeeded(String headsetProfile, Collection<Pair<String, String>> bindings) {
        if (!this.bindingsLoaded) {
            this.loadBindingsFromFile();
            this.bindingsLoaded = true;
        }
        if (this.savedBindings.containsKey(headsetProfile)) {
            LOGGER.info("[ReQuest] Default bindings for {} already exist, skipping save", (Object)headsetProfile);
            return;
        }
        LOGGER.info("[ReQuest] First launch detected for {}, saving default bindings", (Object)headsetProfile);
        List<BindingEntry> bindingEntries = bindings.stream().map(BindingEntry::fromPair).toList();
        this.savedBindings.put(headsetProfile, bindingEntries);
        this.saveBindingsToFile();
    }

    private void saveBindingsToFile() {
        try {
            String json = GSON.toJson(this.savedBindings);
            Files.writeString(this.bindingsFilePath, (CharSequence)json, new OpenOption[0]);
            LOGGER.info("[ReQuest] Saved default bindings to {}", (Object)this.bindingsFilePath.toAbsolutePath());
        }
        catch (IOException e) {
            LOGGER.error("[ReQuest] Failed to save default bindings to file", (Throwable)e);
        }
    }

    public Collection<Pair<String, String>> loadDefaultBindings(String headsetProfile) {
        List<BindingEntry> entries;
        if (!this.bindingsLoaded) {
            this.loadBindingsFromFile();
            this.bindingsLoaded = true;
        }
        if ((entries = this.savedBindings.get(headsetProfile)) == null) {
            LOGGER.warn("[ReQuest] No saved bindings found for headset profile: {}", (Object)headsetProfile);
            return null;
        }
        LOGGER.info("[ReQuest] Loaded {} saved bindings for {}", (Object)entries.size(), (Object)headsetProfile);
        return entries.stream().map(BindingEntry::toPair).toList();
    }

    private void loadBindingsFromFile() {
        if (!Files.exists(this.bindingsFilePath, new LinkOption[0])) {
            LOGGER.info("[ReQuest] No saved bindings file found at {}", (Object)this.bindingsFilePath.toAbsolutePath());
            return;
        }
        try {
            String json = Files.readString(this.bindingsFilePath);
            Type type = new TypeToken<Map<String, List<BindingEntry>>>(this){}.getType();
            this.savedBindings = (Map)GSON.fromJson(json, type);
            if (this.savedBindings == null) {
                this.savedBindings = new HashMap<String, List<BindingEntry>>();
            }
            LOGGER.info("[ReQuest] Loaded saved bindings from {}", (Object)this.bindingsFilePath.toAbsolutePath());
            for (Map.Entry<String, List<BindingEntry>> entry : this.savedBindings.entrySet()) {
                LOGGER.info("[ReQuest]   {}: {} bindings", (Object)entry.getKey(), (Object)entry.getValue().size());
            }
        }
        catch (IOException e) {
            LOGGER.error("[ReQuest] Failed to load bindings from file", (Throwable)e);
            this.savedBindings = new HashMap<String, List<BindingEntry>>();
        }
    }

    public boolean hasSavedBindings(String headsetProfile) {
        if (!this.bindingsLoaded) {
            this.loadBindingsFromFile();
            this.bindingsLoaded = true;
        }
        return this.savedBindings.containsKey(headsetProfile);
    }

    public Set<String> getAvailableProfiles() {
        if (!this.bindingsLoaded) {
            this.loadBindingsFromFile();
            this.bindingsLoaded = true;
        }
        return new HashSet<String>(this.savedBindings.keySet());
    }

    public void clearSavedBindings() {
        this.savedBindings.clear();
        try {
            Files.deleteIfExists(this.bindingsFilePath);
            LOGGER.info("[ReQuest] Cleared all saved bindings");
        }
        catch (IOException e) {
            LOGGER.error("[ReQuest] Failed to delete bindings file", (Throwable)e);
        }
        this.bindingsLoaded = false;
    }

    public void saveBindingsForProfile(String headsetProfile, Collection<Pair<String, String>> bindings) {
        List<BindingEntry> bindingEntries = bindings.stream().map(BindingEntry::fromPair).toList();
        this.savedBindings.put(headsetProfile, bindingEntries);
        this.saveBindingsToFile();
        LOGGER.info("[ReQuest] Manually saved {} bindings for {}", (Object)bindings.size(), (Object)headsetProfile);
    }

    @Environment(value=EnvType.CLIENT)
    public static class BindingEntry {
        public String action;
        public String inputPath;

        public BindingEntry() {
        }

        public BindingEntry(String action, String inputPath) {
            this.action = action;
            this.inputPath = inputPath;
        }

        public Pair<String, String> toPair() {
            return Pair.of((Object)this.action, (Object)this.inputPath);
        }

        public static BindingEntry fromPair(Pair<String, String> pair) {
            return new BindingEntry((String)pair.getLeft(), (String)pair.getRight());
        }
    }
}

