/*
 * Decompiled with CFR 0.152.
 */
package dev.therealflo.mixin.client;

import com.google.common.collect.ImmutableMap;
import dev.therealflo.client.DefaultBindingManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.vivecraft.client_vr.provider.openvr_lwjgl.MCOpenVR;
import org.vivecraft.client_vr.settings.VRSettings;

@Environment(value=EnvType.CLIENT)
@Mixin(value={MCOpenVR.class}, remap=false)
public class MCOpenVRMixin {
    private static final String[] CONTROLLER_TYPES = new String[]{"vive_controller", "oculus_touch", "holographic_controller", "knuckles", "vive_cosmos_controller"};
    private static final String[] BINDING_FILES = new String[]{"vive_defaults.json", "oculus_defaults.json", "wmr_defaults.json", "knuckles_defaults.json", "cosmos_defaults.json"};

    @ModifyVariable(method={"generateActionManifest()V"}, at=@At(value="STORE"), ordinal=0, name={"defaults"})
    private List<Map<String, Object>> modifyDefaultBindings(List<Map<String, Object>> originalDefaults) {
        DefaultBindingManager manager = DefaultBindingManager.getInstance();
        for (int i = 0; i < CONTROLLER_TYPES.length && i < BINDING_FILES.length; ++i) {
            String controllerType = CONTROLLER_TYPES[i];
            String bindingFile = BINDING_FILES[i];
            List<Pair<String, String>> bindings = List.of(Pair.of((Object)"controller_type", (Object)controllerType), Pair.of((Object)"binding_url", (Object)bindingFile));
            manager.saveDefaultBindingsIfNeeded(controllerType, bindings);
        }
        ArrayList<Map<String, Object>> customDefaults = new ArrayList<Map<String, Object>>();
        boolean hasCustomBindings = false;
        for (String controllerType : CONTROLLER_TYPES) {
            Collection<Pair<String, String>> savedBindings = manager.loadDefaultBindings(controllerType);
            if (savedBindings == null) continue;
            hasCustomBindings = true;
            String bindingUrl = null;
            for (Pair<String, String> binding : savedBindings) {
                if (!"binding_url".equals(binding.getLeft())) continue;
                bindingUrl = (String)binding.getRight();
                break;
            }
            if (bindingUrl == null) continue;
            customDefaults.add((Map<String, Object>)ImmutableMap.builder().put((Object)"controller_type", (Object)controllerType).put((Object)"binding_url", bindingUrl).build());
        }
        if (hasCustomBindings) {
            VRSettings.LOGGER.info("[ReQuest] Using custom OpenVR bindings");
            return customDefaults;
        }
        VRSettings.LOGGER.info("[ReQuest] Using original OpenVR bindings");
        return originalDefaults;
    }

    @Inject(method={"generateActionManifest()V"}, at={@At(value="HEAD")})
    private void onGenerateActionManifestStart(CallbackInfo ci) {
        DefaultBindingManager manager = DefaultBindingManager.getInstance();
        if (!manager.getAvailableProfiles().isEmpty()) {
            VRSettings.LOGGER.info("[ReQuest] Found saved OpenVR bindings for profiles: {}", manager.getAvailableProfiles());
        } else {
            VRSettings.LOGGER.info("[ReQuest] No saved OpenVR bindings found, will save defaults");
        }
    }
}

