/*
 * Decompiled with CFR 0.152.
 */
package dev.therealflo.mixin.client;

import dev.therealflo.client.DefaultBindingManager;
import dev.therealflo.client.RequestModClient;
import java.util.Collection;
import java.util.HashSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.vivecraft.client_vr.provider.openxr.MCOpenXR;
import org.vivecraft.client_vr.provider.openxr.XRBindings;

@Environment(value=EnvType.CLIENT)
@Mixin(value={MCOpenXR.class}, remap=false)
public class MCOpenXRMixin {
    @Redirect(method={"loadDefaultBindings()V"}, at=@At(value="INVOKE", target="Lorg/vivecraft/client_vr/provider/openxr/XRBindings;getBinding(Ljava/lang/String;)Ljava/util/HashSet;"))
    private HashSet<Pair<String, String>> redirectGetBinding(String headset) {
        DefaultBindingManager manager = DefaultBindingManager.getInstance();
        Collection<Pair<String, String>> savedBindings = manager.loadDefaultBindings(headset);
        if (savedBindings != null) {
            return new HashSet<Pair<String, String>>(savedBindings);
        }
        HashSet originalBindings = XRBindings.getBinding((String)headset);
        manager.saveDefaultBindingsIfNeeded(headset, originalBindings);
        return originalBindings;
    }

    @Inject(method={"loadDefaultBindings()V"}, at={@At(value="HEAD")})
    private void onLoadDefaultBindingsStart(CallbackInfo ci) {
        DefaultBindingManager manager = DefaultBindingManager.getInstance();
        if (!manager.getAvailableProfiles().isEmpty()) {
            RequestModClient.LOGGER.info("[ReQuest] Found saved bindings for profiles: {}", manager.getAvailableProfiles());
        } else {
            RequestModClient.LOGGER.info("[ReQuest] No saved bindings found, will save defaults on first use");
        }
    }
}

