/*
 * Decompiled with CFR 0.152.
 */
package dev.therealflo.client;

import dev.therealflo.client.screens.ChangeBindingScreen;
import dev.therealflo.client.screens.ReloadBindingsScreen;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vivecraft.api_beta.client.VivecraftClientAPI;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.provider.control.VRInputAction;

@Environment(value=EnvType.CLIENT)
public class RequestModClient
implements ClientModInitializer {
    private boolean registered = false;
    public static final String MOD_ID = "request";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"request");
    private static final String CATEGORY = "key.categories.request";
    public static class_304 openReloadScreenKey;
    public static class_304 openBindingScreenKey;

    public static void logInfo(String s) {
        LOGGER.info("[ReQuest] {}", (Object)s);
    }

    public static void logWarn(String s) {
        LOGGER.warn("[ReQuest] {}", (Object)s);
    }

    public static void logError(String s) {
        LOGGER.error("[ReQuest] {}", (Object)s);
    }

    public static List<String> getAllRegisteredActions() {
        ArrayList<String> actions = new ArrayList<String>();
        try {
            if (!VivecraftClientAPI.getInstance().isVrInitialized()) {
                RequestModClient.logWarn("VR not initialized, cannot get registered actions");
                return actions;
            }
            MCVR vr = ClientDataHolderVR.getInstance().vr;
            if (vr == null) {
                RequestModClient.logWarn("VR instance is null, cannot get registered actions");
                return actions;
            }
            for (VRInputAction action : vr.getInputActions()) {
                actions.add(action.name);
            }
            RequestModClient.logInfo("Retrieved " + actions.size() + " registered VR actions");
        }
        catch (Exception e) {
            RequestModClient.logError("Failed to get registered actions: " + e.getMessage());
            e.printStackTrace();
        }
        return actions;
    }

    public void onInitializeClient() {
        RequestModClient.logInfo("ReQuest has been loaded");
        openReloadScreenKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.request.open_reload", class_3675.class_307.field_1668, -1, CATEGORY));
        openBindingScreenKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.request.open_binding", class_3675.class_307.field_1668, -1, CATEGORY));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (openReloadScreenKey.method_1436()) {
                client.execute(() -> client.method_1507((class_437)new ReloadBindingsScreen()));
            }
            if (openBindingScreenKey.method_1436()) {
                client.execute(() -> client.method_1507((class_437)new ChangeBindingScreen()));
            }
            if (this.registered) {
                return;
            }
            if (!VivecraftClientAPI.getInstance().isVrInitialized()) {
                return;
            }
            if (!VivecraftClientAPI.getInstance().isVrActive()) {
                return;
            }
            MCVR vr = ClientDataHolderVR.getInstance().vr;
            if (vr == null || vr.getInputActions().isEmpty()) {
                return;
            }
            this.registerRemap(vr);
            this.registered = true;
            RequestModClient.logInfo("Controller remap installed");
        });
    }

    private void registerRemap(MCVR vr) {
        for (VRInputAction action : vr.getInputActions()) {
            RequestModClient.logInfo("VR action available: " + action.name);
        }
    }
}

