/*
 * Decompiled with CFR 0.152.
 */
package dev.therealflo.mixin.client;

import dev.therealflo.client.DefaultBindingManager;
import dev.therealflo.client.RequestModClient;
import dev.therealflo.client.api.MCOpenXRReload;
import java.util.Collection;
import java.util.HashSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.vivecraft.client_vr.provider.openxr.MCOpenXR;
import org.vivecraft.client_vr.provider.openxr.XRBindings;

@Environment(value=EnvType.CLIENT)
@Mixin(value={MCOpenXR.class}, remap=false)
public abstract class MCOpenXRMixin
implements MCOpenXRReload {
    @Invoker(value="loadActionHandles")
    protected abstract void vivecraft$invokeLoadActionHandles();

    @Invoker(value="loadDefaultBindings")
    protected abstract void vivecraft$invokeLoadDefaultBindings();

    @Override
    public void reloadXRBindings() {
        this.vivecraft$invokeLoadDefaultBindings();
        this.vivecraft$invokeLoadActionHandles();
    }

    @Redirect(method={"loadDefaultBindings"}, at=@At(value="INVOKE", target="Lorg/vivecraft/client_vr/provider/openxr/XRBindings;getBinding(Ljava/lang/String;)Ljava/util/HashSet;"))
    private HashSet<Pair<String, String>> redirectGetBinding(String headset) {
        Collection<Pair<String, String>> savedBindings;
        DefaultBindingManager manager = DefaultBindingManager.getInstance();
        String activeProfile = manager.getActiveProfile(headset);
        if (!"default".equals(activeProfile)) {
            String customProfilePath = headset + "/" + activeProfile;
            Collection<Pair<String, String>> customBindings = manager.loadDefaultBindings(customProfilePath);
            if (customBindings != null) {
                RequestModClient.LOGGER.info("[ReQuest] Loading custom profile '{}' for {}", (Object)activeProfile, (Object)headset);
                return new HashSet<Pair<String, String>>(customBindings);
            }
            RequestModClient.LOGGER.warn("[ReQuest] Custom profile '{}' not found for {}, falling back to default", (Object)activeProfile, (Object)headset);
        }
        if ((savedBindings = manager.loadDefaultBindings(headset)) != null) {
            return new HashSet<Pair<String, String>>(savedBindings);
        }
        HashSet defaultBindings = XRBindings.getBinding((String)headset);
        manager.saveDefaultBindingsIfNeeded(headset, defaultBindings);
        return defaultBindings;
    }

    @Inject(method={"loadDefaultBindings"}, at={@At(value="HEAD")})
    private void onLoadDefaultBindingsStart(CallbackInfo ci) {
        DefaultBindingManager.getInstance();
    }
}

