/*
 * Decompiled with CFR 0.152.
 */
package dev.therealflo.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class DefaultBindingManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"request");
    private static final String BINDINGS_DIR = "interaction_profiles";
    private static final String CONFIG_DIR = "config";
    private static final String CONFIG_FILE = "rebound_settings.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<String, String> UNIFIED_PROFILES = Map.of("/interaction_profiles/oculus/touch_controller", "/interaction_profiles/oculus/touch_controller", "/interaction_profiles/bytedance/pico4_controller", "/interaction_profiles/oculus/touch_controller", "/interaction_profiles/bytedance/pico_neo3_controller", "/interaction_profiles/oculus/touch_controller");
    private static volatile DefaultBindingManager instance;
    private final Path bindingsDirectory;
    private final Path configDirectory;
    private final Object lock = new Object();

    private DefaultBindingManager() {
        this.bindingsDirectory = Paths.get(BINDINGS_DIR, new String[0]);
        this.configDirectory = Paths.get(CONFIG_DIR, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultBindingManager getInstance() {
        if (instance != null) return instance;
        Class<DefaultBindingManager> clazz = DefaultBindingManager.class;
        synchronized (DefaultBindingManager.class) {
            if (instance != null) return instance;
            instance = new DefaultBindingManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private Path getProfileFilePath(String interactionProfilePath) {
        String normalizedProfile = this.normalizeProfile(interactionProfilePath);
        String normalizedPath = normalizedProfile.startsWith("/") ? normalizedProfile.substring(1) : normalizedProfile;
        return this.bindingsDirectory.resolve(normalizedPath + ".json");
    }

    private String normalizeProfile(String interactionProfilePath) {
        return UNIFIED_PROFILES.getOrDefault(interactionProfilePath, interactionProfilePath);
    }

    private String filePathToProfilePath(Path filePath) {
        String relativePath = this.bindingsDirectory.relativize(filePath).toString();
        if (relativePath.endsWith(".json")) {
            relativePath = relativePath.substring(0, relativePath.length() - 5);
        }
        relativePath = relativePath.replace('\\', '/');
        return "/" + relativePath;
    }

    private Path getConfigFilePath() {
        return this.configDirectory.resolve(CONFIG_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigData loadConfig() {
        Object object = this.lock;
        synchronized (object) {
            Path configFile = this.getConfigFilePath();
            if (!Files.exists(configFile, new LinkOption[0])) {
                return new ConfigData();
            }
            try {
                String json = Files.readString(configFile);
                ConfigData config = (ConfigData)GSON.fromJson(json, ConfigData.class);
                return config != null ? config : new ConfigData();
            }
            catch (IOException e) {
                LOGGER.error("Failed to load config from file", (Throwable)e);
                return new ConfigData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveConfig(ConfigData config) {
        Object object = this.lock;
        synchronized (object) {
            try {
                Path configFile = this.getConfigFilePath();
                Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
                String json = GSON.toJson((Object)config);
                Files.writeString(configFile, (CharSequence)json, new OpenOption[0]);
                LOGGER.info("Saved config to {}", (Object)configFile.toAbsolutePath());
            }
            catch (IOException e) {
                LOGGER.error("Failed to save config to file", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getActiveProfile(String interactionProfilePath) {
        Object object = this.lock;
        synchronized (object) {
            String normalizedProfile = this.normalizeProfile(interactionProfilePath);
            ConfigData config = this.loadConfig();
            if (config.bindings != null && normalizedProfile.equals(config.bindings.profile)) {
                return config.bindings.active != null ? config.bindings.active : "default";
            }
            return "default";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveProfile(String interactionProfilePath, String activeProfile) {
        Object object = this.lock;
        synchronized (object) {
            String normalizedProfile = this.normalizeProfile(interactionProfilePath);
            ConfigData config = this.loadConfig();
            config.bindings = new ConfigData.BindingsConfig(normalizedProfile, activeProfile);
            this.saveConfig(config);
            LOGGER.info("Set active profile for {} (normalized to {}) to {}", new Object[]{interactionProfilePath, normalizedProfile, activeProfile});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearActiveProfile() {
        Object object = this.lock;
        synchronized (object) {
            ConfigData config = new ConfigData();
            this.saveConfig(config);
            LOGGER.info("Cleared active profile configuration");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDefaultBindingsIfNeeded(String headsetProfile, Collection<Pair<String, String>> bindings) {
        Object object = this.lock;
        synchronized (object) {
            String normalizedProfile = this.normalizeProfile(headsetProfile);
            Path profileFile = this.getProfileFilePath(normalizedProfile);
            if (Files.exists(profileFile, new LinkOption[0])) {
                LOGGER.info("Default VR controller bindings for {} (normalized to {}) already exist, skipping save", (Object)headsetProfile, (Object)normalizedProfile);
                return;
            }
            LOGGER.info("First launch detected for {} (normalized to {}), saving default VR controller bindings", (Object)headsetProfile, (Object)normalizedProfile);
            ProfileBindingsData profileData = new ProfileBindingsData();
            for (Pair<String, String> binding : bindings) {
                profileData.bindings.add(BindingEntry.fromPair(binding));
            }
            this.saveProfileToFile(profileFile, profileData);
        }
    }

    private void saveProfileToFile(Path profileFile, ProfileBindingsData profileData) {
        try {
            Files.createDirectories(profileFile.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)profileData);
            Files.writeString(profileFile, (CharSequence)json, new OpenOption[0]);
            LOGGER.info("Saved bindings to {}", (Object)profileFile.toAbsolutePath());
        }
        catch (IOException e) {
            LOGGER.error("Failed to save bindings to file", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Pair<String, String>> loadDefaultBindings(String headsetProfile) {
        Object object = this.lock;
        synchronized (object) {
            String normalizedProfile = this.normalizeProfile(headsetProfile);
            Path profileFile = this.getProfileFilePath(normalizedProfile);
            if (!Files.exists(profileFile, new LinkOption[0])) {
                LOGGER.info("No saved VR controller bindings found for {} (normalized to {})", (Object)headsetProfile, (Object)normalizedProfile);
                return null;
            }
            try {
                String json = Files.readString(profileFile);
                Type type = new TypeToken<ProfileBindingsData>(this){}.getType();
                ProfileBindingsData profileData = (ProfileBindingsData)GSON.fromJson(json, type);
                if (profileData != null && profileData.bindings != null) {
                    LOGGER.info("Loading {} saved VR controller bindings for {}", new Object[]{profileData.bindings.size(), headsetProfile, normalizedProfile});
                    return profileData.bindings.stream().map(BindingEntry::toPair).toList();
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to load bindings from file for {} (normalized to {})", new Object[]{headsetProfile, normalizedProfile, e});
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSavedBindings(String headsetProfile) {
        Object object = this.lock;
        synchronized (object) {
            String normalizedProfile = this.normalizeProfile(headsetProfile);
            Path profileFile = this.getProfileFilePath(normalizedProfile);
            return Files.exists(profileFile, new LinkOption[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAvailableProfiles() {
        Object object = this.lock;
        synchronized (object) {
            HashSet<String> profiles = new HashSet<String>();
            if (!Files.exists(this.bindingsDirectory, new LinkOption[0])) {
                return profiles;
            }
            try (Stream<Path> paths = Files.walk(this.bindingsDirectory, new FileVisitOption[0]);){
                paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".json")).forEach(path -> {
                    String profilePath = this.filePathToProfilePath((Path)path);
                    profiles.add(profilePath);
                });
            }
            catch (IOException e) {
                LOGGER.error("Failed to list available profiles", (Throwable)e);
            }
            return profiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSavedBindings() {
        Object object = this.lock;
        synchronized (object) {
            block11: {
                try {
                    if (!Files.exists(this.bindingsDirectory, new LinkOption[0])) break block11;
                    try (Stream<Path> paths = Files.walk(this.bindingsDirectory, new FileVisitOption[0]);){
                        paths.sorted(Comparator.reverseOrder()).forEach(path -> {
                            try {
                                Files.delete(path);
                            }
                            catch (IOException e) {
                                LOGGER.error("Failed to delete {}", path, (Object)e);
                            }
                        });
                    }
                    LOGGER.info("Cleared all saved bindings");
                }
                catch (IOException e) {
                    LOGGER.error("Failed to clear bindings directory", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBindingsForProfile(String headsetProfile, Collection<Pair<String, String>> bindings) {
        Object object = this.lock;
        synchronized (object) {
            String normalizedProfile = this.normalizeProfile(headsetProfile);
            Path profileFile = this.getProfileFilePath(normalizedProfile);
            ProfileBindingsData profileData = new ProfileBindingsData();
            for (Pair<String, String> binding : bindings) {
                profileData.bindings.add(BindingEntry.fromPair(binding));
            }
            this.saveProfileToFile(profileFile, profileData);
            LOGGER.info("Saved {} VR controller bindings for {} (normalized to {})", new Object[]{profileData.bindings.size(), headsetProfile, normalizedProfile});
        }
    }

    public String getUnifiedProfile(String interactionProfilePath) {
        return this.normalizeProfile(interactionProfilePath);
    }

    public boolean isUnifiedProfile(String interactionProfilePath) {
        return UNIFIED_PROFILES.containsKey(interactionProfilePath) && !interactionProfilePath.equals(UNIFIED_PROFILES.get(interactionProfilePath));
    }

    @Environment(value=EnvType.CLIENT)
    public static class ConfigData {
        public BindingsConfig bindings = new BindingsConfig();

        @Environment(value=EnvType.CLIENT)
        public static class BindingsConfig {
            public String profile;
            public String active;

            public BindingsConfig() {
                this.active = "default";
            }

            public BindingsConfig(String profile, String active) {
                this.profile = profile;
                this.active = active;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ProfileBindingsData {
        public List<BindingEntry> bindings = new ArrayList<BindingEntry>();
    }

    @Environment(value=EnvType.CLIENT)
    public static class BindingEntry {
        public String action;
        public String inputPath;

        public BindingEntry() {
        }

        public BindingEntry(String action, String inputPath) {
            this.action = action;
            this.inputPath = inputPath;
        }

        public Pair<String, String> toPair() {
            return Pair.of((Object)this.action, (Object)this.inputPath);
        }

        public static BindingEntry fromPair(Pair<String, String> pair) {
            return new BindingEntry((String)pair.getLeft(), (String)pair.getRight());
        }
    }
}

