/*
 * Decompiled with CFR 0.152.
 */
package dev.therealflo.client.screens;

import dev.therealflo.client.DefaultBindingManager;
import dev.therealflo.client.InputPathDescriptions;
import dev.therealflo.client.screens.SelectActionScreen;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.GridLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class ChangeBindingScreen
extends BaseOwoScreen<FlowLayout> {
    private String interactionProfile;
    private Collection<Pair<String, String>> allBindings;

    public ChangeBindingScreen() {
        this.interactionProfile = "/interaction_profiles/oculus/touch_controller";
    }

    public ChangeBindingScreen(String interactionProfile) {
        this.interactionProfile = interactionProfile;
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        FlowLayout mainContainer = Containers.verticalFlow((Sizing)Sizing.fill((int)90), (Sizing)Sizing.fill((int)90));
        mainContainer.padding(Insets.of((int)10));
        mainContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Controller Bindings")).color(Color.ofRgb((int)0xFFFFFF)).shadow(true).margins(Insets.bottom((int)10)));
        DefaultBindingManager manager = DefaultBindingManager.getInstance();
        this.allBindings = manager.loadDefaultBindings(this.interactionProfile);
        if (this.allBindings == null || this.allBindings.isEmpty()) {
            mainContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"No bindings found")).color(Color.ofRgb((int)0xFF0000)));
            rootComponent.child((Component)mainContainer);
            return;
        }
        Map<String, List<String>> inputToActions = this.buildInputToActionsMap(this.allBindings);
        Map<String, InputPathDescriptions.InputDescription> allInputs = InputPathDescriptions.getAllInputs(this.interactionProfile);
        ScrollContainer scrollContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fill((int)75), (Component)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()));
        FlowLayout scrollContent = (FlowLayout)scrollContainer.child();
        GridLayout headerGrid = Containers.grid((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content(), (int)1, (int)2);
        headerGrid.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Input")).color(Color.ofRgb((int)0xFFFF00)).shadow(true), 0, 0);
        headerGrid.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Bound action")).color(Color.ofRgb((int)0xFFFF00)).shadow(true), 0, 1);
        scrollContent.child((Component)headerGrid.margins(Insets.bottom((int)5)));
        Map<String, Map<String, InputPathDescriptions.InputDescription>> byHand = InputPathDescriptions.getInputsByHand(this.interactionProfile);
        for (String hand : Arrays.asList("Left", "Right")) {
            Map<String, InputPathDescriptions.InputDescription> handInputs = byHand.get(hand);
            if (handInputs.isEmpty()) continue;
            scrollContent.child((Component)Components.label((class_2561)class_2561.method_43470((String)(hand + " Hand"))).color(Color.ofRgb((int)65535)).shadow(true).margins(Insets.of((int)10, (int)0, (int)5, (int)0)));
            for (Map.Entry<String, InputPathDescriptions.InputDescription> entry : handInputs.entrySet()) {
                Object actionDisplay;
                String inputPath = entry.getKey();
                InputPathDescriptions.InputDescription inputDesc = entry.getValue();
                List boundActions = inputToActions.getOrDefault(inputPath, new ArrayList());
                if (InputPathDescriptions.isAxisInput(inputPath)) continue;
                ValidationResult validation = this.validateBindings(inputPath, this.allBindings);
                GridLayout bindingGrid = Containers.grid((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content(), (int)1, (int)2);
                bindingGrid.padding(Insets.of((int)5));
                bindingGrid.margins(Insets.bottom((int)2));
                bindingGrid.child((Component)Components.label((class_2561)class_2561.method_43470((String)inputDesc.displayName)).color(Color.ofRgb((int)0xFFFFFF)).maxWidth(150), 0, 0);
                if (boundActions.isEmpty()) {
                    actionDisplay = "Not bound";
                    actionColor = Color.ofRgb((int)0x888888);
                } else if (boundActions.size() == 1) {
                    actionName = this.getActionTranslation((String)boundActions.getFirst());
                    category = this.getActionSetCategory((String)boundActions.getFirst());
                    actionDisplay = actionName + " [" + category + "]";
                    actionColor = validation.isValid ? Color.ofRgb((int)65280) : Color.ofRgb((int)0xFF0000);
                } else {
                    actionName = this.getActionTranslation((String)boundActions.getFirst());
                    category = this.getActionSetCategory((String)boundActions.getFirst());
                    actionDisplay = actionName + " [" + category + "] (+" + (boundActions.size() - 1) + ")";
                    Color color = actionColor = validation.isValid ? Color.ofRgb((int)65280) : Color.ofRgb((int)0xFF0000);
                }
                if (!validation.isValid) {
                    actionDisplay = "[!] " + (String)actionDisplay;
                }
                if (!boundActions.isEmpty()) {
                    bindingGrid.child(Components.button((class_2561)class_2561.method_43470((String)actionDisplay), button -> this.onChangeBinding(inputPath, inputDesc, boundActions, validation)).sizing(Sizing.fill((int)50), Sizing.fixed((int)40)), 0, 1);
                } else {
                    bindingGrid.child(Components.button((class_2561)class_2561.method_43470((String)"Bind..."), button -> this.onChangeBinding(inputPath, inputDesc, boundActions, validation)).sizing(Sizing.fill((int)50), Sizing.fixed((int)40)), 0, 1);
                }
                scrollContent.child((Component)bindingGrid);
            }
        }
        mainContainer.child((Component)scrollContainer);
        FlowLayout buttonRow = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        buttonRow.horizontalAlignment(HorizontalAlignment.CENTER);
        buttonRow.gap(8);
        buttonRow.margins(Insets.top((int)10));
        buttonRow.child((Component)Components.button((class_2561)class_2561.method_43470((String)"Back"), button -> this.method_25419()));
        buttonRow.child((Component)Components.button((class_2561)class_2561.method_43470((String)"Quit Game"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1592();
            }
        }));
        mainContainer.child((Component)buttonRow);
        rootComponent.child((Component)mainContainer);
    }

    private ValidationResult validateBindings(String inputPath, Collection<Pair<String, String>> bindings) {
        int ingameModCount = 0;
        boolean hasGlobal = false;
        for (Pair<String, String> binding : bindings) {
            if (!((String)binding.getRight()).equals(inputPath)) continue;
            String action = (String)binding.getLeft();
            if (action.startsWith("/actions/global/in/")) {
                hasGlobal = true;
                continue;
            }
            if (!action.startsWith("/actions/ingame/in/") && !action.startsWith("/actions/mod/in/")) continue;
            ++ingameModCount;
        }
        if (hasGlobal && ingameModCount > 0) {
            return new ValidationResult(false, "Global binding cannot coexist with other bindings", hasGlobal, ingameModCount);
        }
        if (ingameModCount > 1) {
            return new ValidationResult(false, "Only one ingame/mod binding allowed per input", hasGlobal, ingameModCount);
        }
        return new ValidationResult(true, null, hasGlobal, ingameModCount);
    }

    private Map<String, List<String>> buildInputToActionsMap(Collection<Pair<String, String>> bindings) {
        LinkedHashMap<String, List<String>> inputToActions = new LinkedHashMap<String, List<String>>();
        for (Pair<String, String> binding : bindings) {
            String action = (String)binding.getLeft();
            String inputPath = (String)binding.getRight();
            inputToActions.computeIfAbsent(inputPath, k -> new ArrayList()).add(action);
        }
        return inputToActions;
    }

    private boolean isGameOrModAction(String action) {
        return action.startsWith("/actions/ingame/in/") || action.startsWith("/actions/mod/in/");
    }

    private String getActionSetCategory(String action) {
        if (action.startsWith("/actions/ingame/in/")) {
            return "Ingame";
        }
        if (action.startsWith("/actions/mod/in/")) {
            return "Mod";
        }
        if (action.startsWith("/actions/global/in/")) {
            return "Global";
        }
        if (action.startsWith("/actions/contextual/in/")) {
            return "Contextual";
        }
        if (action.startsWith("/actions/gui/in/")) {
            return "GUI";
        }
        if (action.startsWith("/actions/keyboard/in/")) {
            return "Keyboard";
        }
        return "Other";
    }

    private String getActionTranslation(String actionPath) {
        String[] parts = actionPath.split("/");
        String actionName = parts[parts.length - 1];
        return class_2561.method_43471((String)actionName).getString();
    }

    public void refresh() {
        if (this.uiAdapter != null && this.uiAdapter.rootComponent != null) {
            ((FlowLayout)this.uiAdapter.rootComponent).clearChildren();
            this.build((FlowLayout)this.uiAdapter.rootComponent);
        }
    }

    private void onChangeBinding(String inputPath, InputPathDescriptions.InputDescription inputDesc, List<String> boundActions, ValidationResult validation) {
        System.out.println("Opening action selection for input: " + inputPath + " (" + inputDesc.displayName + ")");
        System.out.println("Currently bound actions: " + String.valueOf(boundActions));
        if (!validation.isValid) {
            System.out.println("Warning - current bindings are invalid: " + validation.errorMessage);
        }
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new SelectActionScreen((class_437)this, this.interactionProfile, inputPath, inputDesc, this.allBindings));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ValidationResult {
        boolean isValid;
        String errorMessage;
        boolean hasGlobal;
        int ingameModCount;

        ValidationResult(boolean isValid, String errorMessage, boolean hasGlobal, int ingameModCount) {
            this.isValid = isValid;
            this.errorMessage = errorMessage;
            this.hasGlobal = hasGlobal;
            this.ingameModCount = ingameModCount;
        }
    }
}

