/*
 * Decompiled with CFR 0.152.
 */
package dev.therealflo.client.screens;

import dev.therealflo.client.DefaultBindingManager;
import dev.therealflo.client.InputPathDescriptions;
import dev.therealflo.client.RequestModClient;
import dev.therealflo.client.screens.ChangeBindingScreen;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.CheckboxComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class SelectActionScreen
extends BaseOwoScreen<FlowLayout> {
    private final class_437 parentScreen;
    private final String interactionProfile;
    private final String inputPath;
    private final InputPathDescriptions.InputDescription inputDesc;
    private final Collection<Pair<String, String>> allBindings;
    private final Set<String> currentlyBoundActions;
    private final Map<String, CheckboxComponent> actionCheckboxes = new LinkedHashMap<String, CheckboxComponent>();

    public SelectActionScreen(class_437 parentScreen, String interactionProfile, String inputPath, InputPathDescriptions.InputDescription inputDesc, Collection<Pair<String, String>> allBindings) {
        this.parentScreen = parentScreen;
        this.interactionProfile = interactionProfile;
        this.inputPath = inputPath;
        this.inputDesc = inputDesc;
        this.allBindings = allBindings;
        this.currentlyBoundActions = new HashSet<String>();
        for (Pair<String, String> binding : allBindings) {
            if (!((String)binding.getRight()).equals(inputPath)) continue;
            this.currentlyBoundActions.add((String)binding.getLeft());
        }
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        FlowLayout mainContainer = Containers.verticalFlow((Sizing)Sizing.fill((int)90), (Sizing)Sizing.fill((int)90));
        mainContainer.padding(Insets.of((int)10));
        mainContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)("Select Actions for " + this.inputDesc.displayName))).color(Color.ofRgb((int)0xFFFFFF)).shadow(true).margins(Insets.bottom((int)5)));
        mainContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)this.inputPath)).color(Color.ofRgb((int)0xAAAAAA)).margins(Insets.bottom((int)10)));
        Map<String, List<String>> actionsByCategory = this.categorizeActions();
        ScrollContainer scrollContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fill((int)70), (Component)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()));
        FlowLayout scrollContent = (FlowLayout)scrollContainer.child();
        scrollContent.padding(Insets.of((int)5));
        for (Map.Entry<String, List<String>> entry : actionsByCategory.entrySet()) {
            String category = entry.getKey();
            List<String> actions = entry.getValue();
            if (actions.isEmpty()) continue;
            scrollContent.child((Component)Components.label((class_2561)class_2561.method_43470((String)category)).color(Color.ofRgb((int)65535)).shadow(true).margins(Insets.of((int)10, (int)0, (int)5, (int)0)));
            for (String action : actions) {
                boolean isCurrentlyBound = this.currentlyBoundActions.contains(action);
                CheckboxComponent checkbox = Components.checkbox((class_2561)class_2561.method_43470((String)this.getActionTranslation(action))).checked(isCurrentlyBound);
                checkbox.margins(Insets.of((int)2, (int)0, (int)2, (int)10));
                this.actionCheckboxes.put(action, checkbox);
                scrollContent.child((Component)checkbox);
            }
        }
        mainContainer.child((Component)scrollContainer);
        FlowLayout buttonContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        buttonContainer.gap(5);
        buttonContainer.margins(Insets.top((int)10));
        buttonContainer.child((Component)Components.button((class_2561)class_2561.method_43470((String)"Apply"), button -> this.onApply()));
        buttonContainer.child((Component)Components.button((class_2561)class_2561.method_43470((String)"Cancel"), button -> this.method_25419()));
        mainContainer.child((Component)buttonContainer);
        rootComponent.child((Component)mainContainer);
    }

    private Map<String, List<String>> categorizeActions() {
        LinkedHashMap<String, List<String>> actionsByCategory = new LinkedHashMap<String, List<String>>();
        actionsByCategory.put("Global", new ArrayList());
        actionsByCategory.put("Ingame", new ArrayList());
        actionsByCategory.put("Mod", new ArrayList());
        actionsByCategory.put("Contextual", new ArrayList());
        actionsByCategory.put("GUI", new ArrayList());
        actionsByCategory.put("Keyboard", new ArrayList());
        actionsByCategory.put("Other", new ArrayList());
        List<String> allActions = RequestModClient.getAllRegisteredActions();
        if (allActions.isEmpty()) {
            System.out.println("[SelectActionScreen] Warning: Could not get registered actions, falling back to bindings only");
            HashSet<String> bindingActions = new HashSet<String>();
            for (Pair<String, String> binding : this.allBindings) {
                bindingActions.add((String)binding.getLeft());
            }
            allActions = new ArrayList<String>(bindingActions);
        }
        System.out.println("[SelectActionScreen] Total actions available: " + allActions.size());
        allActions.sort(String::compareTo);
        for (String string : allActions) {
            String category = this.getActionSetCategory(string);
            ((List)actionsByCategory.get(category)).add(string);
        }
        for (Map.Entry entry : actionsByCategory.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            System.out.println("[SelectActionScreen] Category '" + (String)entry.getKey() + "' has " + ((List)entry.getValue()).size() + " actions");
        }
        return actionsByCategory;
    }

    private String getActionSetCategory(String action) {
        if (action.startsWith("/actions/ingame/in/")) {
            return "Ingame";
        }
        if (action.startsWith("/actions/mod/in/")) {
            return "Mod";
        }
        if (action.startsWith("/actions/global/in/")) {
            return "Global";
        }
        if (action.startsWith("/actions/contextual/in/")) {
            return "Contextual";
        }
        if (action.startsWith("/actions/gui/in/")) {
            return "GUI";
        }
        if (action.startsWith("/actions/keyboard/in/")) {
            return "Keyboard";
        }
        return "Other";
    }

    private String getActionTranslation(String actionPath) {
        String[] parts = actionPath.split("/");
        String actionName = parts[parts.length - 1];
        return class_2561.method_43471((String)actionName).getString();
    }

    private void onApply() {
        HashSet<String> selectedActions = new HashSet<String>();
        for (Map.Entry<String, CheckboxComponent> entry : this.actionCheckboxes.entrySet()) {
            if (!entry.getValue().method_20372()) continue;
            selectedActions.add(entry.getKey());
        }
        ArrayList<Pair<String, String>> newBindings = new ArrayList<Pair<String, String>>();
        for (Pair<String, String> pair : this.allBindings) {
            if (((String)pair.getRight()).equals(this.inputPath)) continue;
            newBindings.add(pair);
        }
        for (String string : selectedActions) {
            newBindings.add((Pair<String, String>)Pair.of((Object)string, (Object)this.inputPath));
        }
        DefaultBindingManager defaultBindingManager = DefaultBindingManager.getInstance();
        defaultBindingManager.saveBindingsForProfile(this.interactionProfile, newBindings);
        System.out.println("Saved " + newBindings.size() + " bindings for " + this.interactionProfile);
        System.out.println("Input " + this.inputPath + " now has " + selectedActions.size() + " actions bound");
        this.method_25419();
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            class_437 class_4372 = this.parentScreen;
            if (class_4372 instanceof ChangeBindingScreen) {
                ChangeBindingScreen changeBindingScreen = (ChangeBindingScreen)class_4372;
                changeBindingScreen.refresh();
            }
            this.field_22787.method_1507(this.parentScreen);
        }
    }
}

