package dev.thomasglasser.sherdsapi.impl.mixin;

import dev.thomasglasser.sherdsapi.api.SherdsApiDataComponents;
import dev.thomasglasser.sherdsapi.impl.StackPotDecorations;
import dev.thomasglasser.sherdsapi.impl.StackPotDecorationsHolder;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_8172;
import net.minecraft.class_9323;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_8172.class)
public abstract class DecoratedPotBlockEntityMixin extends class_2586 implements StackPotDecorationsHolder {
    @Unique
    private @Nullable StackPotDecorations sherdsapi$decorations = null;

    private DecoratedPotBlockEntityMixin(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
    }

    @Inject(method = "saveAdditional", at = @At("TAIL"))
    private void saveAdditional(class_11372 output, CallbackInfo ci) {
        if (sherdsapi$decorations != null) {
            output.method_71468("stack_sherds", StackPotDecorations.CODEC, this.sherdsapi$decorations);
        }
    }

    @Inject(method = "loadAdditional", at = @At("TAIL"))
    private void loadAdditional(class_11368 input, CallbackInfo ci) {
        this.sherdsapi$decorations = input.method_71426("stack_sherds", StackPotDecorations.CODEC).orElse(null);
    }

    @Inject(method = "collectImplicitComponents", at = @At("TAIL"))
    private void collectImplicitComponents(class_9323.class_9324 components, CallbackInfo ci) {
        components.method_57840(SherdsApiDataComponents.STACK_POT_DECORATIONS.get(), this.sherdsapi$decorations);
    }

    @Inject(method = "applyImplicitComponents", at = @At("TAIL"))
    private void applyImplicitComponents(class_9473 dataComponentGetter, CallbackInfo ci) {
        this.sherdsapi$decorations = dataComponentGetter.method_58694(SherdsApiDataComponents.STACK_POT_DECORATIONS.get());
    }

    @Inject(method = "removeComponentsFromTag", at = @At("TAIL"))
    private void removeComponentsFromTag(class_11372 output, CallbackInfo ci) {
        output.method_71478("stack_sherds");
    }

    @Override
    public StackPotDecorations sherdsapi$getDecorations() {
        return sherdsapi$decorations;
    }
}
