package dev.thomasglasser.sherdsapi.impl.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.thomasglasser.sherdsapi.api.SherdsApiDataComponents;
import dev.thomasglasser.sherdsapi.impl.StackPotDecorations;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_8164;
import net.minecraft.class_9694;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_8164.class)
public class DecoratedPotRecipeMixin {
    @WrapOperation(method = "matches(Lnet/minecraft/world/item/crafting/CraftingInput;Lnet/minecraft/world/level/Level;)Z", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;is(Lnet/minecraft/tags/TagKey;)Z"))
    private boolean matches(class_1799 instance, class_6862<class_1792> tag, Operation<Boolean> original) {
        return original.call(instance, tag) || instance.method_57826(SherdsApiDataComponents.SHERD_PATTERN.get());
    }

    @Inject(method = "assemble(Lnet/minecraft/world/item/crafting/CraftingInput;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/item/ItemStack;", at = @At("HEAD"), cancellable = true)
    private void assemble(class_9694 input, class_7225.class_7874 provider, CallbackInfoReturnable<class_1799> cir) {
        if (input.method_59989().stream().anyMatch(stack -> stack.method_57826(SherdsApiDataComponents.SHERD_PATTERN.get()))) {
            StackPotDecorations decorations = new StackPotDecorations(input.method_59984(1).method_46651(1), input.method_59984(3).method_46651(1), input.method_59984(5).method_46651(1), input.method_59984(7).method_46651(1));
            cir.setReturnValue(StackPotDecorations.createDecoratedPotItem(decorations));
        }
    }
}
