package dev.thomasglasser.sherdsapi.impl.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import dev.thomasglasser.sherdsapi.api.SherdsApiDataComponents;
import dev.thomasglasser.sherdsapi.impl.StackPotDecorations;
import dev.thomasglasser.sherdsapi.impl.StackPotDecorationsHolder;
import dev.thomasglasser.sherdsapi.impl.StackPotRenderer;
import dev.thomasglasser.sherdsapi.impl.client.renderer.blockentity.state.StackDecoratedPotRenderState;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1058;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11701;
import net.minecraft.class_11963;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_630;
import net.minecraft.class_8172;
import net.minecraft.class_8188;
import net.minecraft.class_827;
import net.minecraft.class_8526;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_8188.class)
public abstract class DecoratedPotRendererMixin implements class_827<class_8172, class_11963>, StackPotRenderer {
    @Shadow
    private static class_4730 getSideMaterial(Optional<class_1792> item) {
        return null;
    }

    @Shadow
    @Final
    private class_11701 materials;

    @Shadow
    @Final
    private class_630 neck;

    @Shadow
    @Final
    private class_630 top;

    @Shadow
    @Final
    private class_630 bottom;

    @Shadow
    @Final
    private class_630 frontSide;

    @Shadow
    @Final
    private class_630 backSide;

    @Shadow
    @Final
    private class_630 leftSide;

    @Shadow
    @Final
    private class_630 rightSide;

    @Override
    public class_11963 method_74335() {
        return new StackDecoratedPotRenderState();
    }

    @Inject(method = "extractRenderState(Lnet/minecraft/world/level/block/entity/DecoratedPotBlockEntity;Lnet/minecraft/client/renderer/blockentity/state/DecoratedPotRenderState;FLnet/minecraft/world/phys/Vec3;Lnet/minecraft/client/renderer/feature/ModelFeatureRenderer$CrumblingOverlay;)V", at = @At("TAIL"))
    public void extractRenderState(class_8172 blockEntity, class_11963 renderState, float partialTick, class_243 cameraPosition, class_11683.class_11792 breakProgress, CallbackInfo ci) {
        if (blockEntity.method_51511() == class_8526.field_44707 && blockEntity instanceof StackPotDecorationsHolder holder) {
            StackPotDecorations stackPotDecorations = holder.sherdsapi$getDecorations();
            if (stackPotDecorations != null) {
                ((StackDecoratedPotRenderState) (renderState)).stackDecorations = stackPotDecorations;
            }
        }
    }

    @WrapOperation(method = "submit(Lnet/minecraft/client/renderer/blockentity/state/DecoratedPotRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Lnet/minecraft/client/renderer/state/CameraRenderState;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/blockentity/DecoratedPotRenderer;submit(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;IILnet/minecraft/world/level/block/entity/PotDecorations;I)V"))
    private void submit(class_8188 instance, class_4587 poseStack, class_11659 nodeCollector, int packedLight, int packedOverlay, class_8526 decorations, int outlineColor, Operation<Void> original, @Local(argsOnly = true) class_11963 renderState) {
        StackPotDecorations stackDecorations = ((StackDecoratedPotRenderState) renderState).stackDecorations;
        if (stackDecorations != null) {
            sherdsapi$submit(poseStack, nodeCollector, packedLight, packedOverlay, stackDecorations, outlineColor);
        } else {
            original.call(instance, poseStack, nodeCollector, packedLight, packedOverlay, decorations, outlineColor);
        }
    }

    @Override
    public void sherdsapi$submit(class_4587 poseStack, class_11659 nodeCollector, int packedLight, int packedOverlay, StackPotDecorations decorations, int outlineColor) {
        class_1921 rendertype = class_4722.field_51914.method_24146(class_1921::method_23572);
        class_1058 textureatlassprite = this.materials.method_73030(class_4722.field_51914);
        nodeCollector.method_73494(this.neck, poseStack, rendertype, packedLight, packedOverlay, textureatlassprite, false, false, -1, null, outlineColor);
        nodeCollector.method_73494(this.top, poseStack, rendertype, packedLight, packedOverlay, textureatlassprite, false, false, -1, null, outlineColor);
        nodeCollector.method_73494(this.bottom, poseStack, rendertype, packedLight, packedOverlay, textureatlassprite, false, false, -1, null, outlineColor);
        class_4730 material = sherdsapi$getSideMaterial(decorations.front());
        nodeCollector.method_73494(this.frontSide, poseStack, material.method_24146(class_1921::method_23572), packedLight, packedOverlay, this.materials.method_73030(material), false, false, -1, null, outlineColor);
        class_4730 material1 = sherdsapi$getSideMaterial(decorations.back());
        nodeCollector.method_73494(this.backSide, poseStack, material1.method_24146(class_1921::method_23572), packedLight, packedOverlay, this.materials.method_73030(material1), false, false, -1, null, outlineColor);
        class_4730 material2 = sherdsapi$getSideMaterial(decorations.left());
        nodeCollector.method_73494(this.leftSide, poseStack, material2.method_24146(class_1921::method_23572), packedLight, packedOverlay, this.materials.method_73030(material2), false, false, -1, null, outlineColor);
        class_4730 material3 = sherdsapi$getSideMaterial(decorations.right());
        nodeCollector.method_73494(this.rightSide, poseStack, material3.method_24146(class_1921::method_23572), packedLight, packedOverlay, this.materials.method_73030(material3), false, false, -1, null, outlineColor);
    }

    @Unique
    private static final Map<class_2960, class_4730> CUSTOM_MATERIALS = new HashMap<>();

    @Unique
    private static class_4730 sherdsapi$getDecoratedPotMaterial(class_2960 key) {
        return CUSTOM_MATERIALS.computeIfAbsent(key, class_4722.field_56360::method_67273);
    }

    @Unique
    private static class_4730 sherdsapi$getSideMaterial(Optional<class_1799> optional) {
        if (optional.isPresent()) {
            class_1799 stack = optional.get();
            if (stack.method_57826(SherdsApiDataComponents.SHERD_PATTERN.get())) {
                return sherdsapi$getDecoratedPotMaterial(stack.method_58694(SherdsApiDataComponents.SHERD_PATTERN.get()));
            } else {
                return getSideMaterial(Optional.of(stack.method_7909()));
            }
        }

        return class_4722.field_51915;
    }
}
