package dev.thomasglasser.sherdsapi.impl;

import com.mojang.serialization.Codec;
import dev.thomasglasser.sherdsapi.api.SherdsApiDataComponents;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public record StackPotDecorations(Optional<class_1799> back, Optional<class_1799> left, Optional<class_1799> right, Optional<class_1799> front) {

    public static final Codec<StackPotDecorations> CODEC = class_1799.field_49266
            .sizeLimitedListOf(4)
            .xmap(StackPotDecorations::new, StackPotDecorations::ordered);
    public static final class_9139<class_9129, StackPotDecorations> STREAM_CODEC = class_1799.field_49268
            .method_56433(class_9135.method_58000(4))
            .method_56432(StackPotDecorations::new, StackPotDecorations::ordered);

    private static final StackPotDecorations EMPTY = new StackPotDecorations(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    private StackPotDecorations(List<class_1799> p_331803_) {
        this(getItem(p_331803_, 0), getItem(p_331803_, 1), getItem(p_331803_, 2), getItem(p_331803_, 3));
    }

    public StackPotDecorations(class_1799 p_331754_, class_1799 p_331488_, class_1799 p_331845_, class_1799 p_330988_) {
        this(List.of(p_331754_, p_331488_, p_331845_, p_330988_));
    }

    private static Optional<class_1799> getItem(List<class_1799> decorations, int index) {
        if (index >= decorations.size()) {
            return Optional.empty();
        } else {
            class_1799 item = decorations.get(index);
            return item.method_31574(class_1802.field_8621) ? Optional.empty() : Optional.of(item);
        }
    }

    public class_2487 save(class_2487 tag) {
        if (this.equals(EMPTY)) {
            return tag;
        } else {
            tag.method_10566("patterns", CODEC.encodeStart(class_2509.field_11560, this).getOrThrow());
            return tag;
        }
    }

    public List<class_1799> ordered() {
        return Stream.of(this.back, this.left, this.right, this.front).map(p_331733_ -> p_331733_.orElse(class_1802.field_8621.method_7854())).toList();
    }

    public static @Nullable StackPotDecorations load(@Nullable class_2487 tag) {
        return tag != null && tag.method_10545("patterns") ? CODEC.parse(class_2509.field_11560, tag.method_10580("patterns")).result().orElse(null) : null;
    }

    public static class_1799 createDecoratedPotItem(StackPotDecorations decorations) {
        class_1799 itemstack = class_1802.field_42699.method_7854();
        itemstack.method_57379(SherdsApiDataComponents.STACK_POT_DECORATIONS.get(), decorations);
        return itemstack;
    }
}
