package dev.thomasglasser.sherdsapi.impl.mixin;

import dev.thomasglasser.sherdsapi.api.SherdsApiDataComponents;
import dev.thomasglasser.sherdsapi.impl.StackPotDecorations;
import dev.thomasglasser.sherdsapi.impl.StackPotDecorationsHolder;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_8172;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_8172.class)
public abstract class DecoratedPotBlockEntityMixin extends class_2586 implements StackPotDecorationsHolder {
    @Unique
    private @Nullable StackPotDecorations sherdsapi$decorations = null;

    private DecoratedPotBlockEntityMixin(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
    }

    @Inject(method = "saveAdditional", at = @At("TAIL"))
    private void saveAdditional(class_2487 tag, class_7225.class_7874 registries, CallbackInfo ci) {
        if (sherdsapi$decorations != null) {
            sherdsapi$decorations.save(tag);
        }
    }

    @Inject(method = "loadAdditional", at = @At("TAIL"))
    private void loadAdditional(class_2487 tag, class_7225.class_7874 registries, CallbackInfo ci) {
        sherdsapi$decorations = StackPotDecorations.load(tag);
    }

    @Inject(method = "collectImplicitComponents", at = @At("TAIL"))
    private void collectImplicitComponents(class_9323.class_9324 components, CallbackInfo ci) {
        if (sherdsapi$decorations != null) {
            components.method_57840(SherdsApiDataComponents.STACK_POT_DECORATIONS.get(), sherdsapi$decorations);
        }
    }

    @Inject(method = "applyImplicitComponents", at = @At("TAIL"))
    private void applyImplicitComponents(class_2586.class_9473 componentInput, CallbackInfo ci) {
        sherdsapi$decorations = componentInput.method_58694(SherdsApiDataComponents.STACK_POT_DECORATIONS.get());
    }

    @Inject(method = "removeComponentsFromTag", at = @At("TAIL"))
    private void removeComponentsFromTag(class_2487 tag, CallbackInfo ci) {
        tag.method_10551("patterns");
    }

    @Override
    public StackPotDecorations sherdsapi$getDecorations() {
        return sherdsapi$decorations;
    }
}
