package dev.thomasglasser.sherdsapi.impl.mixin;

import dev.thomasglasser.sherdsapi.api.SherdsApiDataComponents;
import dev.thomasglasser.sherdsapi.impl.StackPotDecorations;
import dev.thomasglasser.sherdsapi.impl.StackPotDecorationsHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_630;
import net.minecraft.class_8172;
import net.minecraft.class_8188;
import net.minecraft.class_8526;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_8188.class)
public abstract class DecoratedPotRendererMixin {
    @Shadow
    protected abstract void renderSide(class_630 modelPart, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay, class_4730 material);

    @Shadow
    @Final
    private class_630 frontSide;
    @Shadow
    @Final
    private class_630 backSide;
    @Shadow
    @Final
    private class_630 leftSide;
    @Shadow
    @Final
    private class_630 rightSide;

    @Shadow
    private static class_4730 getSideMaterial(Optional<class_1792> item) {
        return null;
    }

    @Inject(method = "render(Lnet/minecraft/world/level/block/entity/DecoratedPotBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/entity/DecoratedPotBlockEntity;getDecorations()Lnet/minecraft/world/level/block/entity/PotDecorations;"), cancellable = true)
    private void render(class_8172 blockEntity, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, CallbackInfo ci) {
        if (blockEntity.method_51511() == class_8526.field_44707 && blockEntity instanceof StackPotDecorationsHolder holder) {
            StackPotDecorations decorations = holder.sherdsapi$getDecorations();
            if (decorations != null) {
                renderSide(frontSide, poseStack, bufferSource, packedLight, packedOverlay, sherdsapi$getSideMaterial(decorations.front()));
                renderSide(backSide, poseStack, bufferSource, packedLight, packedOverlay, sherdsapi$getSideMaterial(decorations.back()));
                renderSide(leftSide, poseStack, bufferSource, packedLight, packedOverlay, sherdsapi$getSideMaterial(decorations.left()));
                renderSide(rightSide, poseStack, bufferSource, packedLight, packedOverlay, sherdsapi$getSideMaterial(decorations.right()));
                poseStack.method_22909();
                ci.cancel();
            }
        }
    }

    @Unique
    private static final Map<class_2960, class_4730> CUSTOM_MATERIALS = new HashMap<>();

    @Unique
    private static class_4730 sherdsapi$getDecoratedPotMaterial(class_2960 location) {
        return CUSTOM_MATERIALS.computeIfAbsent(location, class_4722::method_49342);
    }

    @Unique
    private static class_4730 sherdsapi$getSideMaterial(Optional<class_1799> optional) {
        if (optional.isPresent()) {
            class_1799 stack = optional.get();
            if (stack.method_57826(SherdsApiDataComponents.SHERD_PATTERN.get())) {
                class_4730 material = sherdsapi$getDecoratedPotMaterial(stack.method_57824(SherdsApiDataComponents.SHERD_PATTERN.get()));
                if (material != null) {
                    return material;
                }
            } else {
                return getSideMaterial(Optional.of(stack.method_7909()));
            }
        }

        return class_4722.field_51915;
    }
}
