/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.netherportalfix;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.PlayerChangedDimensionEvent;
import net.blay09.mods.netherportalfix.ReturnPortalManager;
import net.blay09.mods.netherportalfix.mixin.LivingEntityAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetherPortalFix {
    public static final String MOD_ID = "netherportalfix";
    public static final Logger logger = LogManager.getLogger();

    public static void initialize() {
        Balm.getNetworking().allowServerOnly(MOD_ID);
        Balm.getEvents().onEvent(PlayerChangedDimensionEvent.class, event -> {
            ServerPlayer player = event.getPlayer();
            ResourceKey fromDim = event.getFromDim();
            ResourceKey toDim = event.getToDim();
            ResourceKey OVERWORLD = Level.OVERWORLD;
            ResourceKey THE_NETHER = Level.NETHER;
            if (!(fromDim == OVERWORLD && toDim == THE_NETHER || fromDim == THE_NETHER && toDim == OVERWORLD)) {
                logger.debug("Not storing return portal because it's from {} to {}", (Object)fromDim, (Object)toDim);
                return;
            }
            BlockPos lastPos = ((LivingEntityAccessor)player).getLastPos();
            if (lastPos == null) {
                logger.debug("Not storing return portal because I just spawned.");
                return;
            }
            BlockPos fromPortal = ReturnPortalManager.findPortalAt((Player)player, (ResourceKey<Level>)fromDim, lastPos);
            BlockPos toPos = player.blockPosition();
            if (fromPortal == null) {
                logger.debug("Not storing return portal because I'm not in a portal.");
                return;
            }
            ReturnPortalManager.storeReturnPortal(player, (ResourceKey<Level>)toDim, toPos, fromPortal);
            logger.debug("Storing return portal from {} to {} in {}", (Object)toDim, (Object)fromPortal, (Object)fromDim);
        });
    }
}

