/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.block;

import com.google.common.collect.Lists;
import com.xcompwiz.mystcraft.data.ModBlocks;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.item.ItemAgebook;
import com.xcompwiz.mystcraft.item.ItemLinkbook;
import com.xcompwiz.mystcraft.linking.LinkOptions;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thefloydman.moremystcraft.config.MoreMystcraftConfig;
import thefloydman.moremystcraft.init.MoreMystcraftBlocks;
import thefloydman.moremystcraft.portal.MoreMystcraftPortalUtils;
import thefloydman.moremystcraft.tileentity.TileEntityUnstableBookReceptacle;

public class BlockUnstablePortal
extends BlockBreakable {
    public static final PropertyEnum<EnumFacing> SOURCE_DIRECTION = PropertyEnum.func_177709_a((String)"source", EnumFacing.class);
    public static final PropertyBool IS_PART_OF_PORTAL = PropertyBool.func_177716_a((String)"active");
    public static final PropertyEnum<EnumFacing.Axis> RENDER_ROTATION = PropertyEnum.func_177709_a((String)"renderface", EnumFacing.Axis.class);
    public static final PropertyBool HAS_ROTATION = PropertyBool.func_177716_a((String)"hasface");

    public BlockUnstablePortal() {
        super(Material.field_151567_E, false);
        this.func_149675_a(true);
        this.func_149722_s();
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149715_a(0.75f);
        this.func_149663_c("moremystcraft.unstable_portal");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)HAS_ROTATION, (Comparable)Boolean.valueOf(false)).func_177226_a(RENDER_ROTATION, (Comparable)EnumFacing.Axis.X).func_177226_a((IProperty)IS_PART_OF_PORTAL, (Comparable)Boolean.valueOf(false)).func_177226_a(SOURCE_DIRECTION, (Comparable)EnumFacing.DOWN));
    }

    public IBlockState func_176203_a(int meta) {
        if (meta == 0) {
            return this.func_176223_P();
        }
        int sh = meta - 1;
        return this.func_176223_P().func_177226_a((IProperty)IS_PART_OF_PORTAL, (Comparable)Boolean.valueOf(true)).func_177226_a(SOURCE_DIRECTION, (Comparable)EnumFacing.values()[sh]);
    }

    public int func_176201_c(IBlockState state) {
        int side = ((EnumFacing)state.func_177229_b(SOURCE_DIRECTION)).ordinal();
        return (Boolean)state.func_177229_b((IProperty)IS_PART_OF_PORTAL) != false ? side + 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SOURCE_DIRECTION, IS_PART_OF_PORTAL, HAS_ROTATION, RENDER_ROTATION});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        int i;
        ArrayList validAxis = Lists.newArrayList();
        boolean has = true;
        EnumFacing offset = EnumFacing.NORTH;
        EnumFacing.Axis axis = EnumFacing.Axis.X;
        for (i = 0; i < 4; ++i) {
            if (this.isPortalBlock(worldIn.func_180495_p(pos.func_177972_a(offset = offset.func_176732_a(axis))))) continue;
            has = false;
            break;
        }
        if (has) {
            validAxis.add(axis);
        }
        has = true;
        offset = EnumFacing.NORTH;
        axis = EnumFacing.Axis.Y;
        for (i = 0; i < 4; ++i) {
            if (this.isPortalBlock(worldIn.func_180495_p(pos.func_177972_a(offset = offset.func_176732_a(axis))))) continue;
            has = false;
            break;
        }
        if (has) {
            validAxis.add(axis);
        }
        has = true;
        offset = EnumFacing.UP;
        axis = EnumFacing.Axis.Z;
        for (i = 0; i < 4; ++i) {
            if (this.isPortalBlock(worldIn.func_180495_p(pos.func_177972_a(offset = offset.func_176732_a(axis))))) continue;
            has = false;
            break;
        }
        if (has) {
            validAxis.add(axis);
        }
        state = state.func_177226_a((IProperty)HAS_ROTATION, (Comparable)Boolean.valueOf(validAxis.size() == 1));
        if (validAxis.size() == 1) {
            state = state.func_177226_a(RENDER_ROTATION, (Comparable)validAxis.get(0));
        }
        return state;
    }

    private boolean isPortalBlock(IBlockState state) {
        return state.func_177230_c().equals(MoreMystcraftBlocks.UNSTABLE_PORTAL) || state.func_177230_c().equals(ModBlocks.crystal);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        float xmin = 0.25f;
        float xmax = 0.75f;
        float ymin = 0.25f;
        float ymax = 0.75f;
        float zmin = 0.25f;
        float zmax = 0.75f;
        if (MoreMystcraftPortalUtils.isValidLinkPortalBlock(source.func_180495_p(pos.func_177972_a(EnumFacing.WEST))) > 0) {
            xmin = 0.0f;
        }
        if (MoreMystcraftPortalUtils.isValidLinkPortalBlock(source.func_180495_p(pos.func_177972_a(EnumFacing.EAST))) > 0) {
            xmax = 1.0f;
        }
        if (MoreMystcraftPortalUtils.isValidLinkPortalBlock(source.func_180495_p(pos.func_177972_a(EnumFacing.DOWN))) > 0) {
            ymin = 0.0f;
        }
        if (MoreMystcraftPortalUtils.isValidLinkPortalBlock(source.func_180495_p(pos.func_177972_a(EnumFacing.UP))) > 0) {
            ymax = 1.0f;
        }
        if (MoreMystcraftPortalUtils.isValidLinkPortalBlock(source.func_180495_p(pos.func_177972_a(EnumFacing.NORTH))) > 0) {
            zmin = 0.0f;
        }
        if (MoreMystcraftPortalUtils.isValidLinkPortalBlock(source.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH))) > 0) {
            zmax = 1.0f;
        }
        return new AxisAlignedBB((double)xmin, (double)ymin, (double)zmin, (double)xmax, (double)ymax, (double)zmax);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!((Boolean)blockState.func_177229_b((IProperty)HAS_ROTATION)).booleanValue()) {
            IBlockState offset = blockAccess.func_180495_p(pos.func_177972_a(side));
            return !this.isPortalBlock(offset = offset.func_185899_b(blockAccess, pos.func_177972_a(side))) || !offset.func_177230_c().equals(ModBlocks.crystal) && (Boolean)offset.func_177229_b((IProperty)HAS_ROTATION) != false;
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public static int colorMultiplier(IBlockAccess blockAccess, BlockPos pos) {
        return new Color(255, 0, 0).getRGB();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (worldIn.field_72995_K) {
            return;
        }
        MoreMystcraftPortalUtils.validatePortal(worldIn, pos);
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity tileEntity = MoreMystcraftPortalUtils.getTileEntity((IBlockAccess)worldIn, pos);
        if (tileEntity == null || !(tileEntity instanceof TileEntityUnstableBookReceptacle)) {
            worldIn.func_175698_g(pos);
            return;
        }
        TileEntityUnstableBookReceptacle container = (TileEntityUnstableBookReceptacle)tileEntity;
        if (container.getBook().func_190926_b()) {
            worldIn.func_175698_g(pos);
        } else if (container.getBook().func_77973_b().equals(ModItems.agebook) && entityIn instanceof EntityPlayer) {
            ItemStack bookStack = container.getBook().func_77946_l();
            ItemAgebook bookItem = (ItemAgebook)bookStack.func_77973_b();
            ItemAgebook.create((ItemStack)bookStack, (EntityPlayer)((EntityPlayer)entityIn), (List)bookItem.getPageList((EntityPlayer)entityIn, bookStack), (String)bookItem.getTitle(bookStack));
            bookItem.activate(bookStack, worldIn, entityIn);
        } else if (container.getBook().func_77973_b().equals(ModItems.linkbook)) {
            double x = Math.random() * 20000.0 - 10000.0;
            double y = 255.0;
            double z = Math.random() * 20000.0 - 10000.0;
            BlockPos spawnPos = new BlockPos(x, y, z);
            ItemStack bookStack = container.getBook().func_77946_l();
            LinkOptions linkinfo = new LinkOptions(bookStack.func_77978_p());
            LinkOptions.setSpawn((NBTTagCompound)bookStack.func_77978_p(), (BlockPos)spawnPos);
            ItemLinkbook bookItem = (ItemLinkbook)bookStack.func_77973_b();
            bookItem.activate(bookStack, worldIn, entityIn);
            BlockPos refinedSpawn = this.getHighestBlockAt(entityIn.func_130014_f_(), spawnPos);
            int attempts = 0;
            while (refinedSpawn == null) {
                new MoreMystcraftConfig();
                if (attempts >= MoreMystcraftConfig.getSpawnAttempts()) break;
                x = Math.random() * 20000.0 - 10000.0;
                z = Math.random() * 20000.0 - 10000.0;
                spawnPos = new BlockPos(x, y, z);
                refinedSpawn = this.getHighestBlockAt(entityIn.func_130014_f_(), spawnPos);
                new MoreMystcraftConfig();
                if (attempts == MoreMystcraftConfig.getSpawnAttempts() - 1) {
                    refinedSpawn = spawnPos;
                }
                ++attempts;
            }
            entityIn.func_70634_a((double)refinedSpawn.func_177958_n(), (double)refinedSpawn.func_177956_o(), (double)refinedSpawn.func_177952_p());
        }
    }

    private BlockPos getHighestBlockAt(World world, BlockPos pos) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        for (int y = 255; y > 0; --y) {
            pos = new BlockPos(x, y, z);
            Material matCur = world.func_180495_p(pos).func_185904_a();
            if (matCur.equals(Material.field_151579_a) || matCur.equals(Material.field_151570_A) || matCur.equals(Material.field_151581_o)) {
                continue;
            }
            if (matCur.func_76224_d()) {
                return null;
            }
            pos = pos.func_177984_a();
            return pos;
        }
        return null;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.field_72995_K) {
            return;
        }
        MoreMystcraftPortalUtils.validatePortal(worldIn, pos);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        if (worldIn.field_72995_K) {
            return;
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
    }
}

