/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="moremystcraft")
public class MoreMystcraftConfig {
    @Config.Name(value="locked_blocks")
    public static CategoryLocked catLockedBlocks = new CategoryLocked();
    @Config.Name(value="unstable_receptacle")
    public static CategoryUnstable catUnstable = new CategoryUnstable();
    @Config.Name(value="added_blocks")
    public static CategoryAddedBlocks catAddedBlocks = new CategoryAddedBlocks();
    @Config.Name(value="abandoned_studies")
    public static CategoryStudies catStudies = new CategoryStudies();
    @Config.Name(value="libraries")
    public static CategoryLibraries catLibraries = new CategoryLibraries();
    @Config.Name(value="other")
    public static CategoryOther catOther = new CategoryOther();

    public static boolean getBookBinderRecipeEnabled() {
        return MoreMystcraftConfig.catOther.bookBinderRecipeEnabled;
    }

    public static int getStudyMinimumY() {
        return MoreMystcraftConfig.catStudies.studyMinimumY;
    }

    public static int getStudyFrequency() {
        return MoreMystcraftConfig.catStudies.studyFrequency;
    }

    public static boolean getStudiesEnabled() {
        return MoreMystcraftConfig.catStudies.abandonedStudiesOverworldEnabled;
    }

    public static boolean getTrafficConeEnabled() {
        return MoreMystcraftConfig.catAddedBlocks.trafficConeEnabled;
    }

    public static boolean getTrafficConeRecipeEnabled() {
        return MoreMystcraftConfig.catAddedBlocks.trafficConeRecipeEnabled;
    }

    public static boolean getNexusControllerEnabled() {
        return MoreMystcraftConfig.catAddedBlocks.nexusControllerEnabled;
    }

    public static boolean getNexusControllerRecipeEnabled() {
        return MoreMystcraftConfig.catAddedBlocks.nexusControllerRecipeEnabled;
    }

    public static boolean getUnstableReceptacleEnabled() {
        return MoreMystcraftConfig.catUnstable.unstableReceptacleEnabled;
    }

    public static boolean getUnstableReceptacleRecipeEnabled() {
        return MoreMystcraftConfig.catUnstable.unstableReceptacleRecipeEnabled;
    }

    public static int getSpawnAttempts() {
        return MoreMystcraftConfig.catUnstable.unstableLinkingAttempts;
    }

    public static boolean getLockedLecternEnabled() {
        return MoreMystcraftConfig.catLockedBlocks.lockedLecternEnabled;
    }

    public static boolean getLockedBookstandEnabled() {
        return MoreMystcraftConfig.catLockedBlocks.lockedBookstandEnabled;
    }

    public static boolean getLockedLecternRecipeDisabled() {
        return MoreMystcraftConfig.catLockedBlocks.lockedLecternRecipeEnabled;
    }

    public static boolean getLockedBookstandRecipeEnabled() {
        return MoreMystcraftConfig.catLockedBlocks.lockedBookstandRecipeEnabled;
    }

    public static boolean getLibrariesEnabled() {
        return MoreMystcraftConfig.catLibraries.librariesEnabled;
    }

    public static boolean getLibrariesUpgraded() {
        return MoreMystcraftConfig.catLibraries.librariesUpgraded;
    }

    public static int getGreatLibraryPercentage() {
        return MoreMystcraftConfig.catLibraries.greatLibrariesPercentage;
    }

    public static boolean getMaintainerSuitEnabled() {
        return MoreMystcraftConfig.catOther.maintainerSuitEnabled;
    }

    public static boolean getMaintainerSuitRecipeEnabled() {
        return MoreMystcraftConfig.catOther.maintainerSuitRecipeEnabled;
    }

    public static boolean getJourneysEnabled() {
        return MoreMystcraftConfig.catAddedBlocks.journeysEnabled;
    }

    public static boolean getJourneyRecipesEnabled() {
        return MoreMystcraftConfig.catAddedBlocks.journeyRecipesEnabled;
    }

    public static boolean getUnlinkedBooksEnabledInAdventureMode() {
        return MoreMystcraftConfig.catOther.unlinkedBooksEnabledInAdventureMode;
    }

    public static boolean getPostMessageOnLink() {
        return MoreMystcraftConfig.catOther.postMessageOnLink;
    }

    public static boolean getAdventureLinkPanelEnabled() {
        return MoreMystcraftConfig.catOther.adventureLinkPanelEnabled;
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("moremystcraft")) {
                ConfigManager.sync((String)"moremystcraft", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    private static class CategoryOther {
        @Config.RequiresMcRestart
        @Config.Name(value="Mystcraft's book binder recipe enabled")
        public boolean bookBinderRecipeEnabled = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Maintainer suit enabled")
        public boolean maintainerSuitEnabled = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Maintainer suit recipe enabled")
        public boolean maintainerSuitRecipeEnabled = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Adventure Mode link panel enabled")
        public boolean adventureLinkPanelEnabled = false;
        @Config.Name(value="Adventure Mode players can use Unlinked Books")
        public boolean unlinkedBooksEnabledInAdventureMode = true;
        @Config.Name(value="Be warned about possible lag when someone links.")
        public boolean postMessageOnLink = false;

        private CategoryOther() {
        }
    }

    private static class CategoryLibraries {
        @Config.RequiresMcRestart
        @Config.Name(value="Generate Mystcraft libraries")
        public boolean librariesEnabled = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Upgrade Mystcraft libraries")
        public boolean librariesUpgraded = true;
        @Config.Name(value="Great Library generation percentage")
        @Config.RangeInt(min=0, max=100)
        public int greatLibrariesPercentage = 10;

        private CategoryLibraries() {
        }
    }

    private static class CategoryStudies {
        @Config.Name(value="Generate abandoned studies in overworld")
        public boolean abandonedStudiesOverworldEnabled = true;
        @Config.Name(value="Abandoned study generation frequency")
        @Config.Comment(value={"The frequency at which Abandoned Studies will spawn. The lower the number, the more frequent the spawns. 0 will spawn them in every valid location."})
        @Config.RangeInt(min=0)
        public int studyFrequency = 1000;
        @Config.Name(value="Abandoned study minimum y")
        @Config.Comment(value={"The lowest height at which the Abandoned Study will spawn. Decrease if you have dimensions with a low ground level; increase to incrrease performance."})
        @Config.RangeInt(min=0, max=255)
        public int studyMinimumY = 64;

        private CategoryStudies() {
        }
    }

    private static class CategoryAddedBlocks {
        @Config.RequiresMcRestart
        @Config.Name(value="Traffic cone enabled")
        public boolean trafficConeEnabled = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Traffic cone recipe enabled")
        public boolean trafficConeRecipeEnabled = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Nexus controller enabled")
        public boolean nexusControllerEnabled = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Nexus controller recipe enabled")
        public boolean nexusControllerRecipeEnabled = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Journey cloths/hubs enabled")
        public boolean journeysEnabled = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Journey cloths/hubs recipes enabled")
        public boolean journeyRecipesEnabled = true;

        private CategoryAddedBlocks() {
        }
    }

    private static class CategoryUnstable {
        @Config.RequiresMcRestart
        @Config.Name(value="Unstable receptacle enabled")
        public boolean unstableReceptacleEnabled = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Unstable receptacle recipe enabled")
        public boolean unstableReceptacleRecipeEnabled = false;
        @Config.Name(value="Unstable receptacle linking book attempts")
        @Config.Comment(value={"How many additional times the unstable receptacle should try to find ground to spawn on."})
        @Config.RangeInt(min=0)
        public int unstableLinkingAttempts = 1000;

        private CategoryUnstable() {
        }
    }

    private static class CategoryLocked {
        @Config.RequiresMcRestart
        @Config.Name(value="Locked lectern enabled")
        public boolean lockedLecternEnabled = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Locked bookstand enabled")
        public boolean lockedBookstandEnabled = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Locked lectern recipe enabled")
        public boolean lockedLecternRecipeEnabled = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Locked bookstand recipe enabled")
        public boolean lockedBookstandRecipeEnabled = true;

        private CategoryLocked() {
        }
    }
}

