/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.portal;

import com.xcompwiz.mystcraft.block.BlockCrystal;
import com.xcompwiz.mystcraft.data.ModBlocks;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thefloydman.moremystcraft.block.BlockUnstableBookReceptacle;
import thefloydman.moremystcraft.block.BlockUnstablePortal;
import thefloydman.moremystcraft.init.MoreMystcraftBlocks;

public final class MoreMystcraftPortalUtils {
    public static Block getPortalBlock() {
        return MoreMystcraftBlocks.UNSTABLE_PORTAL;
    }

    public static Block getFrameBlock() {
        return ModBlocks.crystal;
    }

    public static Block getReceptacleBlock() {
        return MoreMystcraftBlocks.UNSTABLE_RECEPTACLE;
    }

    public static int isValidLinkPortalBlock(IBlockState blockstate) {
        if (blockstate.func_177230_c().getClass().isInstance(MoreMystcraftPortalUtils.getFrameBlock())) {
            return 1;
        }
        if (blockstate.func_177230_c().getClass().isInstance(MoreMystcraftPortalUtils.getPortalBlock())) {
            return 1;
        }
        return 0;
    }

    private static EnumFacing getBlockFacing(IBlockState blockstate) {
        if (blockstate.func_177230_c() == MoreMystcraftPortalUtils.getFrameBlock()) {
            return (EnumFacing)blockstate.func_177229_b((IProperty)BlockCrystal.SOURCE_DIRECTION);
        }
        if (blockstate.func_177230_c() == MoreMystcraftPortalUtils.getPortalBlock()) {
            return (EnumFacing)blockstate.func_177229_b(BlockUnstablePortal.SOURCE_DIRECTION);
        }
        if (blockstate.func_177230_c() == MoreMystcraftPortalUtils.getReceptacleBlock()) {
            return (EnumFacing)blockstate.func_177229_b(BlockUnstableBookReceptacle.ROTATION);
        }
        return EnumFacing.DOWN;
    }

    private static boolean isBlockActive(IBlockState blockstate) {
        if (blockstate.func_177230_c() == MoreMystcraftPortalUtils.getFrameBlock()) {
            return (Boolean)blockstate.func_177229_b((IProperty)BlockCrystal.IS_PART_OF_PORTAL);
        }
        return blockstate.func_177230_c() == MoreMystcraftPortalUtils.getPortalBlock() && (Boolean)blockstate.func_177229_b((IProperty)BlockUnstablePortal.IS_PART_OF_PORTAL) != false;
    }

    private static IBlockState getDirectedState(IBlockState blockstate, int m) {
        if (blockstate.func_177230_c() == MoreMystcraftPortalUtils.getFrameBlock()) {
            return blockstate.func_177226_a((IProperty)BlockCrystal.IS_PART_OF_PORTAL, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockCrystal.SOURCE_DIRECTION, (Comparable)EnumFacing.values()[m]);
        }
        if (blockstate.func_177230_c() == MoreMystcraftPortalUtils.getPortalBlock()) {
            return blockstate.func_177226_a((IProperty)BlockUnstablePortal.IS_PART_OF_PORTAL, (Comparable)Boolean.valueOf(true)).func_177226_a(BlockUnstablePortal.SOURCE_DIRECTION, (Comparable)EnumFacing.values()[m]);
        }
        return blockstate;
    }

    private static IBlockState getDisabledState(IBlockState blockstate) {
        if (blockstate.func_177230_c() == MoreMystcraftPortalUtils.getFrameBlock()) {
            return blockstate.func_177226_a((IProperty)BlockCrystal.IS_PART_OF_PORTAL, (Comparable)Boolean.valueOf(false));
        }
        if (blockstate.func_177230_c() == MoreMystcraftPortalUtils.getPortalBlock()) {
            return blockstate.func_177226_a((IProperty)BlockUnstablePortal.IS_PART_OF_PORTAL, (Comparable)Boolean.valueOf(false));
        }
        return blockstate;
    }

    public static void validatePortal(World world, BlockPos start) {
        if (world.field_72995_K) {
            return;
        }
        LinkedList<BlockPos> blocks = new LinkedList<BlockPos>();
        blocks.add(start);
        while (blocks.size() > 0) {
            BlockPos coords = (BlockPos)blocks.remove(0);
            if (world.func_180495_p(coords).func_177230_c() != MoreMystcraftPortalUtils.getPortalBlock()) continue;
            MoreMystcraftPortalUtils.validatePortal(world, coords, blocks);
        }
    }

    public static void firePortal(World world, BlockPos pos) {
        BlockPos coord = MoreMystcraftPortalUtils.getReceptacleBase(pos, MoreMystcraftPortalUtils.getBlockFacing(world.func_180495_p(pos)));
        MoreMystcraftPortalUtils.onpulse(world, coord);
        MoreMystcraftPortalUtils.pathto(world, pos);
    }

    public static void shutdownPortal(World world, BlockPos pos) {
        MoreMystcraftPortalUtils.unpath(world, pos);
    }

    public static BlockPos getReceptacleBase(BlockPos pos, EnumFacing facing) {
        return pos.func_177972_a(facing.func_176734_d());
    }

    private static void pathto(World world, BlockPos pos) {
        BlockPos coords;
        LinkedList<BlockPos> blocks = new LinkedList<BlockPos>();
        LinkedList<BlockPos> portals = new LinkedList<BlockPos>();
        LinkedList<BlockPos> repath = new LinkedList<BlockPos>();
        LinkedList<BlockPos> redraw = new LinkedList<BlockPos>();
        blocks.add(pos);
        while (portals.size() > 0 || blocks.size() > 0) {
            while (blocks.size() > 0) {
                coords = (BlockPos)blocks.remove(0);
                MoreMystcraftPortalUtils.directPortal(world, coords.func_177974_f(), 5, blocks, portals);
                MoreMystcraftPortalUtils.directPortal(world, coords.func_177984_a(), 1, blocks, portals);
                MoreMystcraftPortalUtils.directPortal(world, coords.func_177968_d(), 3, blocks, portals);
                MoreMystcraftPortalUtils.directPortal(world, coords.func_177976_e(), 6, blocks, portals);
                MoreMystcraftPortalUtils.directPortal(world, coords.func_177977_b(), 2, blocks, portals);
                MoreMystcraftPortalUtils.directPortal(world, coords.func_177978_c(), 4, blocks, portals);
                redraw.add(coords);
            }
            if (portals.size() <= 0) continue;
            coords = (BlockPos)portals.remove(0);
            MoreMystcraftPortalUtils.directPortal(world, coords.func_177974_f(), 5, blocks, portals);
            MoreMystcraftPortalUtils.directPortal(world, coords.func_177984_a(), 1, blocks, portals);
            MoreMystcraftPortalUtils.directPortal(world, coords.func_177968_d(), 3, blocks, portals);
            MoreMystcraftPortalUtils.directPortal(world, coords.func_177976_e(), 6, blocks, portals);
            MoreMystcraftPortalUtils.directPortal(world, coords.func_177977_b(), 2, blocks, portals);
            MoreMystcraftPortalUtils.directPortal(world, coords.func_177978_c(), 4, blocks, portals);
            if (world.func_180495_p(coords).func_177230_c() != MoreMystcraftPortalUtils.getPortalBlock()) continue;
            repath.add(coords);
        }
        while (repath.size() > 0) {
            coords = (BlockPos)repath.remove(0);
            if (world.func_180495_p(coords).func_177230_c() != MoreMystcraftPortalUtils.getPortalBlock()) continue;
            if (!MoreMystcraftPortalUtils.isPortalBlockStable(world, coords)) {
                MoreMystcraftPortalUtils.repathNeighbors(world, coords);
                world.func_180501_a(coords, Blocks.field_150350_a.func_176223_P(), 0);
                MoreMystcraftPortalUtils.addSurrounding(repath, coords);
                continue;
            }
            redraw.add(coords);
        }
        for (BlockPos coords2 : redraw) {
            if (!world.func_190526_b(coords2.func_177958_n() >> 4, coords2.func_177952_p() >> 4)) continue;
            IBlockState blockState = world.func_180495_p(coords2);
            world.func_184138_a(coords2, blockState, blockState, 3);
        }
    }

    private static void repathNeighbors(World world, BlockPos pos) {
        TileEntity tileentity = MoreMystcraftPortalUtils.getTileEntity((IBlockAccess)world, pos);
        LinkedList<BlockPos> blocks = new LinkedList<BlockPos>();
        blocks.add(pos);
        world.func_180501_a(pos, MoreMystcraftPortalUtils.getDisabledState(world.func_180495_p(pos)), 2);
        while (blocks.size() > 0) {
            BlockPos coords = (BlockPos)blocks.remove(0);
            MoreMystcraftPortalUtils.redirectPortal(world, tileentity, coords.func_177974_f(), 5, blocks);
            MoreMystcraftPortalUtils.redirectPortal(world, tileentity, coords.func_177984_a(), 1, blocks);
            MoreMystcraftPortalUtils.redirectPortal(world, tileentity, coords.func_177968_d(), 3, blocks);
            MoreMystcraftPortalUtils.redirectPortal(world, tileentity, coords.func_177976_e(), 6, blocks);
            MoreMystcraftPortalUtils.redirectPortal(world, tileentity, coords.func_177977_b(), 2, blocks);
            MoreMystcraftPortalUtils.redirectPortal(world, tileentity, coords.func_177978_c(), 4, blocks);
        }
    }

    private static void redirectPortal(World world, TileEntity tileentity, BlockPos pos, int meta, List<BlockPos> blocks) {
        IBlockState blockstate = world.func_180495_p(pos);
        if (MoreMystcraftPortalUtils.isValidLinkPortalBlock(blockstate) == 0) {
            return;
        }
        if (MoreMystcraftPortalUtils.isBlockActive(blockstate) && MoreMystcraftPortalUtils.getBlockFacing(blockstate).ordinal() + 1 == meta) {
            for (int m = 1; m < 7; ++m) {
                if (m == meta) continue;
                world.func_180501_a(pos, MoreMystcraftPortalUtils.getDirectedState(blockstate, m - 1), 2);
                TileEntity local = MoreMystcraftPortalUtils.getTileEntity((IBlockAccess)world, pos);
                if (local != tileentity && (local == null || tileentity != null)) continue;
                return;
            }
            world.func_180501_a(pos, blockstate.func_177230_c().func_176223_P(), 2);
        }
    }

    private static void unpath(World world, BlockPos pos) {
        LinkedList<BlockPos> blocks = new LinkedList<BlockPos>();
        LinkedList<BlockPos> notify = new LinkedList<BlockPos>();
        blocks.add(pos);
        while (blocks.size() > 0) {
            BlockPos coords = (BlockPos)blocks.remove(0);
            MoreMystcraftPortalUtils.depolarize(world, coords.func_177974_f(), blocks);
            MoreMystcraftPortalUtils.depolarize(world, coords.func_177984_a(), blocks);
            MoreMystcraftPortalUtils.depolarize(world, coords.func_177968_d(), blocks);
            MoreMystcraftPortalUtils.depolarize(world, coords.func_177976_e(), blocks);
            MoreMystcraftPortalUtils.depolarize(world, coords.func_177977_b(), blocks);
            MoreMystcraftPortalUtils.depolarize(world, coords.func_177978_c(), blocks);
            notify.add(coords);
        }
        for (BlockPos coords2 : notify) {
            if (!world.func_190526_b(coords2.func_177958_n() >> 4, coords2.func_177952_p() >> 4)) continue;
            IBlockState blockState = world.func_180495_p(coords2);
            world.func_184138_a(coords2, blockState, blockState, 3);
        }
    }

    private static void onpulse(World world, BlockPos pos) {
        BlockPos coords;
        LinkedList<BlockPos> set = new LinkedList<BlockPos>();
        Stack<BlockPos> validate = new Stack<BlockPos>();
        MoreMystcraftPortalUtils.addSurrounding(set, pos);
        while (set.size() > 0) {
            coords = set.remove(0);
            MoreMystcraftPortalUtils.expandPortal(world, coords, set, validate);
        }
        while (validate.size() > 0) {
            coords = (BlockPos)validate.pop();
            if (MoreMystcraftPortalUtils.checkPortalTension(world, coords)) continue;
            world.func_180501_a(coords, Blocks.field_150350_a.func_176223_P(), 0);
        }
    }

    private static boolean isPortalBlockStable(World world, BlockPos pos) {
        return world.field_72995_K || MoreMystcraftPortalUtils.checkPortalTension(world, pos) && MoreMystcraftPortalUtils.getTileEntity((IBlockAccess)world, pos) != null;
    }

    private static boolean checkPortalTension(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return true;
        }
        int score = 0;
        if (MoreMystcraftPortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177974_f())) > 0 && MoreMystcraftPortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177976_e())) > 0) {
            ++score;
        }
        if (MoreMystcraftPortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177984_a())) > 0 && MoreMystcraftPortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177977_b())) > 0) {
            ++score;
        }
        if (MoreMystcraftPortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177968_d())) > 0 && MoreMystcraftPortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177978_c())) > 0) {
            ++score;
        }
        return score > 1;
    }

    private static void validatePortal(World world, BlockPos pos, Collection<BlockPos> blocks) {
        if (!MoreMystcraftPortalUtils.isPortalBlockStable(world, pos)) {
            world.func_175698_g(pos);
            MoreMystcraftPortalUtils.addSurrounding(blocks, pos);
        }
    }

    private static void addSurrounding(Collection<BlockPos> set, BlockPos pos) {
        set.add(new BlockPos((Vec3i)pos.func_177974_f()));
        set.add(new BlockPos((Vec3i)pos.func_177976_e()));
        set.add(new BlockPos((Vec3i)pos.func_177984_a()));
        set.add(new BlockPos((Vec3i)pos.func_177977_b()));
        set.add(new BlockPos((Vec3i)pos.func_177968_d()));
        set.add(new BlockPos((Vec3i)pos.func_177978_c()));
        set.add(new BlockPos((Vec3i)pos.func_177974_f().func_177984_a()));
        set.add(new BlockPos((Vec3i)pos.func_177976_e().func_177984_a()));
        set.add(new BlockPos((Vec3i)pos.func_177974_f().func_177977_b()));
        set.add(new BlockPos((Vec3i)pos.func_177976_e().func_177977_b()));
        set.add(new BlockPos((Vec3i)pos.func_177968_d().func_177984_a()));
        set.add(new BlockPos((Vec3i)pos.func_177978_c().func_177984_a()));
        set.add(new BlockPos((Vec3i)pos.func_177968_d().func_177977_b()));
        set.add(new BlockPos((Vec3i)pos.func_177978_c().func_177977_b()));
        set.add(new BlockPos((Vec3i)pos.func_177974_f().func_177968_d()));
        set.add(new BlockPos((Vec3i)pos.func_177976_e().func_177968_d()));
        set.add(new BlockPos((Vec3i)pos.func_177974_f().func_177978_c()));
        set.add(new BlockPos((Vec3i)pos.func_177976_e().func_177978_c()));
    }

    private static void expandPortal(World world, BlockPos pos, Collection<BlockPos> set, Stack<BlockPos> created) {
        if (!world.func_175623_d(pos)) {
            return;
        }
        int score = MoreMystcraftPortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177974_f())) + MoreMystcraftPortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177976_e())) + MoreMystcraftPortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177984_a())) + MoreMystcraftPortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177977_b())) + MoreMystcraftPortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177968_d())) + MoreMystcraftPortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177978_c()));
        if (score > 1) {
            world.func_180501_a(pos, MoreMystcraftPortalUtils.getPortalBlock().func_176223_P(), 0);
            created.push(pos);
            MoreMystcraftPortalUtils.addSurrounding(set, pos);
        }
    }

    private static void directPortal(World world, BlockPos pos, int meta, List<BlockPos> blocks, List<BlockPos> portals) {
        IBlockState blockState = world.func_180495_p(pos);
        if (MoreMystcraftPortalUtils.isValidLinkPortalBlock(blockState) == 0) {
            return;
        }
        if (MoreMystcraftPortalUtils.isBlockActive(blockState)) {
            return;
        }
        world.func_180501_a(pos, MoreMystcraftPortalUtils.getDirectedState(blockState, meta - 1), 0);
        if (blockState.func_177230_c() == MoreMystcraftPortalUtils.getPortalBlock()) {
            portals.add(pos);
        } else {
            blocks.add(pos);
        }
    }

    private static void depolarize(World world, BlockPos pos, List<BlockPos> blocks) {
        IBlockState blockstate = world.func_180495_p(pos);
        if (MoreMystcraftPortalUtils.isValidLinkPortalBlock(blockstate) == 0) {
            return;
        }
        if (!MoreMystcraftPortalUtils.isBlockActive(blockstate)) {
            return;
        }
        world.func_180501_a(pos, blockstate.func_177230_c().func_176223_P(), 0);
        if (blockstate.func_177230_c() == MoreMystcraftPortalUtils.getPortalBlock() && !MoreMystcraftPortalUtils.isPortalBlockStable(world, pos)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        }
        blocks.add(pos);
    }

    public static TileEntity getTileEntity(IBlockAccess blockaccess, BlockPos pos) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        IBlockState blockstate = blockaccess.func_180495_p(pos);
        while (blockstate.func_177230_c() != MoreMystcraftPortalUtils.getReceptacleBlock()) {
            if (MoreMystcraftPortalUtils.isValidLinkPortalBlock(blockstate) == 0) {
                return null;
            }
            if (!MoreMystcraftPortalUtils.isBlockActive(blockstate)) {
                return null;
            }
            if (!visited.add(pos)) {
                return null;
            }
            pos = pos.func_177972_a(MoreMystcraftPortalUtils.getBlockFacing(blockstate));
            blockstate = blockaccess.func_180495_p(pos);
        }
        return blockaccess.func_175625_s(pos);
    }
}

