/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.IBiomeController;
import com.xcompwiz.mystcraft.symbol.modifiers.SymbolBiome;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import thefloydman.moremystcraft.symbol.MoreMystcraftSymbolBase;

public class SymbolBiomeControllerHorizontalBands
extends MoreMystcraftSymbolBase {
    public SymbolBiomeControllerHorizontalBands(ResourceLocation identifier) {
        super(identifier);
    }

    public void registerLogic(AgeDirector controller, long seed) {
        Number size = controller.popModifier("size").asNumber();
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        Biome biome = ModifierUtils.popBiome((AgeDirector)controller);
        while (biome != null) {
            biomes.add(biome);
            biome = ModifierUtils.popBiome((AgeDirector)controller);
        }
        Random rand = new Random(controller.getSeed());
        while (biomes.size() < 2) {
            biomes.add(SymbolBiome.getRandomBiome((Random)rand));
        }
        controller.registerInterface((IBiomeController)new BiomeController(biomes, size));
    }

    public boolean generatesConfigOption() {
        return true;
    }

    private class BiomeController
    implements IBiomeController {
        private List<Biome> biomes;
        private double size;

        public BiomeController(List<Biome> biomes, Number size) {
            this.biomes = biomes;
            this.size = size != null ? size.doubleValue() * 200.0 : 50.0;
        }

        public List<Biome> getValidSpawnBiomes() {
            return this.biomes;
        }

        public Biome getBiomeAtCoords(int i, int j) {
            int bandNumber;
            double verticalDistance = Math.abs(j);
            for (bandNumber = (int)(verticalDistance / this.size); bandNumber >= this.biomes.size(); bandNumber -= this.biomes.size()) {
            }
            return this.biomes.get(bandNumber);
        }

        public Biome[] getBiomesForGeneration(Biome[] aBiome, int x, int z, int xSize, int zSize) {
            if (aBiome == null || aBiome.length < xSize * zSize) {
                aBiome = new Biome[xSize * zSize];
            }
            for (int i = 0; i < xSize * zSize; ++i) {
                aBiome[i] = this.getBiomeAtCoords((x + i % xSize) * 4, (z + i / xSize) * 4);
            }
            return aBiome;
        }

        public Biome[] getBiomesAtCoords(Biome[] aBiome, int x, int z, int xSize, int zSize, boolean flag) {
            if (aBiome == null || aBiome.length < xSize * zSize) {
                aBiome = new Biome[xSize * zSize];
            }
            if (flag && xSize == 16 && zSize == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
                return this.createBiomeArray(aBiome, x, z, xSize, zSize);
            }
            for (int i = 0; i < xSize * zSize; ++i) {
                aBiome[i] = this.getBiomeAtCoords(x + i % xSize, z + i / xSize);
            }
            return aBiome;
        }

        private Biome[] createBiomeArray(Biome[] aBiome, int i, int j, int k, int l) {
            if (aBiome == null || aBiome.length < k * l) {
                aBiome = new Biome[k * l];
            }
            for (int i2 = 0; i2 < k * l; ++i2) {
                aBiome[i2] = this.getBiomeAtCoords(i + i2 % k, j + i2 / k);
            }
            return aBiome;
        }

        public void cleanupCache() {
        }
    }
}

