/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.IBiomeController;
import com.xcompwiz.mystcraft.symbol.modifiers.SymbolBiome;
import com.xcompwiz.mystcraft.world.gen.layer.GenLayerBiomeMyst;
import com.xcompwiz.mystcraft.world.gen.layer.GenLayerZoomMyst;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerFuzzyZoom;
import net.minecraft.world.gen.layer.GenLayerIsland;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.IntCache;
import thefloydman.moremystcraft.symbol.MoreMystcraftSymbolBase;

public class SymbolBiomeControllerNormal
extends MoreMystcraftSymbolBase {
    public SymbolBiomeControllerNormal(ResourceLocation identifier) {
        super(identifier);
    }

    public void registerLogic(AgeDirector controller, long seed) {
        Number size = controller.popModifier("size").asNumber();
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        Biome biome = ModifierUtils.popBiome((AgeDirector)controller);
        while (biome != null) {
            biomes.add(biome);
            biome = ModifierUtils.popBiome((AgeDirector)controller);
        }
        if (size != null) {
            if (size.doubleValue() <= 0.375) {
                controller.registerInterface((IBiomeController)new BiomeController(controller, 0, biomes));
            } else if (size.doubleValue() > 0.375 && size.doubleValue() <= 0.75) {
                controller.registerInterface((IBiomeController)new BiomeController(controller, 1, biomes));
            } else if (size.doubleValue() > 0.75 && size.doubleValue() <= 1.5) {
                controller.registerInterface((IBiomeController)new BiomeController(controller, 2, biomes));
            } else if (size.doubleValue() > 1.5 && size.doubleValue() <= 2.5) {
                controller.registerInterface((IBiomeController)new BiomeController(controller, 3, biomes));
            } else if (size.doubleValue() > 2.5) {
                controller.registerInterface((IBiomeController)new BiomeController(controller, 4, biomes));
            }
        } else {
            controller.registerInterface((IBiomeController)new BiomeController(controller, 2, biomes));
        }
    }

    public boolean generatesConfigOption() {
        return true;
    }

    static class BiomeController
    implements IBiomeController {
        private Biome[] allowedBiomes;
        private List<Biome> biomesToSpawnIn;
        private GenLayer genBiomes;
        private GenLayer biomeIndexLayer;
        private BiomeCache biomeCache;
        private int zoomscale;

        protected BiomeController(AgeDirector controller, int zoom, List<Biome> biomes) {
            this.zoomscale = zoom;
            this.biomeCache = new BiomeCache(controller.getBiomeProvider());
            this.biomesToSpawnIn = new ArrayList<Biome>();
            this.biomesToSpawnIn.add(Biomes.field_76767_f);
            this.biomesToSpawnIn.add(Biomes.field_76772_c);
            this.biomesToSpawnIn.add(Biomes.field_76768_g);
            this.biomesToSpawnIn.add(Biomes.field_76784_u);
            this.biomesToSpawnIn.add(Biomes.field_76785_t);
            this.biomesToSpawnIn.add(Biomes.field_76782_w);
            this.biomesToSpawnIn.add(Biomes.field_76792_x);
            Random rand = new Random(controller.getSeed());
            while (biomes.size() < 3) {
                biomes.add(SymbolBiome.getRandomBiome((Random)rand));
            }
            this.allowedBiomes = new Biome[biomes.size()];
            this.allowedBiomes = biomes.toArray(this.allowedBiomes);
            GenLayer[] agenlayer = this.computeGenLayers(controller.getSeed(), WorldType.field_77137_b);
            this.genBiomes = agenlayer[0];
            this.biomeIndexLayer = agenlayer[1];
        }

        public List<Biome> getValidSpawnBiomes() {
            return this.biomesToSpawnIn;
        }

        public Biome getBiomeAtCoords(int par1, int par2) {
            return this.biomeCache.func_180284_a(par1, par2, (Biome)null);
        }

        public Biome[] getBiomesForGeneration(Biome[] par1ArrayOfBiome, int par2, int par3, int par4, int par5) {
            IntCache.func_76446_a();
            if (par1ArrayOfBiome == null || par1ArrayOfBiome.length < par4 * par5) {
                par1ArrayOfBiome = new Biome[par4 * par5];
            }
            int[] ai = this.genBiomes.func_75904_a(par2, par3, par4, par5);
            for (int i = 0; i < par4 * par5; ++i) {
                par1ArrayOfBiome[i] = Biome.func_150568_d((int)ai[i]);
            }
            return par1ArrayOfBiome;
        }

        public Biome[] getBiomesAtCoords(Biome[] par1ArrayOfBiome, int par2, int par3, int par4, int par5, boolean par6) {
            IntCache.func_76446_a();
            if (par1ArrayOfBiome == null || par1ArrayOfBiome.length < par4 * par5) {
                par1ArrayOfBiome = new Biome[par4 * par5];
            }
            if (par6 && par4 == 16 && par5 == 16 && (par2 & 0xF) == 0 && (par3 & 0xF) == 0) {
                Biome[] aBiome = this.biomeCache.func_76839_e(par2, par3);
                System.arraycopy(aBiome, 0, par1ArrayOfBiome, 0, par4 * par5);
                return par1ArrayOfBiome;
            }
            int[] ai = this.biomeIndexLayer.func_75904_a(par2, par3, par4, par5);
            for (int i = 0; i < par4 * par5; ++i) {
                par1ArrayOfBiome[i] = Biome.func_150568_d((int)ai[i]);
            }
            return par1ArrayOfBiome;
        }

        public void cleanupCache() {
            this.biomeCache.func_76838_a();
        }

        private GenLayer[] computeGenLayers(long par0, WorldType par2WorldType) {
            GenLayerIsland obj = new GenLayerIsland(1L);
            GenLayerFuzzyZoom obj2 = new GenLayerFuzzyZoom(2000L, (GenLayer)obj);
            obj = obj2;
            obj2 = GenLayerZoomMyst.magnify((long)1000L, (GenLayer)obj2, (int)0);
            obj2 = GenLayerZoomMyst.magnify((long)1000L, (GenLayer)obj2, (int)(this.zoomscale + 1));
            obj2 = new GenLayerSmooth(1000L, (GenLayer)obj2);
            GenLayerIsland obj3 = obj;
            obj3 = GenLayerZoomMyst.magnify((long)1000L, (GenLayer)obj3, (int)0);
            obj3 = new GenLayerBiomeMyst(200L, (GenLayer)obj3, par2WorldType, this.allowedBiomes);
            obj3 = GenLayerZoomMyst.magnify((long)1000L, (GenLayer)obj3, (int)2);
            for (int i = 0; i < this.zoomscale; ++i) {
                obj3 = new GenLayerZoomMyst((long)(1000 + i), (GenLayer)obj3);
            }
            obj3 = new GenLayerSmooth(1000L, (GenLayer)obj3);
            GenLayerVoronoiZoom genlayervoronoizoom = new GenLayerVoronoiZoom(10L, (GenLayer)obj3);
            obj3.func_75905_a(par0);
            genlayervoronoizoom.func_75905_a(par0);
            return new GenLayer[]{obj3, genlayervoronoizoom};
        }
    }
}

