/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.tileentity;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.api.item.IItemWritable;
import com.xcompwiz.mystcraft.data.ModAchievements;
import com.xcompwiz.mystcraft.item.ItemPage;
import com.xcompwiz.mystcraft.tileentity.FluidTankFiltered;
import com.xcompwiz.mystcraft.tileentity.IOInventory;
import com.xcompwiz.mystcraft.tileentity.InventoryFilter;
import com.xcompwiz.mystcraft.tileentity.TileEntityBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntitySymbolRecordingDesk
extends TileEntityBase
implements InventoryFilter {
    private IOInventory inventoryStacks = this.buildWorkInventory();
    private FluidTankFiltered inkwell = new FluidTankFiltered(800);
    private static final int SLOT_PAPER = 0;
    private static final int SLOT_SYMBOL = 1;

    public TileEntitySymbolRecordingDesk() {
        this.inkwell.setPermittedFluids(Mystcraft.validInks);
    }

    public void writeSymbol(EntityPlayer player, ResourceLocation symbol) {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (!this.hasEnoughInk()) {
            return;
        }
        if (this.inventoryStacks.getStackInSlot(1).func_190926_b() && !this.inventoryStacks.getStackInSlot(0).func_190926_b()) {
            this.inventoryStacks.setStackInSlot(1, ItemPage.createItemstack((ItemStack)this.inventoryStacks.getStackInSlot(0)));
            if (this.inventoryStacks.getStackInSlot(0).func_190916_E() <= 0) {
                this.inventoryStacks.setStackInSlot(0, ItemStack.field_190927_a);
            }
        }
        if (this.inventoryStacks.getStackInSlot(1).func_190926_b()) {
            return;
        }
        ItemStack target = this.inventoryStacks.getStackInSlot(1);
        if (target.func_190926_b()) {
            return;
        }
        if (target.func_77973_b() instanceof IItemWritable && ((IItemWritable)target.func_77973_b()).writeSymbol(player, target, symbol)) {
            this.useink();
            if (player instanceof EntityPlayerMP) {
                ModAchievements.TRIGGER_WRITE.trigger((EntityPlayerMP)player);
            }
            return;
        }
    }

    private boolean hasEnoughInk() {
        FluidStack fluid = this.inkwell.getFluid();
        return fluid != null && fluid.amount >= Mystcraft.inkcost;
    }

    public boolean canAcceptItem(int arg0, ItemStack arg1) {
        return false;
    }

    protected IOInventory buildWorkInventory() {
        return new IOInventory((TileEntityBase)this, new int[]{0}, new int[0], EnumFacing.field_82609_l).setMiscSlots(new int[]{1}).setListener(() -> this.onChange(true)).applyFilter((InventoryFilter)this, new int[]{0});
    }

    private void useink() {
        this.inkwell.drain(Mystcraft.inkcost, true);
    }

    public void onChange(boolean isWorkInv) {
        if (isWorkInv) {
            for (int i = 0; i < this.inventoryStacks.getSlots(); ++i) {
                this.handleItemChange(this.inventoryStacks.getStackInSlot(i));
            }
        }
    }

    public void handleItemChange(@Nonnull ItemStack itemstack) {
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventoryStacks.getCapability(facing);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.inkwell;
        }
        return null;
    }
}

