/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.http;

import io.javalin.config.ContextResolverConfig;
import io.javalin.config.Key;
import io.javalin.http.BadRequestResponse;
import io.javalin.http.ContentType;
import io.javalin.http.Cookie;
import io.javalin.http.CookieKt;
import io.javalin.http.HandlerType;
import io.javalin.http.HttpStatus;
import io.javalin.http.UploadedFile;
import io.javalin.http.servlet.JavalinServletContextKt;
import io.javalin.http.servlet.MaxRequestSize;
import io.javalin.http.util.AsyncExecutor;
import io.javalin.http.util.AsyncTaskConfig;
import io.javalin.http.util.CookieStore;
import io.javalin.http.util.MultipartUtil;
import io.javalin.http.util.SeekableWriter;
import io.javalin.json.JsonMapper;
import io.javalin.plugin.ContextPlugin;
import io.javalin.rendering.FileRenderer;
import io.javalin.security.BasicAuthCredentials;
import io.javalin.security.RouteRole;
import io.javalin.util.function.ThrowingRunnable;
import io.javalin.validation.BodyValidator;
import io.javalin.validation.Validation;
import io.javalin.validation.Validator;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\bf\u0018\u00002\u00020\u0001J!\u0010\u0002\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0005H&\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\b\u0012\u00060\u000bj\u0002`\f0\nH\u0016J(\u0010\u0007\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0010\u0010\t\u001a\f\u0012\b\u0012\u00060\u000bj\u0002`\f0\nH\u0016J\u001d\u0010\u0010\u001a\u0004\u0018\u0001H\u0003\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u0004\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001a\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0016J\u0016\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0015H\u0016J1\u0010\u0016\u001a\u0004\u0018\u0001H\u0003\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u0004\u001a\u00020\u00112\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H\u00030\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0011H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J!\u0010\u001f\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u00032\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00030!H\u0016\u00a2\u0006\u0002\u0010\"J\u001b\u0010\u001f\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u00032\u0006\u0010#\u001a\u00020$H\u0016\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020'H\u0016J\u001b\u0010(\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u00032\u0006\u0010#\u001a\u00020$H\u0016\u00a2\u0006\u0002\u0010%J\"\u0010)\u001a\b\u0012\u0004\u0012\u0002H\u00030*\"\u0004\b\u0000\u0010\u00032\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00030!H\u0016J\u001d\u0010+\u001a\u0004\u0018\u0001H\u0003\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u0004\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001a\u0010+\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0016J1\u0010,\u001a\u0004\u0018\u0001H\u0003\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u0004\u001a\u00020\u00112\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H\u00030\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\n\u0010-\u001a\u0004\u0018\u00010\u0011H\u0016J\u001d\u0010.\u001a\u0004\u0018\u0001H\u0003\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u0004\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010/\u001a\u000200H\u0016J\n\u00101\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u00101\u001a\u00020\u00002\u0006\u00101\u001a\u000202H\u0016J\u0010\u00101\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0011H\u0016J\b\u00103\u001a\u00020\u0011H\u0016J\u0010\u00104\u001a\u00020\u00002\u0006\u00104\u001a\u000205H\u0016J\u0012\u00104\u001a\u0004\u0018\u00010\u00112\u0006\u00106\u001a\u00020\u0011H\u0016J\u0018\u00104\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J \u00104\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u00107\u001a\u000200H\u0016J\u0014\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0015H\u0016J\b\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020\u0011H&J\u0012\u0010<\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0004\u001a\u00020\u0011H\u0016J*\u0010=\u001a\b\u0012\u0004\u0012\u0002H\u00030>\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u0004\u001a\u00020\u00112\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00030!H\u0016J\u001a\u0010?\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110@0\u0015H\u0016J\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00110@2\u0006\u0010\u0004\u001a\u00020\u0011H\u0016J\b\u0010B\u001a\u00020\u0011H\u0016J\u001c\u0010C\u001a\u00020\b2\u0012\u0010C\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030E0DH&J\b\u0010F\u001a\u00020GH&J\u0012\u0010H\u001a\u0004\u0018\u00010\u00112\u0006\u0010H\u001a\u00020\u0011H\u0016J\u0018\u0010H\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J*\u0010I\u001a\b\u0012\u0004\u0012\u0002H\u00030>\"\u0004\b\u0000\u0010\u00032\u0006\u0010H\u001a\u00020\u00112\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00030!H\u0016J\u0014\u0010J\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0015H\u0016J\n\u0010K\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010L\u001a\u00020\u00002\u0006\u0010L\u001a\u00020\u0011H\u0016J\b\u0010M\u001a\u00020\u0011H\u0016J\b\u0010N\u001a\u00020OH\u0016J\b\u0010P\u001a\u00020OH\u0016J\b\u0010Q\u001a\u00020OH\u0016J\b\u0010R\u001a\u00020OH\u0016J\u0010\u0010S\u001a\u00020\u00002\u0006\u0010T\u001a\u00020\u0001H\u0016J\u0018\u0010S\u001a\u00020\u00002\u0006\u0010T\u001a\u00020\u00012\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010U\u001a\u00020VH&J\u0010\u0010W\u001a\u00020\u00002\u0006\u0010T\u001a\u00020\u0001H\u0016J\u0018\u0010W\u001a\u00020\u00002\u0006\u0010T\u001a\u00020\u00012\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010X\u001a\u00020\u0011H&J\b\u0010Y\u001a\u00020GH\u0016J\u0010\u0010Z\u001a\u00020\u00002\u0006\u0010Z\u001a\u000200H&J\b\u0010[\u001a\u00020\\H&J\b\u0010]\u001a\u00020\u0011H\u0016J\u0010\u0010^\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0011H&J*\u0010_\u001a\b\u0012\u0004\u0012\u0002H\u00030>\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u0004\u001a\u00020\u00112\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00030!H\u0016J\u0014\u0010`\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0015H&J\b\u0010a\u001a\u000200H\u0016J\b\u0010b\u001a\u00020\u0011H\u0016J\u0012\u0010c\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0004\u001a\u00020\u0011H\u0016J*\u0010d\u001a\b\u0012\u0004\u0012\u0002H\u00030>\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u0004\u001a\u00020\u00112\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00030!H\u0016J\u001a\u0010e\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110@0\u0015H\u0016J\u0016\u0010f\u001a\b\u0012\u0004\u0012\u00020\u00110@2\u0006\u0010\u0004\u001a\u00020\u0011H\u0016J\n\u0010g\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010h\u001a\u00020\b2\u0006\u0010i\u001a\u00020\u0011H\u0016J\u0018\u0010h\u001a\u00020\b2\u0006\u0010i\u001a\u00020\u00112\u0006\u0010j\u001a\u00020kH&J\u0010\u0010l\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0011H\u0016J\u001a\u0010l\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u00112\b\u0010]\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010m\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0011H\u0016J\u0010\u0010n\u001a\u00020\u00002\u0006\u0010o\u001a\u00020\u0011H\u0016J&\u0010n\u001a\u00020\u00002\u0006\u0010o\u001a\u00020\u00112\u0014\u0010p\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0015H\u0016J\b\u0010q\u001a\u00020rH&J\b\u0010s\u001a\u00020tH&J\b\u0010u\u001a\u00020vH\u0016J\n\u0010w\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010w\u001a\u00020\u00002\u0006\u0010x\u001a\u00020'H&J\u0010\u0010w\u001a\u00020\u00002\u0006\u0010y\u001a\u00020\u001eH\u0016J\u0010\u0010w\u001a\u00020\u00002\u0006\u0010z\u001a\u00020\u0011H\u0016J\n\u0010{\u001a\u0004\u0018\u00010'H&J\u000e\u0010|\u001a\b\u0012\u0004\u0012\u00020~0}H&J\b\u0010\u007f\u001a\u00020\u0011H\u0016J\u001e\u0010\u0080\u0001\u001a\u0004\u0018\u0001H\u0003\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u0004\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001b\u0010\u0080\u0001\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0016J\u0017\u0010\u0081\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0015H\u0016J\t\u0010\u0082\u0001\u001a\u00020\u0000H&J\b\u0010j\u001a\u00020kH\u0016J\u0010\u0010j\u001a\u00020\u00002\u0006\u0010j\u001a\u00020kH\u0016J\u0010\u0010j\u001a\u00020\u00002\u0006\u0010j\u001a\u000200H\u0016J\t\u0010\u0083\u0001\u001a\u000200H\u0016J\t\u0010\u0084\u0001\u001a\u00020OH&J\u0015\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u00012\u0007\u0010\u0087\u0001\u001a\u00020\u0011H\u0016J\u001c\u0010\u0088\u0001\u001a\u0015\u0012\u0004\u0012\u00020\u0011\u0012\u000b\u0012\t\u0012\u0005\u0012\u00030\u0086\u00010@0\u0015H\u0016J\u0010\u0010\u0089\u0001\u001a\t\u0012\u0005\u0012\u00030\u0086\u00010@H\u0016J\u0019\u0010\u0089\u0001\u001a\t\u0012\u0005\u0012\u00030\u0086\u00010@2\u0007\u0010\u0087\u0001\u001a\u00020\u0011H\u0016J\t\u0010\u008a\u0001\u001a\u00020\u0011H\u0016J\u000b\u0010\u008b\u0001\u001a\u0004\u0018\u00010\u0011H\u0016J/\u0010\u008c\u0001\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u00032\u0019\u0010 \u001a\u0015\u0012\u0011\b\u0001\u0012\r\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u00030\u008d\u00010!H&\u00a2\u0006\u0002\u0010\"J1\u0010\u008c\u0001\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u00032\u001a\u0010 \u001a\u0016\u0012\u0011\b\u0001\u0012\r\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u00030\u008d\u00010\u008e\u0001H\u0016\u00a2\u0006\u0003\u0010\u008f\u0001J\u0017\u0010\u0090\u0001\u001a\u00020\b2\f\u0010\u0091\u0001\u001a\u0007\u0012\u0002\b\u00030\u0092\u0001H&J\u001a\u0010\u0093\u0001\u001a\u00020\b2\u0007\u0010\u0094\u0001\u001a\u00020'2\u0006\u00101\u001a\u00020\u0011H\u0016J$\u0010\u0093\u0001\u001a\u00020\b2\u0007\u0010\u0094\u0001\u001a\u00020'2\u0006\u00101\u001a\u00020\u00112\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0097\u0001\u00c0\u0006\u0001"}, d2={"Lio/javalin/http/Context;", "", "appData", "T", "key", "Lio/javalin/config/Key;", "(Lio/javalin/config/Key;)Ljava/lang/Object;", "async", "", "task", "Lio/javalin/util/function/ThrowingRunnable;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "config", "Ljava/util/function/Consumer;", "Lio/javalin/http/util/AsyncTaskConfig;", "attribute", "", "(Ljava/lang/String;)Ljava/lang/Object;", "value", "attributeMap", "", "attributeOrCompute", "callback", "Lkotlin/Function1;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "basicAuthCredentials", "Lio/javalin/security/BasicAuthCredentials;", "body", "bodyAsBytes", "", "bodyAsClass", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "type", "Ljava/lang/reflect/Type;", "(Ljava/lang/reflect/Type;)Ljava/lang/Object;", "bodyInputStream", "Ljava/io/InputStream;", "bodyStreamAsClass", "bodyValidator", "Lio/javalin/validation/BodyValidator;", "cachedSessionAttribute", "cachedSessionAttributeOrCompute", "characterEncoding", "consumeSessionAttribute", "contentLength", "", "contentType", "Lio/javalin/http/ContentType;", "contextPath", "cookie", "Lio/javalin/http/Cookie;", "name", "maxAge", "cookieMap", "cookieStore", "Lio/javalin/http/util/CookieStore;", "endpointHandlerPath", "formParam", "formParamAsClass", "Lio/javalin/validation/Validator;", "formParamMap", "", "formParams", "fullUrl", "future", "Ljava/util/function/Supplier;", "Ljava/util/concurrent/CompletableFuture;", "handlerType", "Lio/javalin/http/HandlerType;", "header", "headerAsClass", "headerMap", "host", "html", "ip", "isFormUrlencoded", "", "isJson", "isMultipart", "isMultipartFormData", "json", "obj", "jsonMapper", "Lio/javalin/json/JsonMapper;", "jsonStream", "matchedPath", "method", "minSizeForCompression", "outputStream", "Ljakarta/servlet/ServletOutputStream;", "path", "pathParam", "pathParamAsClass", "pathParamMap", "port", "protocol", "queryParam", "queryParamAsClass", "queryParamMap", "queryParams", "queryString", "redirect", "location", "status", "Lio/javalin/http/HttpStatus;", "removeCookie", "removeHeader", "render", "filePath", "model", "req", "Ljakarta/servlet/http/HttpServletRequest;", "res", "Ljakarta/servlet/http/HttpServletResponse;", "responseCharset", "Ljava/nio/charset/Charset;", "result", "resultStream", "resultBytes", "resultString", "resultInputStream", "routeRoles", "", "Lio/javalin/security/RouteRole;", "scheme", "sessionAttribute", "sessionAttributeMap", "skipRemainingHandlers", "statusCode", "strictContentTypes", "uploadedFile", "Lio/javalin/http/UploadedFile;", "fileName", "uploadedFileMap", "uploadedFiles", "url", "userAgent", "with", "Lio/javalin/plugin/ContextPlugin;", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)Ljava/lang/Object;", "writeJsonStream", "stream", "Ljava/util/stream/Stream;", "writeSeekableStream", "inputStream", "totalBytes", "", "javalin"})
@SourceDebugExtension(value={"SMAP\nContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Context.kt\nio/javalin/http/Context\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,532:1\n1#2:533\n759#3,2:534\n775#3,4:536\n759#3,2:540\n775#3,4:542\n759#3,2:552\n775#3,4:554\n8406#4,2:546\n9088#4,4:548\n*S KotlinDebug\n*F\n+ 1 Context.kt\nio/javalin/http/Context\n*L\n240#1:534,2\n240#1:536,4\n253#1:540,2\n253#1:542,4\n271#1:552,2\n271#1:554,4\n262#1:546,2\n262#1:548,4\n*E\n"})
public interface Context {
    @NotNull
    public HttpServletRequest req();

    @NotNull
    public HttpServletResponse res();

    @NotNull
    public HandlerType handlerType();

    @NotNull
    public String matchedPath();

    @NotNull
    public String endpointHandlerPath();

    public <T> T appData(@NotNull Key<T> var1);

    @NotNull
    public JsonMapper jsonMapper();

    public <T> T with(@NotNull Class<? extends ContextPlugin<?, T>> var1);

    default public <T> T with(@NotNull KClass<? extends ContextPlugin<?, T>> clazz) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        return this.with(JvmClassMappingKt.getJavaClass(clazz));
    }

    default public int contentLength() {
        return this.req().getContentLength();
    }

    @Nullable
    default public String contentType() {
        return this.req().getContentType();
    }

    @NotNull
    default public HandlerType method() {
        String string = this.header("X-HTTP-Method-Override");
        if (string == null) {
            string = this.req().getMethod();
        }
        String string2 = string;
        Intrinsics.checkNotNull(string2);
        return HandlerType.Companion.findByName(string2);
    }

    @NotNull
    default public String path() {
        String string = this.req().getRequestURI();
        Intrinsics.checkNotNullExpressionValue(string, "getRequestURI(...)");
        return string;
    }

    default public int port() {
        return this.req().getServerPort();
    }

    @NotNull
    default public String protocol() {
        String string = this.req().getProtocol();
        Intrinsics.checkNotNullExpressionValue(string, "getProtocol(...)");
        return string;
    }

    @NotNull
    default public String contextPath() {
        String string = this.req().getContextPath();
        Intrinsics.checkNotNullExpressionValue(string, "getContextPath(...)");
        return string;
    }

    @Nullable
    default public String userAgent() {
        return this.req().getHeader("User-Agent");
    }

    @Nullable
    default public String characterEncoding() {
        return JavalinServletContextKt.getRequestCharset(this);
    }

    @NotNull
    default public String url() {
        return this.appData(ContextResolverConfig.Companion.getContextResolverKey$javalin()).url.invoke(this);
    }

    @NotNull
    default public String fullUrl() {
        return this.appData(ContextResolverConfig.Companion.getContextResolverKey$javalin()).fullUrl.invoke(this);
    }

    @NotNull
    default public String scheme() {
        return this.appData(ContextResolverConfig.Companion.getContextResolverKey$javalin()).scheme.invoke(this);
    }

    @Nullable
    default public String host() {
        return this.appData(ContextResolverConfig.Companion.getContextResolverKey$javalin()).host.invoke(this);
    }

    @NotNull
    default public String ip() {
        return this.appData(ContextResolverConfig.Companion.getContextResolverKey$javalin()).ip.invoke(this);
    }

    @NotNull
    default public String body() {
        byte[] byArray = this.bodyAsBytes();
        String string = this.characterEncoding();
        if (string == null) {
            string = "UTF-8";
        }
        Charset charset = Charset.forName(string);
        Intrinsics.checkNotNullExpressionValue(charset, "forName(...)");
        Charset charset2 = charset;
        return new String(byArray, charset2);
    }

    @NotNull
    default public byte[] bodyAsBytes() {
        MaxRequestSize.INSTANCE.throwContentTooLargeIfContentTooLarge(this);
        ServletInputStream servletInputStream = this.req().getInputStream();
        Intrinsics.checkNotNullExpressionValue(servletInputStream, "getInputStream(...)");
        return ByteStreamsKt.readBytes(servletInputStream);
    }

    default public <T> T bodyAsClass(@NotNull Type type) {
        Intrinsics.checkNotNullParameter(type, "type");
        if (!this.isJson() && this.strictContentTypes()) {
            throw new BadRequestResponse("Content-Type is not application/json", null, 2, null);
        }
        return this.jsonMapper().fromJsonString(this.body(), type);
    }

    default public <T> T bodyAsClass(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        return this.bodyAsClass((Type)clazz);
    }

    default public <T> T bodyStreamAsClass(@NotNull Type type) {
        Intrinsics.checkNotNullParameter(type, "type");
        if (!this.isJson() && this.strictContentTypes()) {
            throw new BadRequestResponse("Content-Type is not application/json", null, 2, null);
        }
        JsonMapper jsonMapper2 = this.jsonMapper();
        ServletInputStream servletInputStream = this.req().getInputStream();
        Intrinsics.checkNotNullExpressionValue(servletInputStream, "getInputStream(...)");
        return jsonMapper2.fromJsonStream(servletInputStream, type);
    }

    @NotNull
    default public InputStream bodyInputStream() {
        ServletInputStream servletInputStream = this.req().getInputStream();
        Intrinsics.checkNotNullExpressionValue(servletInputStream, "getInputStream(...)");
        return servletInputStream;
    }

    @NotNull
    default public <T> BodyValidator<T> bodyValidator(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        return new BodyValidator<T>(this.body(), clazz, new Function0<T>(this, clazz){
            final /* synthetic */ Context this$0;
            final /* synthetic */ Class<T> $clazz;
            {
                this.this$0 = $receiver;
                this.$clazz = $clazz;
                super(0);
            }

            @Nullable
            public final T invoke() {
                return this.this$0.bodyAsClass(this.$clazz);
            }
        });
    }

    @Nullable
    default public String formParam(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return CollectionsKt.firstOrNull(this.formParams(key));
    }

    @NotNull
    default public <T> Validator<T> formParamAsClass(@NotNull String key, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        return this.appData(Validation.ValidationKey).validator(key, clazz, this.formParam(key));
    }

    @NotNull
    default public List<String> formParams(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        List<String> list = this.formParamMap().get(key);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    default public Map<String, List<String>> formParamMap() {
        Map<String, List<String>> map;
        if (this.isMultipartFormData()) {
            map = MultipartUtil.INSTANCE.getFieldMap(this.req());
        } else if (this.isFormUrlencoded() || !this.strictContentTypes()) {
            String string = this.body();
            String string2 = this.characterEncoding();
            if (string2 == null) {
                string2 = "UTF-8";
            }
            map = JavalinServletContextKt.splitKeyValueStringAndGroupByKey(string, string2);
        } else {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    public boolean strictContentTypes();

    @NotNull
    public String pathParam(@NotNull String var1);

    @NotNull
    default public <T> Validator<T> pathParamAsClass(@NotNull String key, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        return this.appData(Validation.ValidationKey).validator(key, clazz, this.pathParam(key));
    }

    @NotNull
    public Map<String, String> pathParamMap();

    @Nullable
    default public String queryParam(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return CollectionsKt.firstOrNull(this.queryParams(key));
    }

    @NotNull
    default public <T> Validator<T> queryParamAsClass(@NotNull String key, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        return this.appData(Validation.ValidationKey).validator(key, clazz, this.queryParam(key));
    }

    @NotNull
    default public List<String> queryParams(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        List<String> list = this.queryParamMap().get(key);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    default public Map<String, List<String>> queryParamMap() {
        String string;
        String string2 = this.queryString();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = this.characterEncoding()) == null) {
            string = "UTF-8";
        }
        return JavalinServletContextKt.splitKeyValueStringAndGroupByKey(string2, string);
    }

    @Nullable
    default public String queryString() {
        return this.req().getQueryString();
    }

    default public void sessionAttribute(@NotNull String key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.req().getSession().setAttribute(key, value);
    }

    @Nullable
    default public <T> T sessionAttribute(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        HttpSession httpSession = this.req().getSession(false);
        Object object = httpSession != null ? httpSession.getAttribute(key) : null;
        if (object == null) {
            object = null;
        }
        return (T)object;
    }

    @Nullable
    default public <T> T consumeSessionAttribute(@NotNull String key) {
        T t;
        Intrinsics.checkNotNullParameter(key, "key");
        T it = t = this.sessionAttribute(key);
        boolean bl = false;
        this.sessionAttribute(key, null);
        return t;
    }

    default public void cachedSessionAttribute(@NotNull String key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter(key, "key");
        JavalinServletContextKt.cacheAndSetSessionAttribute(key, value, this.req());
    }

    @Nullable
    default public <T> T cachedSessionAttribute(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return JavalinServletContextKt.getCachedRequestAttributeOrSessionAttribute(key, this.req());
    }

    @Nullable
    default public <T> T cachedSessionAttributeOrCompute(@NotNull String key, @NotNull Function1<? super Context, ? extends T> callback) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(callback, "callback");
        return JavalinServletContextKt.cachedSessionAttributeOrCompute(callback, key, this);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Map<String, Object> sessionAttributeMap() {
        Enumeration<String> enumeration = this.req().getSession().getAttributeNames();
        Intrinsics.checkNotNullExpressionValue(enumeration, "getAttributeNames(...)");
        Sequence<String> $this$associateWith$iv = SequencesKt.asSequence(CollectionsKt.iterator(enumeration));
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Sequence<String> $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        Iterator<String> iterator2 = $this$associateWithTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            String element$iv$iv;
            String string = element$iv$iv = iterator2.next();
            String string2 = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Object t = this.sessionAttribute((String)it);
            map.put(string2, t);
        }
        return result$iv;
    }

    default public void attribute(@NotNull String key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.req().setAttribute(key, value);
    }

    @Nullable
    default public <T> T attribute(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        Object object = this.req().getAttribute(key);
        if (object == null) {
            object = null;
        }
        return (T)object;
    }

    @Nullable
    default public <T> T attributeOrCompute(@NotNull String key, @NotNull Function1<? super Context, ? extends T> callback) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(callback, "callback");
        return JavalinServletContextKt.attributeOrCompute(callback, key, this);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Map<String, Object> attributeMap() {
        Enumeration<String> enumeration = this.req().getAttributeNames();
        Intrinsics.checkNotNullExpressionValue(enumeration, "getAttributeNames(...)");
        Sequence<String> $this$associateWith$iv = SequencesKt.asSequence(CollectionsKt.iterator(enumeration));
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Sequence<String> $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        Iterator<String> iterator2 = $this$associateWithTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            String element$iv$iv;
            String string = element$iv$iv = iterator2.next();
            String string2 = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Object t = this.attribute((String)it);
            map.put(string2, t);
        }
        return result$iv;
    }

    @NotNull
    default public CookieStore cookieStore() {
        return new CookieStore(this);
    }

    @Nullable
    default public String cookie(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return CookieKt.getCookie(this.req(), name);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Map<String, String> cookieMap() {
        Map map;
        jakarta.servlet.http.Cookie[] cookieArray = this.req().getCookies();
        if (cookieArray != null) {
            void $this$associateTo$iv$iv;
            jakarta.servlet.http.Cookie[] $this$associate$iv = cookieArray;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity($this$associate$iv.length), 16);
            jakarta.servlet.http.Cookie[] cookieArray2 = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (void element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                void it = element$iv$iv;
                boolean bl = false;
                Pair<String, String> pair = TuplesKt.to(it.getName(), it.getValue());
                map2.put(pair.getFirst(), pair.getSecond());
            }
            map = destination$iv$iv;
        } else {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @Nullable
    default public String header(@NotNull String header) {
        Intrinsics.checkNotNullParameter(header, "header");
        return this.req().getHeader(header);
    }

    @NotNull
    default public <T> Validator<T> headerAsClass(@NotNull String header, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(header, "header");
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        return this.appData(Validation.ValidationKey).validator(header, clazz, this.header(header));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Map<String, String> headerMap() {
        Enumeration<String> enumeration = this.req().getHeaderNames();
        Intrinsics.checkNotNullExpressionValue(enumeration, "getHeaderNames(...)");
        Sequence<String> $this$associateWith$iv = SequencesKt.asSequence(CollectionsKt.iterator(enumeration));
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Sequence<String> $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        Iterator<String> iterator2 = $this$associateWithTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String string;
            void it;
            String element$iv$iv;
            String string2 = element$iv$iv = iterator2.next();
            String string3 = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(this.header((String)it));
            map.put(string3, string);
        }
        return result$iv;
    }

    @Nullable
    default public BasicAuthCredentials basicAuthCredentials() {
        return JavalinServletContextKt.getBasicAuthCredentials(this.header("Authorization"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isMultipart() {
        String string = this.header("Content-Type");
        String string2 = string;
        if (string == null) return false;
        String string3 = string2;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
        String string4 = string3.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
        string2 = string4;
        if (string4 == null) return false;
        if (!StringsKt.startsWith$default(string2, "multipart/", false, 2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isMultipartFormData() {
        String string = this.header("Content-Type");
        String string2 = string;
        if (string == null) return false;
        String string3 = string2;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
        String string4 = string3.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
        string2 = string4;
        if (string4 == null) return false;
        if (!StringsKt.startsWith$default(string2, "multipart/form-data", false, 2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isFormUrlencoded() {
        String string = this.header("Content-Type");
        String string2 = string;
        if (string == null) return false;
        String string3 = string2;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
        String string4 = string3.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
        string2 = string4;
        if (string4 == null) return false;
        if (!StringsKt.startsWith$default(string2, "application/x-www-form-urlencoded", false, 2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isJson() {
        String string = this.header("Content-Type");
        String string2 = string;
        if (string == null) return false;
        String string3 = string2;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
        String string4 = string3.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
        string2 = string4;
        if (string4 == null) return false;
        if (!StringsKt.startsWith$default(string2, "application/json", false, 2, null)) return false;
        return true;
    }

    @Nullable
    default public UploadedFile uploadedFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        return CollectionsKt.firstOrNull(this.uploadedFiles(fileName));
    }

    @NotNull
    default public List<UploadedFile> uploadedFiles(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        return this.isMultipartFormData() ? MultipartUtil.INSTANCE.getUploadedFiles(this.req(), fileName) : CollectionsKt.emptyList();
    }

    @NotNull
    default public List<UploadedFile> uploadedFiles() {
        return this.isMultipartFormData() ? MultipartUtil.INSTANCE.getUploadedFiles(this.req()) : CollectionsKt.emptyList();
    }

    @NotNull
    default public Map<String, List<UploadedFile>> uploadedFileMap() {
        return this.isMultipartFormData() ? MultipartUtil.INSTANCE.getUploadedFileMap(this.req()) : MapsKt.emptyMap();
    }

    @NotNull
    default public Charset responseCharset() {
        Object object;
        Object $this$responseCharset_u24lambda_u245;
        Object object2 = this;
        try {
            $this$responseCharset_u24lambda_u245 = object2;
            boolean bl = false;
            $this$responseCharset_u24lambda_u245 = Result.constructor-impl(Charset.forName($this$responseCharset_u24lambda_u245.res().getCharacterEncoding()));
        }
        catch (Throwable bl) {
            $this$responseCharset_u24lambda_u245 = Result.constructor-impl(ResultKt.createFailure(bl));
        }
        object2 = $this$responseCharset_u24lambda_u245;
        Throwable throwable = Result.exceptionOrNull-impl(object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = Charset.defaultCharset();
        }
        Intrinsics.checkNotNullExpressionValue(object, "getOrElse(...)");
        return (Charset)object;
    }

    @NotNull
    public ServletOutputStream outputStream();

    @NotNull
    public Context minSizeForCompression(int var1);

    default public void writeSeekableStream(@NotNull InputStream inputStream, @NotNull String contentType, long totalBytes) {
        Intrinsics.checkNotNullParameter(inputStream, "inputStream");
        Intrinsics.checkNotNullParameter(contentType, "contentType");
        SeekableWriter.INSTANCE.write(this, inputStream, contentType, totalBytes);
    }

    default public void writeSeekableStream(@NotNull InputStream inputStream, @NotNull String contentType) {
        Intrinsics.checkNotNullParameter(inputStream, "inputStream");
        Intrinsics.checkNotNullParameter(contentType, "contentType");
        this.writeSeekableStream(inputStream, contentType, inputStream.available());
    }

    @NotNull
    default public Context result(@NotNull String resultString) {
        Intrinsics.checkNotNullParameter(resultString, "resultString");
        byte[] byArray = resultString.getBytes(this.responseCharset());
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        return this.result(new ByteArrayInputStream(byArray));
    }

    @NotNull
    default public Context result(@NotNull byte[] resultBytes) {
        Intrinsics.checkNotNullParameter(resultBytes, "resultBytes");
        return this.result(new ByteArrayInputStream(resultBytes));
    }

    @NotNull
    public Context result(@NotNull InputStream var1);

    @Nullable
    default public String result() {
        return JavalinServletContextKt.readAndResetStreamIfPossible(this.resultInputStream(), this.responseCharset());
    }

    @Nullable
    public InputStream resultInputStream();

    /*
     * WARNING - void declaration
     */
    default public void async(@NotNull Consumer<AsyncTaskConfig> config, @NotNull ThrowingRunnable<Exception> task) {
        void it;
        AsyncTaskConfig asyncTaskConfig;
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(task, "task");
        AsyncTaskConfig asyncTaskConfig2 = asyncTaskConfig = new AsyncTaskConfig();
        Context context = this;
        AsyncExecutor asyncExecutor2 = this.appData(AsyncExecutor.Companion.getAsyncExecutorKey());
        boolean bl = false;
        config.accept((AsyncTaskConfig)it);
        Unit unit = Unit.INSTANCE;
        asyncExecutor2.submitAsyncTask(context, asyncTaskConfig, task);
    }

    default public void async(@NotNull ThrowingRunnable<Exception> task) {
        Intrinsics.checkNotNullParameter(task, "task");
        this.async(Context::async$lambda$8, task);
    }

    public void future(@NotNull Supplier<? extends CompletableFuture<?>> var1);

    @NotNull
    default public Context contentType(@NotNull String contentType) {
        Context context;
        Intrinsics.checkNotNullParameter(contentType, "contentType");
        Context it = context = this;
        boolean bl = false;
        this.res().setContentType(contentType);
        return context;
    }

    @NotNull
    default public Context contentType(@NotNull ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)contentType, "contentType");
        return this.contentType(contentType.getMimeType());
    }

    @NotNull
    default public Context header(@NotNull String name, @NotNull String value) {
        Context context;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        Context it = context = this;
        boolean bl = false;
        this.res().setHeader(name, value);
        return context;
    }

    @NotNull
    default public Context removeHeader(@NotNull String name) {
        Context context;
        Intrinsics.checkNotNullParameter(name, "name");
        Context it = context = this;
        boolean bl = false;
        this.res().setHeader(name, null);
        return context;
    }

    public void redirect(@NotNull String var1, @NotNull HttpStatus var2);

    default public void redirect(@NotNull String location) {
        Intrinsics.checkNotNullParameter(location, "location");
        this.redirect(location, HttpStatus.FOUND);
    }

    @NotNull
    default public Context status(@NotNull HttpStatus status) {
        Context context;
        Intrinsics.checkNotNullParameter((Object)status, "status");
        Context it = context = this;
        boolean bl = false;
        this.res().setStatus(status.getCode());
        return context;
    }

    @NotNull
    default public Context status(int status) {
        Context context;
        Context it = context = this;
        boolean bl = false;
        this.res().setStatus(status);
        return context;
    }

    @NotNull
    default public HttpStatus status() {
        return HttpStatus.Companion.forStatus(this.res().getStatus());
    }

    default public int statusCode() {
        return this.res().getStatus();
    }

    @NotNull
    default public Context cookie(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        return this.cookie(name, value, -1);
    }

    @NotNull
    default public Context cookie(@NotNull String name, @NotNull String value, int maxAge) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        return this.cookie(new Cookie(name, value, null, maxAge, false, 0, false, null, null, null, 1012, null));
    }

    @NotNull
    default public Context cookie(@NotNull Cookie cookie) {
        Context context;
        Intrinsics.checkNotNullParameter(cookie, "cookie");
        Context it = context = this;
        boolean bl = false;
        CookieKt.setJavalinCookie(this.res(), cookie);
        return context;
    }

    @NotNull
    default public Context removeCookie(@NotNull String name, @Nullable String path) {
        Context context;
        Intrinsics.checkNotNullParameter(name, "name");
        Context it = context = this;
        boolean bl = false;
        CookieKt.removeCookie(this.res(), name, path);
        return context;
    }

    @NotNull
    default public Context removeCookie(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.removeCookie(name, "/");
    }

    @NotNull
    default public Context json(@NotNull Object obj, @NotNull Type type) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        Intrinsics.checkNotNullParameter(type, "type");
        return this.contentType(ContentType.APPLICATION_JSON).result(this.jsonMapper().toJsonString(obj, type));
    }

    @NotNull
    default public Context json(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        return this.json(obj, obj.getClass());
    }

    @NotNull
    default public Context jsonStream(@NotNull Object obj, @NotNull Type type) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        Intrinsics.checkNotNullParameter(type, "type");
        return this.contentType(ContentType.APPLICATION_JSON).result(this.jsonMapper().toJsonStream(obj, type));
    }

    @NotNull
    default public Context jsonStream(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        return this.jsonStream(obj, obj.getClass());
    }

    public void writeJsonStream(@NotNull Stream<?> var1);

    @NotNull
    default public Context html(@NotNull String html) {
        Intrinsics.checkNotNullParameter(html, "html");
        return this.contentType(ContentType.TEXT_HTML).result(html);
    }

    @NotNull
    default public Context render(@NotNull String filePath, @NotNull Map<String, ? extends Object> model) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        Intrinsics.checkNotNullParameter(model, "model");
        return this.html(this.appData(FileRenderer.FileRendererKey).render(filePath, model, this));
    }

    @NotNull
    default public Context render(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        return this.render(filePath, new LinkedHashMap());
    }

    @NotNull
    public Context skipRemainingHandlers();

    @NotNull
    public Set<RouteRole> routeRoles();

    private static void async$lambda$8(AsyncTaskConfig it) {
        Intrinsics.checkNotNullParameter(it, "it");
    }
}

