/*
 * Decompiled with CFR 0.152.
 */
package com.trashbingames.sparkwebapi;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.trashbingames.sparkwebapi.CPUUsageInfo;
import com.trashbingames.sparkwebapi.GCSerializer;
import com.trashbingames.sparkwebapi.MSPTInfo;
import com.trashbingames.sparkwebapi.MSPTInfoSerializer;
import com.trashbingames.sparkwebapi.TPSInfo;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.http.HttpStatus;
import io.javalin.json.JavalinJackson;
import io.javalin.json.JsonMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import me.lucko.spark.api.Spark;
import me.lucko.spark.api.SparkProvider;
import me.lucko.spark.api.gc.GarbageCollector;
import me.lucko.spark.api.statistic.StatisticWindow;
import me.lucko.spark.api.statistic.misc.DoubleAverageInfo;
import me.lucko.spark.api.statistic.types.DoubleStatistic;
import me.lucko.spark.api.statistic.types.GenericStatistic;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public final class SparkWebAPI
extends JavaPlugin {
    public Logger logger = this.getLogger();
    Javalin app;
    Spark spark;
    FileConfiguration pluginConfig;
    Map<String, Object> headers;

    public void onEnable() {
        this.logger.info("Hello, world!");
        this.saveDefaultConfig();
        this.pluginConfig = this.getConfig();
        this.headers = Objects.requireNonNull(this.pluginConfig.getConfigurationSection("headers")).getValues(false);
        Map routes = Objects.requireNonNull(this.pluginConfig.getConfigurationSection("routes")).getValues(false);
        if (((Boolean)this.headers.get("enabled")).booleanValue()) {
            this.headers.remove("enabled");
        } else {
            this.headers = new HashMap<String, Object>();
        }
        this.spark = SparkProvider.get();
        this.app = Javalin.create(config -> config.jsonMapper((JsonMapper)new JavalinJackson().updateMapper(mapper -> {
            SimpleModule module = new SimpleModule("Serializers");
            module.addSerializer(MSPTInfo.class, (JsonSerializer)new MSPTInfoSerializer());
            module.addSerializer(GarbageCollector.class, (JsonSerializer)new GCSerializer());
            mapper.registerModule((Module)module);
        })));
        if (((Boolean)routes.get("tps")).booleanValue()) {
            this.app.get("/api/tps", this::getTps);
        }
        if (((Boolean)routes.get("mspt")).booleanValue()) {
            this.app.get("/api/mspt", this::getMspt);
        }
        if (((Boolean)routes.get("sys_cpu")).booleanValue()) {
            this.app.get("/api/cpu/sys", this::getSysCpuUsage);
        }
        if (((Boolean)routes.get("proc_cpu")).booleanValue()) {
            this.app.get("/api/cpu/proc", this::getProcCpuUsage);
        }
        if (((Boolean)routes.get("gc")).booleanValue()) {
            this.app.get("/api/gc", this::getGCData);
        }
        this.app.start(this.pluginConfig.getInt("port"));
    }

    public void onDisable() {
        this.logger.info("Shutting down Spark Web API...");
        this.app.stop();
    }

    void addHeaders(Context ctx) {
        for (Map.Entry<String, Object> header : this.headers.entrySet()) {
            Object val = header.getValue();
            if (val == null) {
                ctx.header(header.getKey());
                continue;
            }
            ctx.header(header.getKey(), (String)val);
        }
    }

    void getTps(Context ctx) {
        DoubleStatistic tps = this.spark.tps();
        this.addHeaders(ctx);
        if (tps == null) {
            ctx.status(HttpStatus.INTERNAL_SERVER_ERROR);
            return;
        }
        ctx.json((Object)new TPSInfo(tps.poll((Enum)StatisticWindow.TicksPerSecond.SECONDS_10), tps.poll((Enum)StatisticWindow.TicksPerSecond.MINUTES_1), tps.poll((Enum)StatisticWindow.TicksPerSecond.MINUTES_5), tps.poll((Enum)StatisticWindow.TicksPerSecond.MINUTES_15)));
    }

    void getMspt(Context ctx) {
        GenericStatistic mspt = this.spark.mspt();
        this.addHeaders(ctx);
        if (mspt == null) {
            ctx.status(HttpStatus.INTERNAL_SERVER_ERROR);
            return;
        }
        ctx.json((Object)new MSPTInfo(new MSPTInfo.MSPTStat((DoubleAverageInfo)mspt.poll((Enum)StatisticWindow.MillisPerTick.SECONDS_10)), new MSPTInfo.MSPTStat((DoubleAverageInfo)mspt.poll((Enum)StatisticWindow.MillisPerTick.MINUTES_1))));
    }

    void getSysCpuUsage(Context ctx) {
        ctx.json((Object)new CPUUsageInfo((DoubleStatistic<StatisticWindow.CpuUsage>)this.spark.cpuSystem()));
    }

    void getProcCpuUsage(Context ctx) {
        ctx.json((Object)new CPUUsageInfo((DoubleStatistic<StatisticWindow.CpuUsage>)this.spark.cpuProcess()));
    }

    void getGCData(Context ctx) {
        ctx.json((Object)this.spark.gc());
    }
}

