package com.startraveler.echoingchorus;

import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_7225;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;

import java.util.concurrent.CompletableFuture;

public class EchoingChorusEnglishNameProvider extends FabricLanguageProvider {
    public EchoingChorusEnglishNameProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        // Specifying en_us is optional, as it's the default language code
        super(dataOutput, "en_us", registryLookup);
    }

    @Override
    public void generateTranslations(class_7225.class_7874 provider, TranslationBuilder translationBuilder) {
        EchoingChorus.ITEMS.forEach(item -> {
            translationBuilder.add(
                    item.method_7876(),
                    WordUtils.capitalize(item.method_40131()
                            .method_40237().method_29177()
                            .method_12832()
                            .replace('/', ' ')
                            .replace('_', ' '))
            );
        });
        translationBuilder.add("tag.item." + EchoingChorus.MOD_ID + ".echoing_chorus_fruits", "Echoing Chorus Fruits");
    }

    @Override
    public @NotNull String method_10321() {
        return "Echoing Chorus en_us Language Provider";
    }
}

