/*
 * Decompiled with CFR 0.152.
 */
package net.adeptstack.ctl.behaviours.movement;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.elevator.ElevatorContraption;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import net.adeptstack.ctl.blocks.lights.HeadTailLightBlockBase;
import net.adeptstack.ctl.blocks.lights.LightBlockBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;

public class HeadTailLightMovementBehaviour
implements MovementBehaviour {
    public void tick(MovementContext context) {
        StructureTemplate.StructureBlockInfo structureBlockInfo = (StructureTemplate.StructureBlockInfo)context.contraption.getBlocks().get(context.localPos);
        if (structureBlockInfo == null) {
            return;
        }
        boolean open = (Boolean)structureBlockInfo.f_74676_().m_61143_((Property)LightBlockBase.LIT);
        if (!context.world.m_5776_()) {
            this.tickLIT(context, open);
        }
        int ticksOpen = context.data.m_128451_("OpenTicks");
        context.data.m_128405_("OpenTicks", ++ticksOpen);
        if (ticksOpen > 20) {
            BlockPos pos = context.localPos;
            AbstractContraptionEntity abstractContraptionEntity = context.contraption.entity;
            if (abstractContraptionEntity instanceof CarriageContraptionEntity) {
                CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
                abstractContraptionEntity = context.contraption;
                if (abstractContraptionEntity instanceof CarriageContraption) {
                    Vec3 value;
                    int localXZ;
                    Vec3 last;
                    CarriageContraption cc = (CarriageContraption)abstractContraptionEntity;
                    Direction assemblyDirection = cc.getAssemblyDirection();
                    if (assemblyDirection == Direction.UP || assemblyDirection == Direction.DOWN) {
                        return;
                    }
                    Vec3 now = cce.m_20182_();
                    Vec3 motion = now.m_82546_(last = cce.getPrevPositionVec());
                    Direction direction = this.vecToDirection(motion);
                    if (direction == null) {
                        return;
                    }
                    if (Math.abs(motion.f_82479_) <= 1.0E-4 && (direction == Direction.EAST || direction == Direction.WEST)) {
                        return;
                    }
                    if (Math.abs(motion.f_82481_) <= 1.0E-4 && (direction == Direction.NORTH || direction == Direction.SOUTH)) {
                        return;
                    }
                    if (Math.abs(motion.f_82480_) <= 5.0E-4 && Math.abs(motion.f_82480_) != 0.0) {
                        return;
                    }
                    if (assemblyDirection == Direction.EAST || assemblyDirection == Direction.WEST) {
                        localXZ = pos.m_123341_();
                        Vec3 localP = new Vec3(1.0, 0.0, 0.0);
                        Vec3 localN = new Vec3(-1.0, 0.0, 0.0);
                        Vec3 globalP = cce.toGlobalVector(localP, 1.0f);
                        Vec3 globalN = cce.toGlobalVector(localN, 1.0f);
                        value = globalP.m_82546_(globalN);
                    } else {
                        localXZ = pos.m_123343_();
                        Vec3 localP = new Vec3(0.0, 0.0, 1.0);
                        Vec3 localN = new Vec3(0.0, 0.0, -1.0);
                        Vec3 globalP = cce.toGlobalVector(localP, 1.0f);
                        Vec3 globalN = cce.toGlobalVector(localN, 1.0f);
                        value = globalP.m_82546_(globalN);
                    }
                    if (direction == Direction.NORTH) {
                        if (value.f_82481_ > 0.0 && localXZ > 0) {
                            context.state = (BlockState)context.state.m_61124_((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(1));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.f_74677_()));
                        } else if (value.f_82481_ > 0.0 && localXZ < 0) {
                            context.state = (BlockState)context.state.m_61124_((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(0));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.f_74677_()));
                        } else if (value.f_82481_ < 0.0 && localXZ > 0) {
                            context.state = (BlockState)context.state.m_61124_((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(0));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.f_74677_()));
                        } else if (value.f_82481_ < 0.0 && localXZ < 0) {
                            context.state = (BlockState)context.state.m_61124_((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(1));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.f_74677_()));
                        }
                    } else if (direction == Direction.EAST) {
                        if (value.f_82479_ > 0.0 && localXZ > 0) {
                            context.state = (BlockState)context.state.m_61124_((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(0));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.f_74677_()));
                        } else if (value.f_82479_ > 0.0 && localXZ < 0) {
                            context.state = (BlockState)context.state.m_61124_((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(1));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.f_74677_()));
                        } else if (value.f_82479_ < 0.0 && localXZ > 0) {
                            context.state = (BlockState)context.state.m_61124_((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(1));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.f_74677_()));
                        } else if (value.f_82479_ < 0.0 && localXZ < 0) {
                            context.state = (BlockState)context.state.m_61124_((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(0));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.f_74677_()));
                        }
                    } else if (direction == Direction.SOUTH) {
                        if (value.f_82481_ > 0.0 && localXZ > 0) {
                            context.state = (BlockState)context.state.m_61124_((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(0));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.f_74677_()));
                        } else if (value.f_82481_ > 0.0 && localXZ < 0) {
                            context.state = (BlockState)context.state.m_61124_((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(1));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.f_74677_()));
                        } else if (value.f_82481_ < 0.0 && localXZ > 0) {
                            context.state = (BlockState)context.state.m_61124_((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(1));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.f_74677_()));
                        } else if (value.f_82481_ < 0.0 && localXZ < 0) {
                            context.state = (BlockState)context.state.m_61124_((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(0));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.f_74677_()));
                        }
                    } else if (direction == Direction.WEST) {
                        if (value.f_82479_ > 0.0 && localXZ > 0) {
                            context.state = (BlockState)context.state.m_61124_((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(1));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.f_74677_()));
                        } else if (value.f_82479_ > 0.0 && localXZ < 0) {
                            context.state = (BlockState)context.state.m_61124_((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(0));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.f_74677_()));
                        } else if (value.f_82479_ < 0.0 && localXZ > 0) {
                            context.state = (BlockState)context.state.m_61124_((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(0));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.f_74677_()));
                        } else if (value.f_82479_ < 0.0 && localXZ < 0) {
                            context.state = (BlockState)context.state.m_61124_((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(1));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.f_74677_()));
                        }
                    }
                }
            }
            context.data.m_128405_("OpenTicks", 0);
        }
    }

    protected void tickLIT(MovementContext context, boolean currentlyOpen) {
        boolean shouldLIT = this.shouldLIT(context);
        if (!this.shouldUpdate(context, shouldLIT)) {
            return;
        }
        if (currentlyOpen == shouldLIT) {
            return;
        }
        BlockPos pos = context.localPos;
        Contraption contraption = context.contraption;
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(pos);
        if (info == null || !info.f_74676_().m_61138_((Property)LightBlockBase.LIT)) {
            return;
        }
        this.toggleLight(context, pos, contraption, info);
    }

    private void toggleLight(MovementContext context, BlockPos pos, Contraption contraption, StructureTemplate.StructureBlockInfo info) {
        BlockState newState;
        BlockState currentState = context.state;
        if (!currentState.m_61138_((Property)LightBlockBase.LIT)) {
            return;
        }
        context.state = newState = (BlockState)currentState.m_61122_((Property)LightBlockBase.LIT);
        contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, newState, info.f_74677_()));
        if (info != null && info.f_74676_().m_61138_((Property)LightBlockBase.LIT)) {
            newState = (BlockState)info.f_74676_().m_61122_((Property)LightBlockBase.LIT);
            contraption.invalidateColliders();
            boolean open = (Boolean)newState.m_61143_((Property)LightBlockBase.LIT);
            if (!open) {
                contraption.getContraptionWorld().m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12055_, SoundSource.BLOCKS, 0.125f, 1.0f, false);
            } else {
                contraption.getContraptionWorld().m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12056_, SoundSource.BLOCKS, 0.125f, 1.0f, false);
            }
        }
    }

    protected boolean shouldUpdate(MovementContext context, boolean shouldLIT) {
        if (context.firstMovement && shouldLIT) {
            return false;
        }
        if (!context.data.m_128441_("Open")) {
            context.data.m_128379_("Open", shouldLIT);
            return true;
        }
        boolean wasOpen = context.data.m_128471_("Open");
        context.data.m_128379_("Open", shouldLIT);
        return wasOpen != shouldLIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean shouldLIT(MovementContext context) {
        if (context.disabled) {
            return false;
        }
        Contraption contraption = context.contraption;
        if (!contraption.entity.isStalled()) return true;
        if (contraption instanceof ElevatorContraption) {
            ElevatorContraption ec = (ElevatorContraption)contraption;
            if (ec.arrived) {
                return true;
            }
        }
        boolean bl = false;
        boolean canOpen = bl;
        if (canOpen) return true;
        context.temporaryData = null;
        return false;
    }

    private Direction vecToDirection(Vec3 movement) {
        double angle = Math.atan2(movement.f_82481_, movement.f_82479_);
        float degrees = (float)Math.toDegrees(angle);
        if (degrees < 0.0f) {
            degrees += 360.0f;
        }
        if (movement.f_82479_ == 0.0 && movement.f_82481_ == 0.0) {
            return null;
        }
        if (degrees >= 45.0f && degrees < 135.0f) {
            return Direction.SOUTH;
        }
        if (degrees >= 135.0f && degrees < 225.0f) {
            return Direction.WEST;
        }
        if (degrees >= 225.0f && degrees < 315.0f) {
            return Direction.NORTH;
        }
        return Direction.EAST;
    }

    public boolean mustTickWhileDisabled() {
        return true;
    }
}

