/*
 * Decompiled with CFR 0.152.
 */
package net.adeptstack.ctl.behaviours.movement;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.elevator.ElevatorContraption;
import net.adeptstack.ctl.blocks.lights.LightBlockBase;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class InteriorLightMovementBehaviour
implements MovementBehaviour {
    public void tick(MovementContext context) {
        StructureTemplate.StructureBlockInfo structureBlockInfo = (StructureTemplate.StructureBlockInfo)context.contraption.getBlocks().get(context.localPos);
        if (structureBlockInfo == null) {
            return;
        }
        boolean open = (Boolean)structureBlockInfo.f_74676_().m_61143_((Property)LightBlockBase.LIT);
        if (!context.world.m_5776_()) {
            this.tickLIT(context, open);
        }
    }

    protected void tickLIT(MovementContext context, boolean currentlyOpen) {
        boolean shouldLIT = this.shouldLIT(context);
        if (!this.shouldUpdate(context, shouldLIT)) {
            return;
        }
        if (currentlyOpen == shouldLIT) {
            return;
        }
        BlockPos pos = context.localPos;
        Contraption contraption = context.contraption;
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(pos);
        if (info == null || !info.f_74676_().m_61138_((Property)LightBlockBase.LIT)) {
            return;
        }
        this.toggleLight(pos, contraption, info);
    }

    private void toggleLight(BlockPos pos, Contraption contraption, StructureTemplate.StructureBlockInfo info) {
        BlockState newState = (BlockState)info.f_74676_().m_61122_((Property)LightBlockBase.LIT);
        contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(info.f_74675_(), newState, info.f_74677_()));
        if (info != null && info.f_74676_().m_61138_((Property)LightBlockBase.LIT)) {
            newState = (BlockState)info.f_74676_().m_61122_((Property)LightBlockBase.LIT);
            contraption.invalidateColliders();
            boolean open = (Boolean)newState.m_61143_((Property)LightBlockBase.LIT);
            if (!open) {
                contraption.getContraptionWorld().m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12055_, SoundSource.BLOCKS, 0.125f, 1.0f, false);
            } else {
                contraption.getContraptionWorld().m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12056_, SoundSource.BLOCKS, 0.125f, 1.0f, false);
            }
        }
    }

    protected boolean shouldUpdate(MovementContext context, boolean shouldLIT) {
        if (context.firstMovement && shouldLIT) {
            return false;
        }
        if (!context.data.m_128441_("Open")) {
            context.data.m_128379_("Open", shouldLIT);
            return true;
        }
        boolean wasOpen = context.data.m_128471_("Open");
        context.data.m_128379_("Open", shouldLIT);
        return wasOpen != shouldLIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean shouldLIT(MovementContext context) {
        if (context.disabled) {
            return false;
        }
        Contraption contraption = context.contraption;
        if (!contraption.entity.isStalled()) return true;
        if (contraption instanceof ElevatorContraption) {
            ElevatorContraption ec = (ElevatorContraption)contraption;
            if (ec.arrived) {
                return true;
            }
        }
        boolean bl = false;
        boolean canOpen = bl;
        if (canOpen) return true;
        context.temporaryData = null;
        return false;
    }

    public boolean mustTickWhileDisabled() {
        return true;
    }
}

