/*
 * Decompiled with CFR 0.152.
 */
package net.adeptstack.ctl.behaviours.movement;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.elevator.ElevatorContraption;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import net.adeptstack.ctl.blocks.lights.HeadTailLightBlockBase;
import net.adeptstack.ctl.blocks.lights.LightBlockBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;

public class HeadTailLightMovementBehaviour
implements MovementBehaviour {
    public void tick(MovementContext context) {
        StructureTemplate.StructureBlockInfo structureBlockInfo = (StructureTemplate.StructureBlockInfo)context.contraption.getBlocks().get(context.localPos);
        if (structureBlockInfo == null) {
            return;
        }
        boolean open = (Boolean)structureBlockInfo.state().getValue((Property)LightBlockBase.LIT);
        if (!context.world.isClientSide()) {
            this.tickLIT(context, open);
        }
        int ticksOpen = context.data.getInt("OpenTicks");
        context.data.putInt("OpenTicks", ++ticksOpen);
        if (ticksOpen > 20) {
            BlockPos pos = context.localPos;
            AbstractContraptionEntity abstractContraptionEntity = context.contraption.entity;
            if (abstractContraptionEntity instanceof CarriageContraptionEntity) {
                CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
                abstractContraptionEntity = context.contraption;
                if (abstractContraptionEntity instanceof CarriageContraption) {
                    Vec3 value;
                    int localXZ;
                    Vec3 last;
                    CarriageContraption cc = (CarriageContraption)abstractContraptionEntity;
                    Direction assemblyDirection = cc.getAssemblyDirection();
                    if (assemblyDirection == Direction.UP || assemblyDirection == Direction.DOWN) {
                        return;
                    }
                    Vec3 now = cce.position();
                    Vec3 motion = now.subtract(last = cce.getPrevPositionVec());
                    Direction direction = this.vecToDirection(motion);
                    if (direction == null) {
                        return;
                    }
                    if (Math.abs(motion.x) <= 1.0E-4 && (direction == Direction.EAST || direction == Direction.WEST)) {
                        return;
                    }
                    if (Math.abs(motion.z) <= 1.0E-4 && (direction == Direction.NORTH || direction == Direction.SOUTH)) {
                        return;
                    }
                    if (Math.abs(motion.y) <= 5.0E-4 && Math.abs(motion.y) != 0.0) {
                        return;
                    }
                    if (assemblyDirection == Direction.EAST || assemblyDirection == Direction.WEST) {
                        localXZ = pos.getX();
                        Vec3 localP = new Vec3(1.0, 0.0, 0.0);
                        Vec3 localN = new Vec3(-1.0, 0.0, 0.0);
                        Vec3 globalP = cce.toGlobalVector(localP, 1.0f);
                        Vec3 globalN = cce.toGlobalVector(localN, 1.0f);
                        value = globalP.subtract(globalN);
                    } else {
                        localXZ = pos.getZ();
                        Vec3 localP = new Vec3(0.0, 0.0, 1.0);
                        Vec3 localN = new Vec3(0.0, 0.0, -1.0);
                        Vec3 globalP = cce.toGlobalVector(localP, 1.0f);
                        Vec3 globalN = cce.toGlobalVector(localN, 1.0f);
                        value = globalP.subtract(globalN);
                    }
                    if (direction == Direction.NORTH) {
                        if (value.z > 0.0 && localXZ > 0) {
                            context.state = (BlockState)context.state.setValue((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(1));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.nbt()));
                        } else if (value.z > 0.0 && localXZ < 0) {
                            context.state = (BlockState)context.state.setValue((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(0));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.nbt()));
                        } else if (value.z < 0.0 && localXZ > 0) {
                            context.state = (BlockState)context.state.setValue((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(0));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.nbt()));
                        } else if (value.z < 0.0 && localXZ < 0) {
                            context.state = (BlockState)context.state.setValue((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(1));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.nbt()));
                        }
                    } else if (direction == Direction.EAST) {
                        if (value.x > 0.0 && localXZ > 0) {
                            context.state = (BlockState)context.state.setValue((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(0));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.nbt()));
                        } else if (value.x > 0.0 && localXZ < 0) {
                            context.state = (BlockState)context.state.setValue((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(1));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.nbt()));
                        } else if (value.x < 0.0 && localXZ > 0) {
                            context.state = (BlockState)context.state.setValue((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(1));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.nbt()));
                        } else if (value.x < 0.0 && localXZ < 0) {
                            context.state = (BlockState)context.state.setValue((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(0));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.nbt()));
                        }
                    } else if (direction == Direction.SOUTH) {
                        if (value.z > 0.0 && localXZ > 0) {
                            context.state = (BlockState)context.state.setValue((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(0));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.nbt()));
                        } else if (value.z > 0.0 && localXZ < 0) {
                            context.state = (BlockState)context.state.setValue((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(1));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.nbt()));
                        } else if (value.z < 0.0 && localXZ > 0) {
                            context.state = (BlockState)context.state.setValue((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(1));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.nbt()));
                        } else if (value.z < 0.0 && localXZ < 0) {
                            context.state = (BlockState)context.state.setValue((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(0));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.nbt()));
                        }
                    } else if (direction == Direction.WEST) {
                        if (value.x > 0.0 && localXZ > 0) {
                            context.state = (BlockState)context.state.setValue((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(1));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.nbt()));
                        } else if (value.x > 0.0 && localXZ < 0) {
                            context.state = (BlockState)context.state.setValue((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(0));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.nbt()));
                        } else if (value.x < 0.0 && localXZ > 0) {
                            context.state = (BlockState)context.state.setValue((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(0));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.nbt()));
                        } else if (value.x < 0.0 && localXZ < 0) {
                            context.state = (BlockState)context.state.setValue((Property)HeadTailLightBlockBase.LIGHT_MODE, (Comparable)Integer.valueOf(1));
                            context.contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, context.state, structureBlockInfo.nbt()));
                        }
                    }
                }
            }
            context.data.putInt("OpenTicks", 0);
        }
    }

    protected void tickLIT(MovementContext context, boolean currentlyOpen) {
        boolean shouldLIT = this.shouldLIT(context);
        if (!this.shouldUpdate(context, shouldLIT)) {
            return;
        }
        if (currentlyOpen == shouldLIT) {
            return;
        }
        BlockPos pos = context.localPos;
        Contraption contraption = context.contraption;
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(pos);
        if (info == null || !info.state().hasProperty((Property)LightBlockBase.LIT)) {
            return;
        }
        this.toggleLight(context, pos, contraption, info);
    }

    private void toggleLight(MovementContext context, BlockPos pos, Contraption contraption, StructureTemplate.StructureBlockInfo info) {
        BlockState newState;
        BlockState currentState = context.state;
        if (!currentState.hasProperty((Property)LightBlockBase.LIT)) {
            return;
        }
        context.state = newState = (BlockState)currentState.cycle((Property)LightBlockBase.LIT);
        contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(pos, newState, info.nbt()));
        if (info != null && info.state().hasProperty((Property)LightBlockBase.LIT)) {
            newState = (BlockState)info.state().cycle((Property)LightBlockBase.LIT);
            contraption.invalidateColliders();
            boolean open = (Boolean)newState.getValue((Property)LightBlockBase.LIT);
            if (!open) {
                contraption.getContraptionWorld().playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.IRON_DOOR_CLOSE, SoundSource.BLOCKS, 0.125f, 1.0f, false);
            } else {
                contraption.getContraptionWorld().playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.IRON_DOOR_OPEN, SoundSource.BLOCKS, 0.125f, 1.0f, false);
            }
        }
    }

    protected boolean shouldUpdate(MovementContext context, boolean shouldLIT) {
        if (context.firstMovement && shouldLIT) {
            return false;
        }
        if (!context.data.contains("Open")) {
            context.data.putBoolean("Open", shouldLIT);
            return true;
        }
        boolean wasOpen = context.data.getBoolean("Open");
        context.data.putBoolean("Open", shouldLIT);
        return wasOpen != shouldLIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean shouldLIT(MovementContext context) {
        if (context.disabled) {
            return false;
        }
        Contraption contraption = context.contraption;
        if (!contraption.entity.isStalled()) return true;
        if (contraption instanceof ElevatorContraption) {
            ElevatorContraption ec = (ElevatorContraption)contraption;
            if (ec.arrived) {
                return true;
            }
        }
        boolean bl = false;
        boolean canOpen = bl;
        if (canOpen) return true;
        context.temporaryData = null;
        return false;
    }

    private Direction vecToDirection(Vec3 movement) {
        double angle = Math.atan2(movement.z, movement.x);
        float degrees = (float)Math.toDegrees(angle);
        if (degrees < 0.0f) {
            degrees += 360.0f;
        }
        if (movement.x == 0.0 && movement.z == 0.0) {
            return null;
        }
        if (degrees >= 45.0f && degrees < 135.0f) {
            return Direction.SOUTH;
        }
        if (degrees >= 135.0f && degrees < 225.0f) {
            return Direction.WEST;
        }
        if (degrees >= 225.0f && degrees < 315.0f) {
            return Direction.NORTH;
        }
        return Direction.EAST;
    }

    public boolean mustTickWhileDisabled() {
        return true;
    }
}

