/*
 * Decompiled with CFR 0.152.
 */
package net.adeptstack.ctl.behaviours.movement;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.elevator.ElevatorContraption;
import net.adeptstack.ctl.blocks.lights.LightBlockBase;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class InteriorLightMovementBehaviour
implements MovementBehaviour {
    public void tick(MovementContext context) {
        StructureTemplate.StructureBlockInfo structureBlockInfo = (StructureTemplate.StructureBlockInfo)context.contraption.getBlocks().get(context.localPos);
        if (structureBlockInfo == null) {
            return;
        }
        boolean open = (Boolean)structureBlockInfo.state().getValue((Property)LightBlockBase.LIT);
        if (!context.world.isClientSide()) {
            this.tickLIT(context, open);
        }
    }

    protected void tickLIT(MovementContext context, boolean currentlyOpen) {
        boolean shouldLIT = this.shouldLIT(context);
        if (!this.shouldUpdate(context, shouldLIT)) {
            return;
        }
        if (currentlyOpen == shouldLIT) {
            return;
        }
        BlockPos pos = context.localPos;
        Contraption contraption = context.contraption;
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(pos);
        if (info == null || !info.state().hasProperty((Property)LightBlockBase.LIT)) {
            return;
        }
        this.toggleLight(pos, contraption, info);
    }

    private void toggleLight(BlockPos pos, Contraption contraption, StructureTemplate.StructureBlockInfo info) {
        BlockState newState = (BlockState)info.state().cycle((Property)LightBlockBase.LIT);
        contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(info.pos(), newState, info.nbt()));
        if (info != null && info.state().hasProperty((Property)LightBlockBase.LIT)) {
            newState = (BlockState)info.state().cycle((Property)LightBlockBase.LIT);
            contraption.invalidateColliders();
            boolean open = (Boolean)newState.getValue((Property)LightBlockBase.LIT);
            if (!open) {
                contraption.getContraptionWorld().playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.IRON_DOOR_CLOSE, SoundSource.BLOCKS, 0.125f, 1.0f, false);
            } else {
                contraption.getContraptionWorld().playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.IRON_DOOR_OPEN, SoundSource.BLOCKS, 0.125f, 1.0f, false);
            }
        }
    }

    protected boolean shouldUpdate(MovementContext context, boolean shouldLIT) {
        if (context.firstMovement && shouldLIT) {
            return false;
        }
        if (!context.data.contains("Open")) {
            context.data.putBoolean("Open", shouldLIT);
            return true;
        }
        boolean wasOpen = context.data.getBoolean("Open");
        context.data.putBoolean("Open", shouldLIT);
        return wasOpen != shouldLIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean shouldLIT(MovementContext context) {
        if (context.disabled) {
            return false;
        }
        Contraption contraption = context.contraption;
        if (!contraption.entity.isStalled()) return true;
        if (contraption instanceof ElevatorContraption) {
            ElevatorContraption ec = (ElevatorContraption)contraption;
            if (ec.arrived) {
                return true;
            }
        }
        boolean bl = false;
        boolean canOpen = bl;
        if (canOpen) return true;
        context.temporaryData = null;
        return false;
    }

    public boolean mustTickWhileDisabled() {
        return true;
    }
}

