/*
 * Decompiled with CFR 0.152.
 */
package net.adeptstack.ctl.blocks.lights.interiorLights.fulldirectional;

import net.adeptstack.ctl.blocks.lights.interiorLights.FullDirectionalInteriorLightBlock;
import net.adeptstack.ctl.enums.EBlockPlacePosition;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class QuarterInteriorLightBlock
extends FullDirectionalInteriorLightBlock {
    public static final EnumProperty<EBlockPlacePosition> IBP = EnumProperty.create((String)"ibp", EBlockPlacePosition.class);
    private static final VoxelShape SHAPE_D_C = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0);
    private static final VoxelShape SHAPE_D_TL = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)3.0, (double)8.0);
    private static final VoxelShape SHAPE_D_TR = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)8.0);
    private static final VoxelShape SHAPE_D_BL = Block.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)3.0, (double)16.0);
    private static final VoxelShape SHAPE_D_BR = Block.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape SHAPE_U_C = Block.box((double)4.0, (double)13.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape SHAPE_U_TL = Block.box((double)0.0, (double)13.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    private static final VoxelShape SHAPE_U_TR = Block.box((double)8.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    private static final VoxelShape SHAPE_U_BL = Block.box((double)0.0, (double)13.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_U_BR = Block.box((double)8.0, (double)13.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_N_C = Block.box((double)4.0, (double)4.0, (double)13.0, (double)12.0, (double)12.0, (double)16.0);
    private static final VoxelShape SHAPE_N_TL = Block.box((double)8.0, (double)8.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_N_TR = Block.box((double)0.0, (double)8.0, (double)13.0, (double)8.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_N_BL = Block.box((double)8.0, (double)0.0, (double)13.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE_N_BR = Block.box((double)0.0, (double)0.0, (double)13.0, (double)8.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE_E_C = Block.box((double)0.0, (double)4.0, (double)4.0, (double)3.0, (double)12.0, (double)12.0);
    private static final VoxelShape SHAPE_E_TL = Block.box((double)0.0, (double)8.0, (double)8.0, (double)3.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_E_TR = Block.box((double)0.0, (double)8.0, (double)0.0, (double)3.0, (double)16.0, (double)8.0);
    private static final VoxelShape SHAPE_E_BL = Block.box((double)0.0, (double)0.0, (double)8.0, (double)3.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE_E_BR = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)8.0, (double)8.0);
    private static final VoxelShape SHAPE_S_C = Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)3.0);
    private static final VoxelShape SHAPE_S_TL = Block.box((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)3.0);
    private static final VoxelShape SHAPE_S_TR = Block.box((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    private static final VoxelShape SHAPE_S_BL = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)3.0);
    private static final VoxelShape SHAPE_S_BR = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)3.0);
    private static final VoxelShape SHAPE_W_C = Block.box((double)13.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final VoxelShape SHAPE_W_TL = Block.box((double)13.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    private static final VoxelShape SHAPE_W_TR = Block.box((double)13.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_W_BL = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    private static final VoxelShape SHAPE_W_BR = Block.box((double)13.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);

    public QuarterInteriorLightBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(IBP, (Comparable)((Object)EBlockPlacePosition.CENTER)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{IBP});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getDefaultPlacementState(context);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.getValue((Property)FACING) == Direction.UP) {
            if (pState.getValue(IBP) == EBlockPlacePosition.TOP_LEFT) {
                return SHAPE_U_TL;
            }
            if (pState.getValue(IBP) == EBlockPlacePosition.TOP_RIGHT) {
                return SHAPE_U_TR;
            }
            if (pState.getValue(IBP) == EBlockPlacePosition.CENTER) {
                return SHAPE_U_C;
            }
            if (pState.getValue(IBP) == EBlockPlacePosition.BOTTOM_LEFT) {
                return SHAPE_U_BL;
            }
            if (pState.getValue(IBP) == EBlockPlacePosition.BOTTOM_RIGHT) {
                return SHAPE_U_BR;
            }
        } else if (pState.getValue((Property)FACING) == Direction.DOWN) {
            if (pState.getValue(IBP) == EBlockPlacePosition.TOP_LEFT) {
                return SHAPE_D_TL;
            }
            if (pState.getValue(IBP) == EBlockPlacePosition.TOP_RIGHT) {
                return SHAPE_D_TR;
            }
            if (pState.getValue(IBP) == EBlockPlacePosition.CENTER) {
                return SHAPE_D_C;
            }
            if (pState.getValue(IBP) == EBlockPlacePosition.BOTTOM_LEFT) {
                return SHAPE_D_BL;
            }
            if (pState.getValue(IBP) == EBlockPlacePosition.BOTTOM_RIGHT) {
                return SHAPE_D_BR;
            }
        } else {
            if (pState.getValue(IBP) == EBlockPlacePosition.TOP_LEFT) {
                return pState.getValue((Property)FACING) == Direction.NORTH ? SHAPE_N_TL : (pState.getValue((Property)FACING) == Direction.WEST ? SHAPE_W_TL : (pState.getValue((Property)FACING) == Direction.SOUTH ? SHAPE_S_TL : SHAPE_E_TL));
            }
            if (pState.getValue(IBP) == EBlockPlacePosition.TOP_RIGHT) {
                return pState.getValue((Property)FACING) == Direction.NORTH ? SHAPE_N_TR : (pState.getValue((Property)FACING) == Direction.WEST ? SHAPE_W_TR : (pState.getValue((Property)FACING) == Direction.SOUTH ? SHAPE_S_TR : SHAPE_E_TR));
            }
            if (pState.getValue(IBP) == EBlockPlacePosition.BOTTOM_LEFT) {
                return pState.getValue((Property)FACING) == Direction.NORTH ? SHAPE_N_BL : (pState.getValue((Property)FACING) == Direction.WEST ? SHAPE_W_BL : (pState.getValue((Property)FACING) == Direction.SOUTH ? SHAPE_S_BL : SHAPE_E_BL));
            }
            if (pState.getValue(IBP) == EBlockPlacePosition.BOTTOM_RIGHT) {
                return pState.getValue((Property)FACING) == Direction.NORTH ? SHAPE_N_BR : (pState.getValue((Property)FACING) == Direction.WEST ? SHAPE_W_BR : (pState.getValue((Property)FACING) == Direction.SOUTH ? SHAPE_S_BR : SHAPE_E_BR));
            }
            return pState.getValue((Property)FACING) == Direction.NORTH ? SHAPE_N_C : (pState.getValue((Property)FACING) == Direction.WEST ? SHAPE_W_C : (pState.getValue((Property)FACING) == Direction.SOUTH ? SHAPE_S_C : SHAPE_E_C));
        }
        return SHAPE_N_C;
    }

    public BlockState getDefaultPlacementState(BlockPlaceContext context) {
        Direction clickedFace = context.getClickedFace();
        BlockPos blockPos = context.getClickedPos();
        double relX = context.getClickLocation().x - (double)blockPos.getX();
        double relY = context.getClickLocation().y - (double)blockPos.getY();
        double relZ = context.getClickLocation().z - (double)blockPos.getZ();
        Direction finalFacing = clickedFace == Direction.UP || clickedFace == Direction.DOWN ? clickedFace.getOpposite() : clickedFace;
        double u = 0.5;
        double v = 0.5;
        switch (clickedFace) {
            case UP: 
            case DOWN: {
                u = relX;
                v = relZ;
                break;
            }
            case NORTH: {
                u = 1.0 - relX;
                v = 1.0 - relY;
                break;
            }
            case SOUTH: {
                u = relX;
                v = 1.0 - relY;
                break;
            }
            case WEST: {
                u = relZ;
                v = 1.0 - relY;
                break;
            }
            case EAST: {
                u = 1.0 - relZ;
                v = 1.0 - relY;
            }
        }
        EBlockPlacePosition placePosition = QuarterInteriorLightBlock.getEBlockPlacePosition(u, v);
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)finalFacing)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue(IBP, (Comparable)((Object)placePosition));
    }

    @NotNull
    private static EBlockPlacePosition getEBlockPlacePosition(double u, double v) {
        EBlockPlacePosition placePosition = EBlockPlacePosition.CENTER;
        if (u > 0.66) {
            placePosition = v > 0.66 ? EBlockPlacePosition.BOTTOM_RIGHT : (v < 0.33 ? EBlockPlacePosition.TOP_RIGHT : EBlockPlacePosition.CENTER);
        } else if (u < 0.33) {
            placePosition = v > 0.66 ? EBlockPlacePosition.BOTTOM_LEFT : (v < 0.33 ? EBlockPlacePosition.TOP_LEFT : EBlockPlacePosition.CENTER);
        } else if (v > 0.66) {
            placePosition = u > 0.66 ? EBlockPlacePosition.BOTTOM_RIGHT : (u < 0.33 ? EBlockPlacePosition.TOP_RIGHT : EBlockPlacePosition.CENTER);
        } else if (v < 0.33) {
            placePosition = u > 0.66 ? EBlockPlacePosition.BOTTOM_LEFT : (u < 0.33 ? EBlockPlacePosition.TOP_LEFT : EBlockPlacePosition.CENTER);
        }
        return placePosition;
    }
}

