/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils;

import com.gitlab.cdagaming.unilib.core.CoreUtils;
import io.github.cdagaming.unicore.utils.FileUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NbtUtils {
    public static NBTTagCompound getNbt(Entity entity) {
        return entity != null ? NbtUtils.serializeNBT(entity) : new NBTTagCompound();
    }

    public static NBTTagCompound getNbt(ItemStack stack) {
        NBTTagCompound result = new NBTTagCompound();
        return stack != null ? stack.func_77955_b(result) : result;
    }

    public static NBTBase getNbt(Object data, String ... path) {
        if (data instanceof Entity) {
            Entity entity = (Entity)data;
            return NbtUtils.getNbt(entity, path);
        }
        if (data instanceof ItemStack) {
            ItemStack stack = (ItemStack)data;
            return NbtUtils.getNbt(stack, path);
        }
        return null;
    }

    public static NBTBase getNbt(Entity entity, String ... path) {
        return NbtUtils.getNbt(NbtUtils.getNbt(entity), path);
    }

    public static NBTBase getNbt(ItemStack stack, String ... path) {
        return NbtUtils.getNbt(NbtUtils.getNbt(stack), path);
    }

    public static NBTBase getNbt(NBTTagCompound root, String ... path) {
        if (path == null || path.length == 0) {
            return root;
        }
        NBTTagCompound currentTag = root;
        for (int i = 0; i < path.length; ++i) {
            if (currentTag instanceof NBTTagCompound) {
                NBTTagCompound compound = currentTag;
                currentTag = compound.func_74781_a(path[i]);
                continue;
            }
            if (currentTag instanceof NBTTagList) {
                NBTTagList list = (NBTTagList)currentTag;
                int index = Integer.parseInt(path[i]);
                currentTag = list.func_74743_b(index);
                continue;
            }
            if (i == path.length - 1) break;
            return null;
        }
        return currentTag;
    }

    public static Object parseTag(NBTBase tag) {
        if (tag == null) {
            return null;
        }
        switch (tag.func_74732_a()) {
            case 1: {
                return ((NBTTagByte)tag).field_74756_a;
            }
            case 2: {
                return ((NBTTagShort)tag).field_74752_a;
            }
            case 3: {
                return ((NBTTagInt)tag).field_74748_a;
            }
            case 4: {
                return ((NBTTagLong)tag).field_74753_a;
            }
            case 5: {
                return Float.valueOf(((NBTTagFloat)tag).field_74750_a);
            }
            case 6: {
                return ((NBTTagDouble)tag).field_74755_a;
            }
            case 7: {
                return ((NBTTagByteArray)tag).field_74754_a;
            }
            case 8: {
                return ((NBTTagString)tag).field_74751_a;
            }
            case 9: {
                NBTTagList list = (NBTTagList)tag;
                List converted = StringUtils.newArrayList();
                if (list.func_74745_c() <= 0) {
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        converted.add(NbtUtils.parseTag(list.func_74743_b(i)));
                    }
                }
                return converted;
            }
            case 10: {
                try {
                    return FileUtils.toJsonData(tag.toString(), new FileUtils.Modifiers[0]);
                }
                catch (Throwable ex) {
                    CoreUtils.LOG.debugError(ex);
                    return tag.toString();
                }
            }
            case 11: {
                return ((NBTTagIntArray)tag).field_74749_a;
            }
        }
        return tag;
    }

    public static NBTTagCompound serializeNBT(Entity entity) {
        String name = EntityList.func_75621_b((Entity)entity);
        NBTTagCompound ret = new NBTTagCompound();
        if (!StringUtils.isNullOrEmpty(name)) {
            ret.func_74778_a("id", name);
        }
        entity.func_70109_d(ret);
        return ret;
    }
}

