/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.controls;

import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget$jvmdg$StaticDefaults;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;

public class ExtendedButtonControl
extends GuiButton
implements DynamicWidget {
    private String[] optionalArgs;
    private Runnable onPushEvent = null;
    private Runnable onHoverEvent = null;
    private boolean isOverScreen = false;

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, String ... optionalArgs) {
        super(buttonId, x, y, widthIn, heightIn, buttonText);
        this.optionalArgs = optionalArgs;
    }

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String ... optionalArgs) {
        this(buttonId, x, y, widthIn, heightIn, buttonText, optionalArgs);
        this.setOnClick(onPushEvent);
    }

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String ... optionalArgs) {
        this(buttonId, x, y, widthIn, heightIn, buttonText, onPushEvent, optionalArgs);
        this.setOnHover(onHoverEvent);
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, String ... optionalArgs) {
        this(ExtendedScreen.getNextIndex(), x, y, widthIn, heightIn, buttonText, optionalArgs);
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String ... optionalArgs) {
        this(x, y, widthIn, heightIn, buttonText, optionalArgs);
        this.setOnClick(onPushEvent);
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String ... optionalArgs) {
        this(x, y, widthIn, heightIn, buttonText, onPushEvent, optionalArgs);
        this.setOnHover(onHoverEvent);
    }

    public ExtendedButtonControl(int id, int xPos, int yPos, String displayString) {
        this(id, xPos, yPos, 200, 20, displayString, new String[0]);
    }

    public ExtendedButtonControl(int xPos, int yPos, String displayString) {
        this(ExtendedScreen.getNextIndex(), xPos, yPos, displayString);
    }

    @Override
    public void preDraw(ExtendedScreen screen) {
        this.isOverScreen = RenderUtils.isMouseOver(screen);
    }

    @Override
    public void draw(ExtendedScreen screen) {
    }

    @Override
    public void postDraw(ExtendedScreen screen) {
        if (this.isOverScreen() && this.isHoveringOver()) {
            this.onHover();
        }
    }

    public void func_73737_a(@Nonnull Minecraft mc, int mouseX, int mouseY) {
        if (this.isControlVisible()) {
            this.setHoveringOver(this.isOverScreen() && RenderUtils.isMouseOver((double)mouseX, (double)mouseY, this));
            this.func_73739_b(mc, mouseX, mouseY);
            int color = !this.isControlEnabled() ? 0xA0A0A0 : (this.isHoveringOrFocusingOver() ? 0xFFFFA0 : 0xE0E0E0);
            RenderUtils.renderScrollingString(mc, mc.field_71466_p, this.getControlMessage(), this.getLeft() + 2, this.getTop(), this.getRight() - 2, this.getBottom(), color);
        }
    }

    protected void func_73739_b(@Nonnull Minecraft mc, int mouseX, int mouseY) {
        if (this.isControlVisible()) {
            int hoverState = this.func_73738_a(this.isHoveringOrFocusingOver());
            int hoverValue = 46 + hoverState * 20;
            double xOffset = (double)this.getControlWidth() / 2.0;
            RenderUtils.renderButton(mc, this.getControlPosX(), this.getControlPosY(), 0.0, hoverValue, 200.0 - xOffset, hoverValue, xOffset, this.getControlHeight(), this.getZLevel(), RenderUtils.getButtonTexture(mc));
        }
    }

    public boolean func_73736_c(@Nonnull Minecraft arg, int mouseX, int mouseY) {
        return this.isOverScreen() && this.isControlEnabled() && this.isControlVisible() && this.isHoveringOver();
    }

    @Override
    public int getControlWidth() {
        return this.field_73747_a;
    }

    @Override
    public void setControlWidth(int width) {
        this.field_73747_a = width;
    }

    @Override
    public int getControlHeight() {
        return this.field_73745_b;
    }

    @Override
    public void setControlHeight(int height) {
        this.field_73745_b = height;
    }

    @Override
    public int getControlPosX() {
        return this.field_73746_c;
    }

    @Override
    public void setControlPosX(int posX) {
        this.field_73746_c = posX;
    }

    @Override
    public int getControlPosY() {
        return this.field_73743_d;
    }

    @Override
    public void setControlPosY(int posY) {
        this.field_73743_d = posY;
    }

    public boolean isOverScreen() {
        return this.isOverScreen;
    }

    public String[] getOptionalArgs() {
        return (String[])this.optionalArgs.clone();
    }

    public void setOnClick(Runnable event) {
        this.onPushEvent = event;
    }

    public void onClick() {
        if (this.onPushEvent != null) {
            this.onPushEvent.run();
        }
    }

    public void setOnHover(Runnable event) {
        this.onHoverEvent = event;
    }

    public void onHover() {
        if (this.onHoverEvent != null) {
            this.onHoverEvent.run();
        }
    }

    public String getControlMessage() {
        return this.field_73744_e;
    }

    public void setControlMessage(String newMessage) {
        this.field_73744_e = newMessage;
    }

    public boolean isControlEnabled() {
        return this.field_73742_g;
    }

    public void setControlEnabled(boolean isEnabled) {
        this.field_73742_g = isEnabled;
    }

    public boolean isControlVisible() {
        return this.field_73748_h;
    }

    public void setControlVisible(boolean isVisible) {
        this.field_73748_h = isVisible;
    }

    public boolean isHoveringOver() {
        return this.field_82253_i;
    }

    public void setHoveringOver(boolean isHovered) {
        this.field_82253_i = isHovered;
    }

    public boolean isFocusedOver() {
        return false;
    }

    public void setFocusedOver(boolean isFocused) {
    }

    public boolean isHoveringOrFocusingOver() {
        return this.isHoveringOver() || this.isFocusedOver();
    }

    public double getZLevel() {
        return this.field_73735_i;
    }

    public void setZLevel(double zLevel) {
        this.field_73735_i = (float)zLevel;
    }

    @Override
    public int getBottom() {
        return DynamicWidget$jvmdg$StaticDefaults.getBottom(this);
    }

    @Override
    public int getTop() {
        return DynamicWidget$jvmdg$StaticDefaults.getTop(this);
    }

    @Override
    public int getLeft() {
        return DynamicWidget$jvmdg$StaticDefaults.getLeft(this);
    }

    @Override
    public int getRight() {
        return DynamicWidget$jvmdg$StaticDefaults.getRight(this);
    }
}

