/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdagaming.unicore.utils;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import io.github.cdagaming.unicore.UniCore;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.utils.MappingUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import io.github.cdagaming.unicore.utils.UrlUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Stream;
import unilib.external.io.github.classgraph.ClassGraph;
import unilib.external.io.github.classgraph.ClassInfo;
import unilib.external.io.github.classgraph.ScanResult;
import unilib.external.net.lenni0451.reflect.Classes;

public class FileUtils {
    public static final ClassLoader CLASS_LOADER = Thread.currentThread().getContextClassLoader();
    private static final GsonBuilder GSON_BUILDER = new GsonBuilder();
    private static final Map<String, ClassInfo> CLASS_MAP = StringUtils.newHashMap();
    private static final Map<String, Class<?>> CLASS_CACHE = StringUtils.newHashMap();
    private static final Map<String, Pair<ScheduledExecutorService, ThreadFactory>> THREAD_FACTORY_MAP = StringUtils.newHashMap();
    private static boolean ARE_CLASSES_LOADING = false;
    private static boolean ARE_CLASSES_SCANNED = false;
    private static boolean CLASS_GRAPH_ENABLED = true;

    public static void shutdownScheduler(String ... args) {
        for (String name : args) {
            if (!THREAD_FACTORY_MAP.containsKey(name)) continue;
            THREAD_FACTORY_MAP.get(name).getFirst().shutdown();
        }
    }

    public static void shutdownSchedulers() {
        for (Pair<ScheduledExecutorService, ThreadFactory> data : THREAD_FACTORY_MAP.values()) {
            data.getFirst().shutdown();
        }
    }

    public static Pair<ScheduledExecutorService, ThreadFactory> getOrCreateScheduler(String name) {
        if (!THREAD_FACTORY_MAP.containsKey(name)) {
            ThreadFactory threadFactory = (ThreadFactory)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Runnable;)Ljava/lang/Thread;, lambda$getOrCreateScheduler$0(java.lang.String java.lang.Runnable ), (Ljava/lang/Runnable;)Ljava/lang/Thread;)((String)name);
            ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor(threadFactory);
            THREAD_FACTORY_MAP.put(name, new Pair<ScheduledExecutorService, ThreadFactory>(exec, threadFactory));
        }
        return THREAD_FACTORY_MAP.get(name);
    }

    public static ScheduledExecutorService getThreadPool(String name) {
        return FileUtils.getOrCreateScheduler(name).getFirst();
    }

    public static ThreadFactory getThreadFactory(String name) {
        return FileUtils.getOrCreateScheduler(name).getSecond();
    }

    public static <T> T getJsonData(URL url, String encoding, Class<T> targetClass, Modifiers ... args) throws Exception {
        return (T)FileUtils.getJsonData(UrlUtils.getURLText(url, encoding), targetClass, args);
    }

    public static <T> T getJsonData(URL url, Class<T> targetClass, Modifiers ... args) throws Exception {
        return FileUtils.getJsonData(url, "UTF-8", targetClass, args);
    }

    public static <T> T getJsonFromURL(String url, String encoding, Class<T> targetClass, Modifiers ... args) throws Exception {
        return FileUtils.getJsonData(new URL(url), encoding, targetClass, args);
    }

    public static <T> T getJsonFromURL(String url, Class<T> targetClass, Modifiers ... args) throws Exception {
        return FileUtils.getJsonFromURL(url, "UTF-8", targetClass, args);
    }

    public static <T> T getJsonData(File data, String encoding, Class<T> classObj, Modifiers ... args) throws Exception {
        return (T)FileUtils.getJsonData(FileUtils.fileToString(data, encoding), classObj, args);
    }

    public static <T> T getJsonData(File data, Class<T> classObj, Modifiers ... args) throws Exception {
        return FileUtils.getJsonData(data, "UTF-8", classObj, args);
    }

    public static <T> T getJsonData(String data, Class<T> classObj, Modifiers ... args) {
        GsonBuilder builder = FileUtils.applyModifiers(GSON_BUILDER, args);
        return (T)builder.create().fromJson(data, classObj);
    }

    public static <T> T getJsonData(File data, String encoding, Type typeObj, Modifiers ... args) throws Exception {
        return FileUtils.getJsonData(FileUtils.fileToString(data, encoding), typeObj, args);
    }

    public static <T> T getJsonData(File data, Type typeObj, Modifiers ... args) throws Exception {
        return FileUtils.getJsonData(data, "UTF-8", typeObj, args);
    }

    public static <T> T getJsonData(String data, Type typeObj, Modifiers ... args) {
        GsonBuilder builder = FileUtils.applyModifiers(GSON_BUILDER, args);
        return (T)builder.create().fromJson(data, typeObj);
    }

    public static <T> T getJsonData(T data, Class<T> classObj, Modifiers ... args) {
        return (T)FileUtils.getJsonData(data.toString(), classObj, args);
    }

    public static String toJsonData(Object obj, Modifiers ... args) {
        GsonBuilder builder = FileUtils.applyModifiers(GSON_BUILDER, args);
        if (obj instanceof String || obj instanceof Reader || obj instanceof JsonReader) {
            obj = FileUtils.parseJson(obj);
        }
        return builder.create().toJson(obj);
    }

    public static JsonElement parseJson(Object json) {
        if (json instanceof String) {
            return new JsonParser().parse((String)json);
        }
        if (json instanceof Reader) {
            return new JsonParser().parse((Reader)json);
        }
        if (json instanceof JsonReader) {
            return new JsonParser().parse((JsonReader)json);
        }
        return null;
    }

    public static void writeJsonData(Object json, File file, String encoding, Modifiers ... args) {
        GsonBuilder builder = FileUtils.applyModifiers(GSON_BUILDER, args);
        try {
            FileUtils.assertFileExists(file);
        }
        catch (Exception ex1) {
            UniCore.LOG.error("Failed to create json data @ " + file.getAbsolutePath(), new Object[0]);
            UniCore.LOG.debugError(ex1);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), Charset.forName(encoding));){
            builder.create().toJson(json, (Appendable)writer);
        }
        catch (Exception ex2) {
            UniCore.LOG.error("Failed to write json data @ " + file.getAbsolutePath(), new Object[0]);
            UniCore.LOG.debugError(ex2);
        }
    }

    public static void assertFileExists(File file) throws Exception {
        boolean fileAvailable;
        File parentDir = file.getParentFile();
        boolean parentDirPresent = file.getParentFile().exists() || file.getParentFile().mkdirs();
        boolean bl = fileAvailable = file.exists() && file.isFile() || file.createNewFile();
        if (!parentDirPresent) {
            throw new UnsupportedOperationException("Failed to setup parent directory @ " + parentDir.getAbsolutePath());
        }
        if (!fileAvailable) {
            throw new UnsupportedOperationException("Failed to setup target file (Unable to create or is not a file) @ " + file.getAbsolutePath());
        }
    }

    public static void downloadFile(String urlString, File file) {
        try {
            UniCore.LOG.info("Downloading \"%s\" to \"%s\"... (From: \"%s\")", file.getName(), file.getAbsolutePath(), urlString);
            URL url = new URL(urlString);
            if (file.exists() && !file.delete()) {
                UniCore.LOG.error("Failed to remove: " + file.getName(), new Object[0]);
            }
            FileUtils.copyStreamToFile(UrlUtils.getURLStream(url), file);
            UniCore.LOG.info("\"%s\" has been successfully downloaded to \"%s\"! (From: \"%s\")", file.getName(), file.getAbsolutePath(), urlString);
        }
        catch (Exception ex) {
            UniCore.LOG.error("Failed to download \"%s\" from \"%s\"", file.getName(), urlString);
            UniCore.LOG.debugError(ex);
        }
    }

    public static void copyStreamToFile(InputStream stream, File file, boolean close) throws Exception {
        FileUtils.assertFileExists(file);
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = stream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, length);
            }
        }
        if (close) {
            stream.close();
        }
    }

    public static void copyStreamToFile(InputStream stream, File file) throws Exception {
        FileUtils.copyStreamToFile(stream, file, true);
    }

    public static void copyToFile(InputStream stream, File file) throws Exception {
        FileUtils.copyStreamToFile(stream, file, false);
    }

    public static String fileToString(File file, String encoding) throws Exception {
        return FileUtils.fileToString(Files.newInputStream(file.toPath(), new OpenOption[0]), encoding);
    }

    public static String fileToString(InputStream stream, String encoding) throws Exception {
        return UrlUtils.readerToString(new BufferedReader(new InputStreamReader(stream, Charset.forName(encoding))));
    }

    public static InputStream stringToStream(String stream, String encoding) {
        return new ByteArrayInputStream(StringUtils.getBytes(stream, encoding));
    }

    public static String getFileExtension(File file) {
        return FileUtils.getFileExtension(file.getName());
    }

    public static String getFileExtension(String name) {
        int lastIndexOf = name.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return "";
        }
        return name.substring(lastIndexOf);
    }

    public static String getFileNameWithoutExtension(File file) {
        return FileUtils.getFileNameWithoutExtension(file.getName());
    }

    public static String getFileNameWithoutExtension(String name) {
        if (name.indexOf(".") > 0) {
            return name.substring(0, name.lastIndexOf("."));
        }
        return name;
    }

    public static Map<String, ClassInfo> getClassNamesMatchingSuperType(List<Class<?>> searchList, String ... sourcePackages) {
        Map<String, ClassInfo> matchingClasses = StringUtils.newHashMap();
        if (!FileUtils.isClassGraphEnabled()) {
            return matchingClasses;
        }
        Map<String, ClassInfo> subClassData = StringUtils.newHashMap();
        block0: for (Map.Entry<String, ClassInfo> classInfo : FileUtils.getClasses(sourcePackages).entrySet()) {
            for (Class<?> searchClass : searchList) {
                if (FileUtils.isSubclassOf(classInfo.getValue(), searchClass, subClassData)) {
                    for (Map.Entry<String, ClassInfo> subClassInfo : subClassData.entrySet()) {
                        if (matchingClasses.containsKey(subClassInfo.getKey())) continue;
                        matchingClasses.put(subClassInfo.getKey(), subClassInfo.getValue());
                    }
                    continue block0;
                }
                subClassData.clear();
            }
        }
        return matchingClasses;
    }

    protected static boolean isSubclassOf(ClassInfo originalClass, Class<?> superClass, Map<String, ClassInfo> scannedClasses) {
        if (!FileUtils.isClassGraphEnabled() || originalClass == null || superClass == null) {
            return false;
        }
        String superClassName = MappingUtils.getCanonicalName(superClass);
        Set visitedClasses = StringUtils.newHashSet();
        ArrayDeque<ClassInfo> stack = new ArrayDeque<ClassInfo>();
        stack.push(originalClass);
        while (!stack.isEmpty()) {
            ClassInfo currentClass = (ClassInfo)stack.pop();
            if (!visitedClasses.add(currentClass)) continue;
            String className = MappingUtils.getCanonicalName(currentClass);
            scannedClasses.put(className, currentClass);
            if (className.equals(superClassName)) {
                return true;
            }
            ClassInfo superClassInfo = currentClass.getSuperclass();
            if (superClassInfo == null || visitedClasses.contains(superClassInfo)) continue;
            stack.push(superClassInfo);
        }
        return false;
    }

    public static Map<String, ClassInfo> getClassNamesMatchingSuperType(Class<?> searchTarget, String ... sourcePackages) {
        return FileUtils.getClassNamesMatchingSuperType(StringUtils.newArrayList(searchTarget), sourcePackages);
    }

    public static <T> T castOrConvert(Object obj, Class<T> targetClass) {
        if (targetClass.isAssignableFrom(obj.getClass())) {
            return targetClass.cast(obj);
        }
        if (obj instanceof String) {
            return FileUtils.convertStringToType((String)obj, targetClass);
        }
        UniCore.LOG.debugError("Conversion or casting not supported between " + obj.getClass().getSimpleName() + " and " + targetClass.getSimpleName(), new Object[0]);
        return null;
    }

    private static <T> T convertStringToType(String value, Class<T> targetType) {
        Comparable<Boolean> obj;
        if (targetType.equals(Boolean.class) || targetType.equals(Boolean.TYPE)) {
            obj = Boolean.valueOf(value);
        } else if (targetType.equals(Byte.class) || targetType.equals(Byte.TYPE)) {
            obj = Byte.valueOf(value);
        } else if (targetType.equals(Short.class) || targetType.equals(Short.TYPE)) {
            obj = Short.valueOf(value);
        } else if (targetType.equals(Integer.class) || targetType.equals(Integer.TYPE)) {
            obj = Integer.valueOf(value);
        } else if (targetType.equals(Long.class) || targetType.equals(Long.TYPE)) {
            obj = Long.valueOf(value);
        } else if (targetType.equals(Float.class) || targetType.equals(Float.TYPE)) {
            obj = Float.valueOf(value);
        } else if (targetType.equals(Double.class) || targetType.equals(Double.TYPE)) {
            obj = Double.valueOf(value);
        } else {
            UniCore.LOG.debugError("Conversion not supported for: " + targetType.getSimpleName(), new Object[0]);
            return null;
        }
        return (T)obj;
    }

    public static Class<?> getValidClass(ClassLoader loader, boolean init, boolean forceCache, String ... paths) {
        List<String> classList = StringUtils.newArrayList(paths);
        for (String path : paths) {
            StringUtils.addEntriesNotPresent(classList, MappingUtils.getUnmappedClassesMatching(path, true));
        }
        Iterator<String> iterator = classList.iterator();
        while (iterator.hasNext()) {
            Class<?> result;
            String path;
            switch (path = (String)iterator.next()) {
                case "boolean": {
                    return Boolean.TYPE;
                }
                case "byte": {
                    return Byte.TYPE;
                }
                case "short": {
                    return Short.TYPE;
                }
                case "int": {
                    return Integer.TYPE;
                }
                case "long": {
                    return Long.TYPE;
                }
                case "float": {
                    return Float.TYPE;
                }
                case "double": {
                    return Double.TYPE;
                }
                case "char": {
                    return Character.TYPE;
                }
                case "void": {
                    return Void.TYPE;
                }
            }
            if (!CLASS_CACHE.containsKey(path) || forceCache) {
                result = null;
                try {
                    result = Class.forName(path, init, loader != null ? loader : Classes.getCallerClass(1).getClassLoader());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (result != null) {
                    CLASS_CACHE.put(path, result);
                }
                return result;
            }
            result = CLASS_CACHE.get(path);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Class<?> getValidClass(ClassLoader loader, boolean init, String ... paths) {
        return FileUtils.getValidClass(loader, init, false, paths);
    }

    public static Class<?> findClass(ClassLoader loader, String ... paths) {
        return FileUtils.getValidClass(loader, false, paths);
    }

    public static Class<?> loadClass(ClassLoader loader, String ... paths) {
        return FileUtils.getValidClass(loader, true, paths);
    }

    public static Class<?> findClass(String ... paths) {
        return FileUtils.findClass(null, paths);
    }

    public static Class<?> loadClass(String ... paths) {
        return FileUtils.loadClass(null, paths);
    }

    public static boolean canScanClasses() {
        return !ARE_CLASSES_LOADING;
    }

    public static boolean hasScannedClasses() {
        return ARE_CLASSES_SCANNED;
    }

    public static boolean isClassGraphEnabled() {
        return CLASS_GRAPH_ENABLED;
    }

    public static void setClassGraphEnabled(boolean isEnabled) {
        CLASS_GRAPH_ENABLED = isEnabled;
    }

    public static void detectClasses() {
        if (FileUtils.isClassGraphEnabled()) {
            UniCore.getThreadFactory().newThread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, getClassMap(), ()V)()).start();
        }
    }

    public static Map<String, ClassInfo> getClassMap() {
        if (FileUtils.isClassGraphEnabled() && FileUtils.canScanClasses() && !FileUtils.hasScannedClasses()) {
            ARE_CLASSES_LOADING = true;
            ClassGraph graphInfo = new ClassGraph().enableClassInfo().rejectPackages("net.java", "com.sun", "com.jcraft", "com.intellij", "jdk", "akka", "ibxm", "scala", "*.mixin.*", "*.mixins.*", "*.jetty.*").disableModuleScanning();
            graphInfo.addClassLoader(CLASS_LOADER);
            try (ScanResult scanResult = graphInfo.scan();){
                for (ClassInfo result : scanResult.getAllClasses()) {
                    String resultName = MappingUtils.getMappedPath(result.getName());
                    if (CLASS_MAP.containsKey(resultName) || resultName.toLowerCase().contains("mixin")) continue;
                    CLASS_MAP.put(resultName, result);
                }
            }
            catch (Throwable ex) {
                UniCore.LOG.debugError(ex);
            }
            ARE_CLASSES_LOADING = false;
            ARE_CLASSES_SCANNED = true;
        }
        return StringUtils.newHashMap(CLASS_MAP);
    }

    public static void clearClassMap(boolean allowReScan) {
        if (allowReScan) {
            ARE_CLASSES_SCANNED = false;
        }
        CLASS_MAP.clear();
    }

    public static void clearClassMap() {
        FileUtils.clearClassMap(false);
    }

    public static void clearClassCache() {
        CLASS_CACHE.clear();
    }

    public static Map<String, ClassInfo> getClasses(String ... paths) {
        boolean hasNoPaths;
        Map<String, ClassInfo> results = StringUtils.newHashMap();
        if (!FileUtils.isClassGraphEnabled()) {
            return results;
        }
        Map<Object, Set<String>> unmappedNames = StringUtils.newHashMap();
        boolean bl = hasNoPaths = paths == null || paths.length == 0;
        if (!hasNoPaths) {
            for (String path : paths) {
                unmappedNames.put(path, MappingUtils.getUnmappedClassesMatching(path));
            }
        }
        for (Map.Entry entry : FileUtils.getClassMap().entrySet()) {
            if (entry == null) continue;
            String classPath = (String)entry.getKey();
            boolean hasMatch = hasNoPaths;
            if (!hasNoPaths) {
                for (String path : paths) {
                    Set unmapped = (Set)unmappedNames.get(path);
                    if (!classPath.startsWith(path) && !unmapped.contains(classPath)) continue;
                    hasMatch = true;
                    break;
                }
            }
            if (!hasMatch) continue;
            try {
                results.put(classPath, (ClassInfo)entry.getValue());
            }
            catch (Throwable throwable) {}
        }
        return results;
    }

    public static List<String> filesInDir(Class<?> fallbackClass, String pathToSearch) {
        List<String> paths = StringUtils.newArrayList();
        if (!pathToSearch.endsWith("/")) {
            pathToSearch = pathToSearch + "/";
        }
        try {
            Path myPath;
            URI uri = FileUtils.getResource(fallbackClass, pathToSearch).toURI();
            FileSystem fileSystem = null;
            if (uri.getScheme().equals("jar")) {
                try {
                    fileSystem = FileSystems.getFileSystem(uri);
                }
                catch (Exception ex) {
                    fileSystem = FileSystems.newFileSystem(uri, StringUtils.newHashMap());
                }
                myPath = fileSystem.getPath(pathToSearch, new String[0]);
            } else {
                myPath = Paths.get(uri);
            }
            Stream<Path> walk = Files.walk(myPath, 1, new FileVisitOption[0]);
            try {
                Iterator it = walk.iterator();
                it.next();
                while (it.hasNext()) {
                    paths.add(pathToSearch + ((Path)it.next()).getFileName());
                }
            }
            catch (Throwable ex) {
                if (walk != null) {
                    try {
                        walk.close();
                    }
                    catch (Throwable ex2) {
                        ex.addSuppressed(ex2);
                    }
                }
                throw ex;
            }
            walk.close();
            if (fileSystem != null) {
                fileSystem.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return paths;
    }

    public static InputStream getResourceAsStream(Class<?> fallbackClass, String pathToSearch) {
        InputStream in = null;
        boolean useFallback = false;
        try {
            in = CLASS_LOADER.getResourceAsStream(pathToSearch);
        }
        catch (Exception ex) {
            useFallback = true;
        }
        if (useFallback || in == null) {
            in = fallbackClass.getResourceAsStream(pathToSearch);
        }
        return in;
    }

    public static URL getResource(Class<?> fallbackClass, String pathToSearch) {
        URL in = null;
        boolean useFallback = false;
        try {
            in = CLASS_LOADER.getResource(pathToSearch);
        }
        catch (Exception ex) {
            useFallback = true;
        }
        if (useFallback || in == null) {
            in = fallbackClass.getResource(pathToSearch);
        }
        return in;
    }

    public static GsonBuilder applyModifiers(GsonBuilder instance, Modifiers ... args) {
        block4: for (Modifiers param : args) {
            switch (param) {
                case DISABLE_ESCAPES: {
                    instance.disableHtmlEscaping();
                    continue block4;
                }
                case PRETTY_PRINT: {
                    instance.setPrettyPrinting();
                    continue block4;
                }
            }
        }
        return instance;
    }

    private static /* synthetic */ Thread lambda$getOrCreateScheduler$0(String name, Runnable r) {
        Thread t = new Thread(r, name);
        t.setDaemon(true);
        return t;
    }

    public static enum Modifiers {
        DISABLE_ESCAPES,
        PRETTY_PRINT;

    }
}

