/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.core.impl.screen;

import java.util.Arrays;
import javax.annotation.Nullable;
import unilib.jvmdg.api.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@RecordComponents(value={@RecordComponents.Value(name="posX", type=int.class), @RecordComponents.Value(name="posY", type=int.class), @RecordComponents.Value(name="width", type=int.class), @RecordComponents.Value(name="height", type=int.class)})
public final class ScreenRectangle
extends J_L_Record {
    private final int posX;
    private final int posY;
    private final int width;
    private final int height;
    private static final ScreenRectangle EMPTY = new ScreenRectangle(0, 0, 0, 0);

    public ScreenRectangle(int posX, int posY, int width, int height) {
        this.posX = posX;
        this.posY = posY;
        this.width = width;
        this.height = height;
    }

    public static ScreenRectangle empty() {
        return EMPTY;
    }

    @Nullable
    public ScreenRectangle intersection(ScreenRectangle rectangle) {
        int i = Math.max(this.getLeft(), rectangle.getLeft());
        int j = Math.max(this.getTop(), rectangle.getTop());
        int k = Math.min(this.getRight(), rectangle.getRight());
        int l = Math.min(this.getBottom(), rectangle.getBottom());
        return i < k && j < l ? new ScreenRectangle(i, j, k - i, l - j) : null;
    }

    public int posX() {
        return this.posX;
    }

    public int posY() {
        return this.posY;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int getTop() {
        return this.posY();
    }

    public int getBottom() {
        return this.posY() + this.height();
    }

    public int getLeft() {
        return this.posX();
    }

    public int getRight() {
        return this.posX() + this.width();
    }

    @Override
    public final String toString() {
        return ScreenRectangle.jvmdowngrader$toString$toString(this);
    }

    @Override
    public final int hashCode() {
        return ScreenRectangle.jvmdowngrader$hashCode$hashCode(this);
    }

    @Override
    public final boolean equals(Object o) {
        return ScreenRectangle.jvmdowngrader$equals$equals(this, o);
    }

    private static String jvmdowngrader$toString$toString(ScreenRectangle screenRectangle) {
        ScreenRectangle screenRectangle2 = screenRectangle;
        return "ScreenRectangle[" + "posX=" + screenRectangle.posX + ", " + "posY=" + screenRectangle.posY + ", " + "width=" + screenRectangle.width + ", " + "height=" + screenRectangle.height + "]";
    }

    private static int jvmdowngrader$hashCode$hashCode(ScreenRectangle screenRectangle) {
        Object[] objectArray = new Object[]{screenRectangle.posX, screenRectangle.posY, screenRectangle.width, screenRectangle.height};
        return Arrays.hashCode(objectArray);
    }

    private static boolean jvmdowngrader$equals$equals(ScreenRectangle screenRectangle, Object object) {
        if (screenRectangle == object) {
            return true;
        }
        if (object != null && object instanceof ScreenRectangle) {
            ScreenRectangle screenRectangle2 = (ScreenRectangle)object;
            if (screenRectangle.posX == screenRectangle2.posX && screenRectangle.posY == screenRectangle2.posY && screenRectangle.width == screenRectangle2.width && screenRectangle.height == screenRectangle2.height) {
                return true;
            }
        }
        return false;
    }
}

