/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.imageio.plugins.webp.lossless;

import java.awt.image.WritableRaster;
import unilib.external.com.twelvemonkeys.imageio.plugins.webp.lossless.Transform;

final class ColorIndexingTransform
implements Transform {
    private final byte[] colorTable;
    private final byte bits;

    public ColorIndexingTransform(byte[] byArray, byte by) {
        this.colorTable = byArray;
        this.bits = by;
    }

    @Override
    public void applyInverse(WritableRaster writableRaster) {
        int n2 = writableRaster.getWidth();
        int n3 = writableRaster.getHeight();
        byte[] byArray = new byte[4];
        for (int i = 0; i < n3; ++i) {
            for (int j = n2 - 1; j >= 0; --j) {
                int n4 = 8 >> this.bits;
                int n5 = 1 << this.bits;
                int n6 = j / n5;
                int n7 = n4 * (j % n5);
                int n8 = writableRaster.getSample(n6, i, 1);
                int n9 = n8 >> n7 & (1 << n4) - 1;
                System.arraycopy(this.colorTable, n9 * 4, byArray, 0, 4);
                writableRaster.setDataElements(j, i, byArray);
            }
        }
    }
}

