/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.imageio.stream;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import unilib.external.com.twelvemonkeys.lang.Validate;

@Deprecated
public final class BufferedImageInputStream
extends ImageInputStreamImpl
implements ImageInputStream {
    static final int DEFAULT_BUFFER_SIZE = 8192;
    private ImageInputStream stream;
    private ByteBuffer buffer;
    private final ByteBuffer integralCache = ByteBuffer.allocate(8);
    private final byte[] integralCacheArray = this.integralCache.array();

    public BufferedImageInputStream(ImageInputStream imageInputStream) throws IOException {
        this(imageInputStream, 8192);
    }

    private BufferedImageInputStream(ImageInputStream imageInputStream, int n2) throws IOException {
        this.stream = Validate.notNull(imageInputStream, "stream");
        this.streamPos = imageInputStream.getStreamPosition();
        this.buffer = ByteBuffer.allocate(n2);
        this.buffer.limit(0);
    }

    private void fillBuffer() throws IOException {
        this.buffer.clear();
        int n2 = this.stream.read(this.buffer.array(), 0, this.buffer.capacity());
        if (n2 >= 0) {
            this.buffer.position(n2);
            this.buffer.flip();
        } else {
            this.buffer.limit(0);
        }
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        super.setByteOrder(byteOrder);
        this.integralCache.order(byteOrder);
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (!this.buffer.hasRemaining()) {
            this.fillBuffer();
            if (!this.buffer.hasRemaining()) {
                return -1;
            }
        }
        this.bitOffset = 0;
        ++this.streamPos;
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        if (!this.buffer.hasRemaining()) {
            if (n3 >= this.buffer.capacity()) {
                return this.readDirect(byArray, n2, n3);
            }
            this.fillBuffer();
        }
        return this.readBuffered(byArray, n2, n3);
    }

    private int readDirect(byte[] byArray, int n2, int n3) throws IOException {
        this.buffer.limit(0);
        int n4 = this.stream.read(byArray, n2, n3);
        if (n4 > 0) {
            this.streamPos += (long)n4;
        }
        return n4;
    }

    private int readBuffered(byte[] byArray, int n2, int n3) {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        int n4 = Math.min(this.buffer.remaining(), n3);
        if (n4 > 0) {
            int n5 = this.buffer.position();
            System.arraycopy(this.buffer.array(), n5, byArray, n2, n4);
            this.buffer.position(n5 + n4);
        }
        this.streamPos += (long)n4;
        return n4;
    }

    @Override
    public short readShort() throws IOException {
        this.readFully(this.integralCacheArray, 0, 2);
        return this.integralCache.getShort(0);
    }

    @Override
    public int readInt() throws IOException {
        this.readFully(this.integralCacheArray, 0, 4);
        return this.integralCache.getInt(0);
    }

    @Override
    public long readLong() throws IOException {
        this.readFully(this.integralCacheArray, 0, 8);
        return this.integralCache.getLong(0);
    }

    @Override
    public int readBit() throws IOException {
        this.checkClosed();
        if (!this.buffer.hasRemaining()) {
            this.fillBuffer();
            if (!this.buffer.hasRemaining()) {
                throw new EOFException();
            }
        }
        int n2 = this.bitOffset + 1 & 7;
        int n3 = this.buffer.get() & 0xFF;
        if (n2 != 0) {
            this.buffer.position(this.buffer.position() - 1);
            n3 >>= 8 - n2;
        } else {
            ++this.streamPos;
        }
        this.bitOffset = n2;
        return n3 & 1;
    }

    @Override
    public long readBits(int n2) throws IOException {
        int n3;
        this.checkClosed();
        if (n2 < 0 || n2 > 64) {
            throw new IllegalArgumentException();
        }
        if (n2 == 0) {
            return 0L;
        }
        int n4 = this.bitOffset + n2 & 7;
        long l2 = 0L;
        for (n3 = n2 + this.bitOffset; n3 > 0; n3 -= 8) {
            if (!this.buffer.hasRemaining()) {
                this.fillBuffer();
                if (!this.buffer.hasRemaining()) {
                    throw new EOFException();
                }
            }
            int n5 = this.buffer.get() & 0xFF;
            ++this.streamPos;
            l2 <<= 8;
            l2 |= (long)n5;
        }
        if (n4 != 0) {
            this.buffer.position(this.buffer.position() - 1);
            --this.streamPos;
        }
        this.bitOffset = n4;
        l2 >>>= -n3;
        return l2 &= -1L >>> 64 - n2;
    }

    @Override
    public void seek(long l2) throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        if (this.streamPos == l2) {
            return;
        }
        long l3 = (long)this.buffer.position() + l2 - this.streamPos;
        if (l3 >= 0L && l3 <= (long)this.buffer.limit()) {
            this.buffer.position((int)l3);
        } else {
            this.buffer.limit(0);
            this.stream.seek(l2);
        }
        this.streamPos = l2;
    }

    @Override
    public void flushBefore(long l2) throws IOException {
        this.checkClosed();
        this.stream.flushBefore(l2);
    }

    @Override
    public long getFlushedPosition() {
        return this.stream.getFlushedPosition();
    }

    @Override
    public boolean isCached() {
        return this.stream.isCached();
    }

    @Override
    public boolean isCachedMemory() {
        return this.stream.isCachedMemory();
    }

    @Override
    public boolean isCachedFile() {
        return this.stream.isCachedFile();
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream = null;
            this.buffer = null;
        }
        super.close();
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public long length() {
        try {
            return this.stream.length();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }
}

