/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.imageio.stream;

import java.io.IOException;
import javax.imageio.stream.ImageInputStreamImpl;
import unilib.external.com.twelvemonkeys.lang.Validate;

public final class ByteArrayImageInputStream
extends ImageInputStreamImpl {
    private final byte[] data;
    private final int dataOffset;
    private final int dataLength;

    public ByteArrayImageInputStream(byte[] byArray) {
        this(byArray, 0, byArray != null ? byArray.length : -1);
    }

    public ByteArrayImageInputStream(byte[] byArray, int n2, int n3) {
        this.data = Validate.notNull(byArray, "data");
        this.dataOffset = ByteArrayImageInputStream.isMax(byArray.length, n2, "offset");
        this.dataLength = ByteArrayImageInputStream.isMax(byArray.length - n2, n3, "length");
    }

    private static int isMax(int n2, int n3, String string) {
        return Validate.isTrue(n3 >= 0 && n3 <= n2, n3, String.format("%s out of range [0, %d]: %d", string, n2, n3));
    }

    @Override
    public int read() throws IOException {
        if (this.streamPos >= (long)this.dataLength) {
            return -1;
        }
        this.bitOffset = 0;
        return this.data[(int)this.streamPos++ + this.dataOffset] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.streamPos >= (long)this.dataLength) {
            return -1;
        }
        int n4 = (int)Math.min((long)this.dataLength - this.streamPos, (long)n3);
        this.bitOffset = 0;
        System.arraycopy(this.data, (int)this.streamPos + this.dataOffset, byArray, n2, n4);
        this.streamPos += (long)n4;
        return n4;
    }

    @Override
    public long length() {
        return this.dataLength;
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public boolean isCachedMemory() {
        return true;
    }
}

