/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.lang;

import java.util.Date;
import java.util.TimeZone;

public final class DateUtil {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long CALENDAR_YEAR = 31556952000L;

    private DateUtil() {
    }

    public static long delta(long l2) {
        return System.currentTimeMillis() - l2;
    }

    public static long delta(Date date) {
        return System.currentTimeMillis() - date.getTime();
    }

    public static long currentTimeSecond() {
        return DateUtil.roundToSecond(System.currentTimeMillis());
    }

    public static long currentTimeMinute() {
        return DateUtil.roundToMinute(System.currentTimeMillis());
    }

    public static long currentTimeHour() {
        return DateUtil.roundToHour(System.currentTimeMillis());
    }

    public static long currentTimeDay() {
        return DateUtil.roundToDay(System.currentTimeMillis());
    }

    public static long roundToSecond(long l2) {
        return l2 / 1000L * 1000L;
    }

    public static long roundToMinute(long l2) {
        return l2 / 60000L * 60000L;
    }

    public static long roundToHour(long l2) {
        return DateUtil.roundToHour(l2, TimeZone.getDefault());
    }

    public static long roundToHour(long l2, TimeZone timeZone) {
        int n2 = timeZone.getOffset(l2);
        return l2 / 3600000L * 3600000L - (long)n2;
    }

    public static long roundToDay(long l2) {
        return DateUtil.roundToDay(l2, TimeZone.getDefault());
    }

    public static long roundToDay(long l2, TimeZone timeZone) {
        int n2 = timeZone.getOffset(l2);
        return (l2 + (long)n2) / 86400000L * 86400000L - (long)n2;
    }
}

