/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils;

import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;

public class ItemUtils {
    public static final wk EMPTY_ITEM = null;
    public static final wm EMPTY_STACK = null;
    private static final List<wk> EMPTY_ITEMS = StringUtils.newArrayList(EMPTY_ITEM);

    public static wm getStackFrom(Object data) {
        wm itemStack = null;
        if (data != null) {
            if (data instanceof apa) {
                apa block = (apa)data;
                data = ItemUtils.getDefaultInstance(block);
            }
            if (data instanceof wk) {
                wk item = (wk)data;
                data = ItemUtils.getDefaultInstance(item);
            }
            if (data instanceof wm) {
                wm stack;
                itemStack = stack = (wm)data;
            }
        }
        return itemStack;
    }

    public static wk getItemFromStack(wm stack) {
        return stack != null ? stack.b() : EMPTY_ITEM;
    }

    public static int getStackCount(wm stack) {
        return stack != null ? stack.a : 0;
    }

    public static int getStackDamage(wm stack) {
        return stack != null ? stack.k() : 0;
    }

    public static boolean isItemEmpty(Object data) {
        wm stack = ItemUtils.getStackFrom(data);
        if (stack == null || stack.equals(EMPTY_STACK)) {
            return true;
        }
        return EMPTY_ITEMS.contains(ItemUtils.getItemFromStack(stack)) || ItemUtils.getStackCount(stack) <= 0 || !MathUtils.isWithinValue(ItemUtils.getStackDamage(stack), -32768.0, 65535.0);
    }

    public static wm getDefaultInstance(apa block) {
        return new wm(block);
    }

    public static wm getDefaultInstance(wk item) {
        return new wm(item);
    }

    public static String getItemName(Object data, boolean stripFormatting) {
        wm stack = ItemUtils.getStackFrom(data);
        String result = "";
        if (!ItemUtils.isItemEmpty(stack)) {
            result = StringUtils.getOrDefault(stack.s());
        }
        if (stripFormatting) {
            result = StringUtils.stripAllFormatting(result);
        }
        return result;
    }

    public static String getItemName(Object data) {
        return ItemUtils.getItemName(data, true);
    }

    public static boolean isRawTE(String name) {
        if (!StringUtils.isNullOrEmpty(name)) {
            String lowerName = name.toLowerCase();
            return lowerName.contains("tile.") || lowerName.contains("item.") || lowerName.contains(".") || lowerName.contains(".name");
        }
        return false;
    }
}

